/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.util.Arrays;
import org.jboss.ejb.client.NodeAssociatedSessionID;
import org.jboss.ejb.client.UnknownSessionID;

public abstract class SessionID
implements Serializable {
    private static final long serialVersionUID = 3872192729805797520L;
    private final byte[] encodedForm;
    private final transient int hashCode;

    SessionID(byte[] encodedForm) {
        this.encodedForm = encodedForm;
        this.hashCode = Arrays.hashCode(encodedForm);
    }

    public byte[] getEncodedForm() {
        return (byte[])this.encodedForm.clone();
    }

    protected byte[] getEncodedFormRaw() {
        return this.encodedForm;
    }

    public final boolean equals(Object other) {
        return other.getClass() == this.getClass() && this.equals((SessionID)other);
    }

    private boolean equals(SessionID other) {
        return this == other || other != null && Arrays.equals(this.encodedForm, other.encodedForm);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public static SessionID createSessionID(byte[] encoded) {
        int length = encoded.length;
        if (length >= 19 && encoded[0] == 7) {
            return new NodeAssociatedSessionID((byte[])encoded.clone());
        }
        return new UnknownSessionID((byte[])encoded.clone());
    }

    protected final Object writeReplace() {
        return new Serialized(this.encodedForm);
    }

    public String toString() {
        return "{" + Arrays.toString(this.encodedForm) + '}';
    }

    public static final class Serialized
    implements Serializable {
        private static final long serialVersionUID = -6014782612354158572L;
        private final byte[] id;

        Serialized(byte[] id) {
            this.id = id;
        }

        protected Object readResolve() {
            return SessionID.createSessionID(this.id);
        }
    }
}

