/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBHandle;
import org.jboss.ejb.client.EJBHomeHandle;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.ejb.client.SerializedEJBInvocationHandler;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.annotation.CompressionHint;

final class EJBInvocationHandler<T>
extends Attachable
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 946555285095057230L;
    private static final String ENABLE_ANNOTATION_SCANNING_SYSTEM_PROPERTY = "org.jboss.ejb.client.view.annotation.scan.enabled";
    private final transient boolean async;
    private final EJBLocator<T> locator;
    private volatile Affinity weakAffinity = Affinity.NONE;
    private final transient EJBClientContextIdentifier ejbClientContextIdentifier;
    private final transient AnnotationScanner[] annotationScanners = new AnnotationScanner[]{new CompressionHintAnnotationScanner()};
    private static final Map<MethodKey, MethodHandler> clientSideMethods;

    EJBInvocationHandler(EJBLocator<T> locator) {
        this(null, locator);
    }

    EJBInvocationHandler(EJBClientContextIdentifier ejbClientContextIdentifier, EJBLocator<T> locator) {
        String annotationScanEnabledSysPropVal;
        String sessionOwnerNode;
        if (locator == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB locator");
        }
        this.ejbClientContextIdentifier = ejbClientContextIdentifier;
        this.locator = locator;
        this.async = false;
        if (locator instanceof StatefulEJBLocator && (sessionOwnerNode = ((StatefulEJBLocator)locator).getSessionOwnerNode()) != null) {
            this.setWeakAffinity(new NodeAffinity(sessionOwnerNode));
        }
        if ((annotationScanEnabledSysPropVal = SecurityActions.getSystemProperty(ENABLE_ANNOTATION_SCANNING_SYSTEM_PROPERTY)) != null && Boolean.valueOf(annotationScanEnabledSysPropVal.trim()).booleanValue()) {
            this.scanAnnotationsOnViewClass();
        } else {
            this.putAttachment(AttachmentKeys.HINTS_DISABLED, true);
        }
    }

    EJBInvocationHandler(EJBInvocationHandler<T> other) {
        super(other);
        String sessionOwnerNode;
        this.locator = other.locator;
        this.async = true;
        this.ejbClientContextIdentifier = other.ejbClientContextIdentifier;
        if (this.locator instanceof StatefulEJBLocator && (sessionOwnerNode = ((StatefulEJBLocator)this.locator).getSessionOwnerNode()) != null) {
            this.setWeakAffinity(new NodeAffinity(sessionOwnerNode));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.doInvoke(this.locator.getViewType().cast(proxy), method, args);
    }

    void setWeakAffinity(Affinity newWeakAffinity) {
        this.weakAffinity = newWeakAffinity;
    }

    Affinity getWeakAffinity() {
        return this.weakAffinity;
    }

    EJBClientContextIdentifier getEjbClientContextIdentifier() {
        return this.ejbClientContextIdentifier;
    }

    Object doInvoke(T proxy, Method method, Object[] args) throws Throwable {
        MethodHandler handler = clientSideMethods.get(new MethodKey(method));
        if (handler != null && handler.canHandleInvocation(this, proxy, method, args)) {
            return handler.invoke(this, proxy, method, args);
        }
        EJBClientContext context = this.ejbClientContextIdentifier == null ? EJBClientContext.requireCurrent() : EJBClientContext.require(this.ejbClientContextIdentifier);
        return EJBInvocationHandler.doInvoke(this, this.async, proxy, method, args, context);
    }

    static <T> EJBInvocationHandler<? extends T> forProxy(T proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof EJBInvocationHandler) {
            return (EJBInvocationHandler)handler;
        }
        throw Logs.MAIN.proxyNotOurs(proxy, EJBClient.class.getName());
    }

    private static <T> Object doInvoke(EJBInvocationHandler<T> ejbInvocationHandler, boolean async, T proxy, Method method, Object[] args, EJBClientContext clientContext) throws Throwable {
        EJBClientInvocationContext invocationContext = new EJBClientInvocationContext(ejbInvocationHandler, clientContext, proxy, method, args);
        try {
            Object value;
            EJBInvocationHandler.sendRequestWithPossibleRetries(invocationContext, true);
            if (!async && (value = invocationContext.awaitResponse()) != EJBClientInvocationContext.PROCEED_ASYNC) {
                return value;
            }
            if (method.getReturnType() == Future.class) {
                return invocationContext.getFutureResponse();
            }
            if (method.getReturnType() == Void.TYPE) {
                invocationContext.setDiscardResult();
                return null;
            }
            EJBClient.setFutureResult(invocationContext.getFutureResponse());
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw e;
            }
            boolean remoteException = false;
            for (Class<?> exception : method.getExceptionTypes()) {
                if (exception.isAssignableFrom(e.getClass())) {
                    throw e;
                }
                if (!RemoteException.class.equals(exception)) continue;
                remoteException = true;
            }
            if (remoteException) {
                throw new RemoteException("Error", e);
            }
            throw new EJBException(e);
        }
    }

    private static void sendRequestWithPossibleRetries(EJBClientInvocationContext clientInvocationContext, boolean firstAttempt) throws Exception {
        try {
            if (firstAttempt) {
                clientInvocationContext.sendRequest();
            } else {
                clientInvocationContext.retryRequest();
            }
        }
        catch (RequestSendFailedException rsfe) {
            String failedNodeName = rsfe.getFailedNodeName();
            if (failedNodeName != null) {
                Logs.MAIN.debug("Retrying invocation " + clientInvocationContext + " which failed on node: " + failedNodeName + " due to:", rsfe);
                clientInvocationContext.markNodeAsExcluded(failedNodeName);
                EJBInvocationHandler.sendRequestWithPossibleRetries(clientInvocationContext, false);
            }
            throw rsfe;
        }
    }

    protected Object writeReplace() {
        return new SerializedEJBInvocationHandler(this.locator);
    }

    EJBInvocationHandler<T> getAsyncHandler() {
        return this.async ? this : new EJBInvocationHandler<T>(this);
    }

    EJBLocator<T> getLocator() {
        return this.locator;
    }

    private void scanAnnotationsOnViewClass() {
        if (this.annotationScanners == null || this.annotationScanners.length == 0) {
            return;
        }
        Class<T> viewClass = this.locator.getViewType();
        Method[] viewMethods = viewClass.getMethods();
        for (AnnotationScanner annotationScanner : this.annotationScanners) {
            annotationScanner.scanClass(viewClass);
            for (Method viewMethod : viewMethods) {
                annotationScanner.scanMethod(viewMethod);
            }
        }
    }

    static {
        HashMap<MethodKey, MethodHandler> methods = new HashMap<MethodKey, MethodHandler>();
        methods.put(new MethodKey("equals", Object.class), new EqualsMethodHandler());
        methods.put(new MethodKey("hashCode", new Class[0]), new HashCodeMethodHandler());
        methods.put(new MethodKey("toString", new Class[0]), new ToStringMethodHandler());
        methods.put(new MethodKey("getPrimaryKey", new Class[0]), new GetPrimaryKeyHandler());
        methods.put(new MethodKey("getHandle", new Class[0]), new GetHandleHandler());
        methods.put(new MethodKey("isIdentical", EJBObject.class), new IsIdenticalHandler());
        methods.put(new MethodKey("getHomeHandle", new Class[0]), new GetHomeHandleHandler());
        clientSideMethods = Collections.unmodifiableMap(methods);
    }

    private final class CompressionHintAnnotationScanner
    implements AnnotationScanner {
        private CompressionHintAnnotationScanner() {
        }

        @Override
        public void scanClass(Class view) {
            CompressionHint compressionHint = view.getAnnotation(CompressionHint.class);
            if (compressionHint == null) {
                return;
            }
            EJBInvocationHandler.this.putAttachment(AttachmentKeys.VIEW_CLASS_DATA_COMPRESSION_HINT_ATTACHMENT_KEY, compressionHint);
        }

        @Override
        public void scanMethod(Method method) {
            CompressionHint compressionHint = method.getAnnotation(CompressionHint.class);
            if (compressionHint == null) {
                return;
            }
            Map<Method, CompressionHint> annotatedMethods = EJBInvocationHandler.this.getAttachment(AttachmentKeys.VIEW_METHOD_DATA_COMPRESSION_HINT_ATTACHMENT_KEY);
            if (annotatedMethods == null) {
                annotatedMethods = new HashMap<Method, CompressionHint>();
                EJBInvocationHandler.this.putAttachment(AttachmentKeys.VIEW_METHOD_DATA_COMPRESSION_HINT_ATTACHMENT_KEY, annotatedMethods);
            }
            annotatedMethods.put(method, compressionHint);
        }
    }

    private static interface AnnotationScanner {
        public void scanClass(Class var1);

        public void scanMethod(Method var1);
    }

    private static final class GetHomeHandleHandler
    implements MethodHandler {
        private GetHomeHandleHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBHome;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            EJBLocator locator = thisHandler.getLocator();
            if (locator instanceof EJBHomeLocator) {
                return new EJBHomeHandle((EJBHomeLocator)locator);
            }
            throw new RemoteException("Cannot invoke getHomeHandle() on " + proxy);
        }
    }

    private static final class IsIdenticalHandler
    implements MethodHandler {
        private IsIdenticalHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBObject && thisHandler.locator instanceof EJBLocator;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            InvocationHandler handler;
            EJBLocator locator = thisHandler.locator;
            Object other = args[0];
            if (Proxy.isProxyClass(other.getClass()) && (handler = Proxy.getInvocationHandler(other)) instanceof EJBInvocationHandler) {
                return locator.equals(((EJBInvocationHandler)handler).getLocator());
            }
            return false;
        }
    }

    private static final class GetHandleHandler
    implements MethodHandler {
        private GetHandleHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBObject && thisHandler.locator instanceof EJBLocator;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            EJBLocator locator = thisHandler.getLocator();
            return new EJBHandle(locator);
        }
    }

    private static final class GetPrimaryKeyHandler
    implements MethodHandler {
        private GetPrimaryKeyHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBObject;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            EJBLocator locator = thisHandler.locator;
            if (locator instanceof EntityEJBLocator) {
                return ((EntityEJBLocator)locator).getPrimaryKey();
            }
            throw new RemoteException("Cannot invoke getPrimaryKey() om " + proxy);
        }
    }

    private static final class ToStringMethodHandler
    implements MethodHandler {
        private ToStringMethodHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return true;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return String.format("Proxy for remote EJB %s", thisHandler.locator);
        }
    }

    private static final class HashCodeMethodHandler
    implements MethodHandler {
        private HashCodeMethodHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return true;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return thisHandler.locator.hashCode();
        }
    }

    private static final class EqualsMethodHandler
    implements MethodHandler {
        private EqualsMethodHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return true;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            InvocationHandler handler;
            Object other = args[0];
            if (other instanceof Proxy && (handler = Proxy.getInvocationHandler(other)) instanceof EJBInvocationHandler) {
                return thisHandler.locator.equals(((EJBInvocationHandler)handler).locator);
            }
            return Boolean.FALSE;
        }
    }

    private static interface MethodHandler {
        public boolean canHandleInvocation(EJBInvocationHandler var1, Object var2, Method var3, Object[] var4) throws Exception;

        public Object invoke(EJBInvocationHandler var1, Object var2, Method var3, Object[] var4) throws Exception;
    }

    private static final class MethodKey {
        private final String name;
        private final Class[] parameters;

        public MethodKey(String name, Class ... parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public MethodKey(Method method) {
            this.name = method.getName();
            this.parameters = method.getParameterTypes();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (!this.name.equals(methodKey.name)) {
                return false;
            }
            return Arrays.equals(this.parameters, methodKey.parameters);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameters);
            return result;
        }
    }
}

