/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;

class VersionReceiver
implements Channel.Receiver {
    private static final Logger logger = Logger.getLogger(VersionReceiver.class);
    private final String clientMarshallingStrategy;
    private final CountDownLatch latch;
    private Channel compatibleChannel;
    private boolean compatibilityFailed;
    private final SortedSet<Byte> legibleVersions = new TreeSet<Byte>();
    private volatile int negotiatedVersion = -1;

    VersionReceiver(CountDownLatch latch, byte[] clientVersions, String marshallingStrategy) {
        for (byte clientVersion : clientVersions) {
            this.legibleVersions.add(clientVersion);
        }
        this.clientMarshallingStrategy = marshallingStrategy;
        this.latch = latch;
        this.compatibilityFailed = false;
    }

    public void handleError(Channel channel, IOException error) {
        logger.error((Object)("Error on channel " + channel), (Throwable)error);
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleEnd(Channel channel) {
        Logs.REMOTING.channelCanNoLongerProcessMessages(channel);
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleMessage(Channel channel, MessageInputStream message) {
        Object[] serverMarshallerStrategies;
        byte serverVersion;
        SimpleDataInput simpleDataInput = new SimpleDataInput(Marshalling.createByteInput((InputStream)message));
        try {
            serverVersion = simpleDataInput.readByte();
            int serverMarshallerCount = PackedInteger.readPackedInteger((DataInput)simpleDataInput);
            if (serverMarshallerCount <= 0) {
                throw new RuntimeException("Client cannot communicate with the server since no marshalling strategy has been configured on server side");
            }
            serverMarshallerStrategies = new String[serverMarshallerCount];
            for (int i = 0; i < serverMarshallerCount; ++i) {
                serverMarshallerStrategies[i] = simpleDataInput.readUTF();
            }
            Logs.REMOTING.receivedServerVersionAndMarshallingStrategies(String.valueOf(serverVersion), Arrays.toString(serverMarshallerStrategies));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.negotiatedVersion = this.matchBestCompatibleVersion(serverVersion, (String[])serverMarshallerStrategies);
        if (this.negotiatedVersion == -1) {
            logger.error((Object)"EJB receiver cannot communicate with server, due to version incompatibility");
            this.compatibilityFailed = true;
            return;
        }
        try {
            this.sendVersionMessage(channel);
            this.compatibleChannel = channel;
            this.latch.countDown();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    Channel getCompatibleChannel() {
        return this.compatibleChannel;
    }

    int getNegotiatedProtocolVersion() {
        return this.negotiatedVersion;
    }

    private int matchBestCompatibleVersion(byte serverVersion, String[] serverMarshallingStrategies) {
        List<String> serverSupportedStrategies = Arrays.asList(serverMarshallingStrategies);
        if (!serverSupportedStrategies.contains(this.clientMarshallingStrategy)) {
            logger.debug((Object)("Server doesn't support marshaling strategy: " + this.clientMarshallingStrategy));
            return -1;
        }
        if (this.legibleVersions.contains(serverVersion)) {
            return serverVersion;
        }
        byte highestKnownVersionOnClient = this.legibleVersions.last();
        if (highestKnownVersionOnClient < serverVersion) {
            return serverVersion;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVersionMessage(Channel channel) throws IOException {
        MessageOutputStream channelOutputStream = channel.writeMessage();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channelOutputStream);
        try {
            dataOutputStream.write(this.negotiatedVersion);
            dataOutputStream.writeUTF(this.clientMarshallingStrategy);
        }
        finally {
            dataOutputStream.close();
            channelOutputStream.close();
        }
    }

    boolean failedCompatibility() {
        return this.compatibilityFailed;
    }
}

