/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.remoting.AutoConnectionCloser;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

abstract class MaxAttemptsReconnectHandler
implements ReconnectHandler {
    private static final Logger logger = Logger.getLogger(MaxAttemptsReconnectHandler.class);
    protected final Endpoint endpoint;
    protected final URI connectionURI;
    protected final OptionMap connectionCreationOptions;
    protected final CallbackHandler callbackHandler;
    protected final OptionMap channelCreationOptions;
    protected final int maxReconnectAttempts;
    protected volatile int reconnectAttempts;

    MaxAttemptsReconnectHandler(Endpoint endpoint, URI uri, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, OptionMap channelCreationOptions, int maxReconnectAttempts) {
        this.endpoint = endpoint;
        this.connectionURI = uri;
        this.connectionCreationOptions = connectionCreationOptions;
        this.callbackHandler = callbackHandler;
        this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    protected Connection tryConnect(long connectionTimeout, TimeUnit unit) {
        if (this.reconnectAttempts >= this.maxReconnectAttempts) {
            return null;
        }
        ++this.reconnectAttempts;
        try {
            IoFuture futureConnection = this.endpoint.connect(this.connectionURI, this.connectionCreationOptions, this.callbackHandler);
            Connection connection = (Connection)IoFutureHelper.get(futureConnection, connectionTimeout, unit);
            AutoConnectionCloser.INSTANCE.addConnection(connection);
            logger.debug((Object)("Successfully reconnected on attempt#" + this.reconnectAttempts + " to connection " + connection));
            return connection;
        }
        catch (Exception e) {
            logger.debug((Object)("Re-connect attempt# " + this.reconnectAttempts + " failed for connection URI " + this.connectionURI), (Throwable)e);
            return null;
        }
    }

    protected boolean hasMoreAttempts() {
        return this.reconnectAttempts < this.maxReconnectAttempts;
    }
}

