/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.AnonymousCallbackHandler;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.remoting.AutoConnectionCloser;
import org.jboss.ejb.client.remoting.ClusterContextConnectionReconnectHandler;
import org.jboss.ejb.client.remoting.ClusterNode;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

class RemotingConnectionClusterNodeManager
implements ClusterNodeManager {
    private static final Logger logger = Logger.getLogger(RemotingConnectionClusterNodeManager.class);
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.create((Option)Options.SASL_PROPERTIES, (Object)Sequence.of((Object[])new Property[]{Property.of((String)"jboss.sasl.local-user.quiet-auth", (String)"true")}), (Option)Options.SASL_POLICY_NOPLAINTEXT, (Object)false);
    private final ClusterContext clusterContext;
    private final ClusterNode clusterNode;
    private final Endpoint endpoint;
    private final EJBClientConfiguration ejbClientConfiguration;

    RemotingConnectionClusterNodeManager(ClusterContext clusterContext, ClusterNode clusterNode, Endpoint endpoint, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterContext = clusterContext;
        this.clusterNode = clusterNode;
        this.endpoint = endpoint;
        this.ejbClientConfiguration = ejbClientConfiguration;
    }

    @Override
    public String getNodeName() {
        return this.clusterNode.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBReceiver getEJBReceiver() {
        ClusterContextConnectionReconnectHandler reconnectHandler;
        if (!this.clusterNode.isDestinationResolved()) {
            Logs.REMOTING.cannotCreateEJBReceiverDueToUnknownTarget(this.clusterNode.toString());
            return null;
        }
        Connection connection = null;
        OptionMap channelCreationOptions = OptionMap.EMPTY;
        int MAX_RECONNECT_ATTEMPTS = 65535;
        try {
            if (this.ejbClientConfiguration != null) {
                EJBClientConfiguration.ClusterConfiguration clusterConfiguration = this.ejbClientConfiguration.getClusterConfiguration(this.clusterContext.getClusterName());
                if (clusterConfiguration == null) {
                    CallbackHandler callbackHandler = this.ejbClientConfiguration.getCallbackHandler();
                    IoFuture<Connection> futureConnection = NetworkUtil.connect(this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), null, DEFAULT_CONNECTION_CREATION_OPTIONS, callbackHandler, null);
                    connection = IoFutureHelper.get(futureConnection, 5000L, TimeUnit.MILLISECONDS);
                    reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), DEFAULT_CONNECTION_CREATION_OPTIONS, callbackHandler, channelCreationOptions, 65535, 5000L, TimeUnit.MILLISECONDS);
                } else {
                    EJBClientConfiguration.ClusterNodeConfiguration clusterNodeConfiguration = clusterConfiguration.getNodeConfiguration(this.getNodeName());
                    channelCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getChannelCreationOptions() : clusterNodeConfiguration.getChannelCreationOptions();
                    OptionMap connectionCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionCreationOptions() : clusterNodeConfiguration.getConnectionCreationOptions();
                    CallbackHandler callbackHandler = clusterNodeConfiguration == null ? clusterConfiguration.getCallbackHandler() : clusterNodeConfiguration.getCallbackHandler();
                    IoFuture<Connection> futureConnection = NetworkUtil.connect(this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), null, connectionCreationOptions, callbackHandler, null);
                    long timeout = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionTimeout() : clusterNodeConfiguration.getConnectionTimeout();
                    connection = IoFutureHelper.get(futureConnection, timeout, TimeUnit.MILLISECONDS);
                    reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), connectionCreationOptions, callbackHandler, channelCreationOptions, 65535, timeout, TimeUnit.MILLISECONDS);
                }
            } else {
                AnonymousCallbackHandler callbackHandler = new AnonymousCallbackHandler();
                IoFuture<Connection> futureConnection = NetworkUtil.connect(this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), null, DEFAULT_CONNECTION_CREATION_OPTIONS, callbackHandler, null);
                connection = IoFutureHelper.get(futureConnection, 5000L, TimeUnit.MILLISECONDS);
                reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, this.clusterNode.getDestinationAddress(), this.clusterNode.getDestinationPort(), DEFAULT_CONNECTION_CREATION_OPTIONS, callbackHandler, channelCreationOptions, 65535, 5000L, TimeUnit.MILLISECONDS);
            }
            if (connection != null) {
                AutoConnectionCloser.INSTANCE.addConnection(connection);
            }
        }
        catch (Exception e) {
            try {
                logger.info((Object)("Could not create a connection for cluster node " + this.clusterNode + " in cluster " + this.clusterContext.getClusterName()), (Throwable)e);
                EJBReceiver eJBReceiver = null;
                if (connection != null) {
                    AutoConnectionCloser.INSTANCE.addConnection(connection);
                }
                return eJBReceiver;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    AutoConnectionCloser.INSTANCE.addConnection(connection);
                }
                throw throwable;
            }
        }
        return new RemotingConnectionEJBReceiver(connection, reconnectHandler, channelCreationOptions);
    }
}

