/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.InvocationTargetException;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.common.math.HashMath;

final class EJBClientInterceptorInformation {
    static final EJBClientInterceptorInformation[] NO_INTERCEPTORS = new EJBClientInterceptorInformation[0];
    private static final ClassValue<EJBClientInterceptorInformation> CLASS_VALUE = new ClassValue<EJBClientInterceptorInformation>(){

        @Override
        protected EJBClientInterceptorInformation computeValue(Class<?> type) {
            EJBClientInterceptor instance;
            Class<EJBClientInterceptor> subclass = type.asSubclass(EJBClientInterceptor.class);
            ClientInterceptorPriority annotation = subclass.getAnnotation(ClientInterceptorPriority.class);
            int priority = annotation != null ? annotation.value() : 0;
            try {
                instance = subclass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException | NoSuchMethodException e) {
                throw Logs.MAIN.noInterceptorConstructor(type);
            }
            catch (IllegalAccessException e) {
                throw Logs.MAIN.interceptorConstructorNotAccessible(type);
            }
            catch (InvocationTargetException e) {
                throw Logs.MAIN.interceptorConstructorFailed(type, e.getCause());
            }
            return new EJBClientInterceptorInformation(instance, priority);
        }
    };
    private final EJBClientInterceptor interceptorInstance;
    private final int priority;
    private EJBClientContext.InterceptorList singletonList;

    private EJBClientInterceptorInformation(EJBClientInterceptor interceptorInstance, int priority) {
        this.interceptorInstance = interceptorInstance;
        this.priority = priority;
    }

    EJBClientInterceptor getInterceptorInstance() {
        return this.interceptorInstance;
    }

    int getPriority() {
        return this.priority;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered((int)System.identityHashCode(this.interceptorInstance), (int)this.priority);
    }

    static EJBClientInterceptorInformation forClass(Class<?> interceptorClass) {
        return CLASS_VALUE.get(interceptorClass);
    }

    static EJBClientInterceptorInformation forInstance(EJBClientInterceptor interceptor) {
        EJBClientInterceptorInformation classInfo = CLASS_VALUE.get(interceptor.getClass());
        if (classInfo.interceptorInstance == interceptor) {
            return classInfo;
        }
        return new EJBClientInterceptorInformation(interceptor, classInfo.priority);
    }

    EJBClientContext.InterceptorList getSingletonList() {
        EJBClientContext.InterceptorList singletonList = this.singletonList;
        if (singletonList == null) {
            this.singletonList = new EJBClientContext.InterceptorList(new EJBClientInterceptorInformation[]{this});
            return this.singletonList;
        }
        return singletonList;
    }
}

