/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.zip.InflaterInputStream;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb._private.NetworkUtil;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.protocol.remote.PackedInteger;
import org.jboss.ejb.protocol.remote.ProtocolV1ClassTable;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectTable;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectTable;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.IntIndexMap;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceRegistry;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.LocalRegistryAndDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.RegistryProvider;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.wildfly.transaction.client.provider.remoting.SimpleIdResolver;
import org.xnio.Bits;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class EJBClientChannel {
    private final MarshallerFactory marshallerFactory;
    private final Channel channel;
    private final int version;
    private final InvocationTracker invocationTracker;
    private final ServiceRegistry persistentClusterRegistry;
    private final ServiceRegistry serviceRegistry;
    private final MarshallingConfiguration configuration;
    private final ServiceRegistration nodeRegistration;
    private final ConcurrentMap<DiscKey, ServiceRegistration> registrationsMap = new ConcurrentHashMap<DiscKey, ServiceRegistration>();
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<ClusterDiscKey, ServiceRegistration>>> clusterRegistrationsMap;
    private final IntIndexMap<UserTransactionID> userTxnIds = new IntIndexHashMap(UserTransactionID::getId);
    private final RemoteTransactionContext transactionContext;
    private final AtomicInteger finishedParts = new AtomicInteger(0);
    private final AtomicReference<FutureResult<EJBClientChannel>> futureResultRef;
    private final LocalRegistryAndDiscoveryProvider discoveryProvider = new LocalRegistryAndDiscoveryProvider();
    private static final AttachmentKey<MethodInvocation> INV_KEY = new AttachmentKey();

    EJBClientChannel(Channel channel, int version, ServiceRegistry persistentClusterRegistry, ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<ClusterDiscKey, ServiceRegistration>>> clusterRegistrationsMap, FutureResult<EJBClientChannel> futureResult) {
        this.channel = channel;
        this.version = version;
        this.persistentClusterRegistry = persistentClusterRegistry;
        this.clusterRegistrationsMap = clusterRegistrationsMap;
        this.marshallerFactory = Marshalling.getProvidedMarshallerFactory((String)"river");
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)new ContextClassResolver(){

            public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
                int length = interfaces.length;
                Class[] classes = new Class[length];
                for (int i = 0; i < length; ++i) {
                    classes[i] = this.loadClass(interfaces[i]);
                }
                ClassLoader classLoader = length == 1 ? AccessController.doPrivileged(classes[0]::getClassLoader) : this.getClassLoader();
                return Proxy.getProxyClass(classLoader, classes);
            }
        });
        if (version < 3) {
            configuration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
            configuration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
            configuration.setObjectResolver((ObjectResolver)new ProtocolV1ObjectResolver(channel.getConnection().getEndpoint().getName()));
            configuration.setVersion(2);
            this.finishedParts.set(2);
        } else {
            configuration.setObjectTable((ObjectTable)ProtocolV3ObjectTable.INSTANCE);
            configuration.setObjectResolver((ObjectResolver)new ProtocolV3ObjectResolver(channel.getConnection().getPeerURI()));
            configuration.setVersion(4);
        }
        this.transactionContext = RemoteTransactionContext.getInstance();
        this.serviceRegistry = ServiceRegistry.create((RegistryProvider)this.discoveryProvider);
        this.configuration = configuration;
        this.invocationTracker = new InvocationTracker(this.channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue(), EJBClientChannel::mask);
        this.futureResultRef = new AtomicReference<FutureResult<EJBClientChannel>>(futureResult);
        ServiceURL.Builder builder = new ServiceURL.Builder();
        builder.setUri(channel.getConnection().getPeerURI());
        builder.setAbstractType("ejb").setAbstractTypeAuthority("jboss");
        builder.addAttribute("node", AttributeValue.fromString((String)channel.getConnection().getRemoteEndpointName()));
        this.nodeRegistration = this.serviceRegistry.registerService(builder.create());
        channel.addCloseHandler((c, e) -> {
            this.nodeRegistration.close();
            Iterator i1 = this.registrationsMap.entrySet().iterator();
            while (i1.hasNext()) {
                Map.Entry entry = i1.next();
                i1.remove();
                ((ServiceRegistration)entry.getValue()).close();
            }
        });
    }

    static int mask(int original) {
        return original & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processMessage(MessageInputStream message) {
        leaveOpen = false;
        try {
            msg = message.readUnsignedByte();
            switch (msg) {
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 20: 
                case 28: {
                    invId = message.readUnsignedShort();
                    leaveOpen = this.invocationTracker.signalResponse(invId, msg, message, false);
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 8: {
                    count = StreamUtils.readPackedSignedInt32((InputStream)message);
                    connection = this.channel.getConnection();
                    peerURI = connection.getPeerURI();
                    serviceRegistry = this.serviceRegistry;
                    registrationsMap = this.registrationsMap;
                    for (i = 0; i < count; ++i) {
                        appName = message.readUTF();
                        moduleName = message.readUTF();
                        distinctName = message.readUTF();
                        key = new DiscKey(appName, moduleName, distinctName);
                        builder = new ServiceURL.Builder();
                        builder.setUri(peerURI);
                        builder.setAbstractType("ejb");
                        builder.setAbstractTypeAuthority("jboss");
                        if (distinctName.isEmpty()) {
                            if (appName.isEmpty()) {
                                builder.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
                            } else {
                                builder.addAttribute("ejb-module", AttributeValue.fromString((String)(appName + "/" + moduleName)));
                            }
                        } else if (appName.isEmpty()) {
                            builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + "/" + distinctName)));
                        } else {
                            builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(appName + "/" + moduleName + "/" + distinctName)));
                        }
                        registration = serviceRegistry.registerService(builder.create());
                        old = registrationsMap.put(key, registration);
                        if (old == null) continue;
                        old.close();
                    }
                    this.finishPart(1);
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 9: {
                    count = StreamUtils.readPackedSignedInt32((InputStream)message);
                    registrationsMap = this.registrationsMap;
                    for (i = 0; i < count; ++i) {
                        appName = message.readUTF();
                        key = new DiscKey(appName, moduleName = message.readUTF(), distinctName = message.readUTF());
                        old = (ServiceRegistration)registrationsMap.remove(key);
                        if (old == null) continue;
                        old.close();
                    }
                    break;
                }
                case 21: 
                case 23: {
                    clusterCount = StreamUtils.readPackedSignedInt32((InputStream)message);
                    connection = this.channel.getConnection();
                    peerURI = connection.getPeerURI();
                    scheme = peerURI.getScheme();
                    for (i = 0; i < clusterCount; ++i) {
                        clusterName = message.readUTF();
                        clusterValue = AttributeValue.fromString((String)clusterName);
                        memberCount = StreamUtils.readPackedSignedInt32((InputStream)message);
                        for (j = 0; j < memberCount; ++j) {
                            nodeName = message.readUTF();
                            nodeValue = AttributeValue.fromString((String)nodeName);
                            mappingCount = StreamUtils.readPackedSignedInt32((InputStream)message);
                            for (k = 0; k < mappingCount; ++k) {
                                b = message.readUnsignedByte();
                                ip6 = Bits.allAreClear((int)b, (int)1);
                                netmaskBits = b >>> 1;
                                sourceIpBytes = new byte[ip6 != false ? 16 : 4];
                                message.readFully(sourceIpBytes);
                                destHost = message.readUTF();
                                destPort = message.readUnsignedShort();
                                builder = new ServiceURL.Builder();
                                builder.setAbstractType("ejb");
                                builder.setAbstractTypeAuthority("jboss");
                                builder.addAttribute("node", nodeValue);
                                builder.addAttribute("cluster", clusterValue);
                                if (netmaskBits != 0) {
                                    builder.addAttribute("source-ip", AttributeValue.fromString((String)(InetAddress.getByAddress(sourceIpBytes).getHostAddress() + "/" + netmaskBits)));
                                }
                                try {
                                    builder.setUri(new URI(scheme, null, NetworkUtil.formatPossibleIpv6Address(destHost), destPort, null, null, null));
                                }
                                catch (URISyntaxException e) {
                                    Logs.REMOTING.trace("Ignoring cluster node because the URI failed to be built", e);
                                    continue;
                                }
                                registration = this.persistentClusterRegistry.registerService(builder.create());
                                key = new ClusterDiscKey(clusterName, nodeName, sourceIpBytes, netmaskBits);
                                old = this.clusterRegistrationsMap.computeIfAbsent(clusterName, (Function<String, ConcurrentMap>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processMessage$1(java.lang.String ), (Ljava/lang/String;)Ljava/util/concurrent/ConcurrentMap;)()).computeIfAbsent(nodeName, (Function<String, ConcurrentMap>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processMessage$2(java.lang.String ), (Ljava/lang/String;)Ljava/util/concurrent/ConcurrentMap;)()).put(key, registration);
                                if (old == null) continue;
                                old.close();
                            }
                        }
                    }
                    this.finishPart(2);
                    ** break;
lbl111:
                    // 1 sources

                    break;
                }
                case 22: {
                    clusterCount = StreamUtils.readPackedSignedInt32((InputStream)message);
                    for (i = 0; i < clusterCount; ++i) {
                        clusterName = message.readUTF();
                        subMap = (ConcurrentMap)this.clusterRegistrationsMap.remove(clusterName);
                        if (subMap == null) continue;
                        for (ConcurrentMap subSubMap : subMap.values()) {
                            for (ServiceRegistration registration : subSubMap.values()) {
                                registration.close();
                            }
                        }
                    }
                    break;
                }
                case 24: {
                    clusterCount = StreamUtils.readPackedSignedInt32((InputStream)message);
                    for (i = 0; i < clusterCount; ++i) {
                        clusterName = message.readUTF();
                        subMap = (ConcurrentMap)this.clusterRegistrationsMap.get(clusterName);
                        memberCount = StreamUtils.readPackedSignedInt32((InputStream)message);
                        for (j = 0; j < memberCount; ++j) {
                            nodeName = message.readUTF();
                            if (subMap == null || (subSubMap = (ConcurrentMap)subMap.remove(nodeName)) == null) continue;
                            for (ServiceRegistration registration : subSubMap.values()) {
                                registration.close();
                            }
                        }
                    }
                    break;
                }
                ** default:
lbl141:
                // 1 sources

                break;
            }
        }
        catch (IOException var3_4) {
        }
        finally {
            if (!leaveOpen) {
                IoUtils.safeClose((Closeable)message);
            }
        }
    }

    public void processInvocation(EJBReceiverInvocationContext receiverContext) {
        int peerIdentityId;
        MethodInvocation invocation = (MethodInvocation)this.invocationTracker.addInvocation(id -> new MethodInvocation(id, receiverContext));
        EJBClientInvocationContext invocationContext = receiverContext.getClientInvocationContext();
        invocationContext.putAttachment(INV_KEY, invocation);
        EJBLocator<?> locator = invocationContext.getLocator();
        if (this.version >= 3) {
            try {
                peerIdentityId = this.channel.getConnection().getPeerIdentityId();
            }
            catch (AuthenticationException e) {
                receiverContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(e, false)));
                return;
            }
        } else {
            peerIdentityId = 0;
        }
        try (MessageOutputStream out = this.invocationTracker.allocateMessage();){
            try {
                out.write(3);
                out.writeShort(invocation.getIndex());
                Marshaller marshaller = this.getMarshaller();
                marshaller.start(Marshalling.createByteOutput((OutputStream)out));
                Method invokedMethod = invocationContext.getInvokedMethod();
                Object[] parameters = invocationContext.getParameters();
                if (this.version < 3) {
                    out.writeUTF(invokedMethod.getName());
                    out.writeUTF(invocationContext.getMethodSignatureString());
                    marshaller.writeObject((Object)locator.getAppName());
                    marshaller.writeObject((Object)locator.getModuleName());
                    marshaller.writeObject((Object)locator.getDistinctName());
                    marshaller.writeObject((Object)locator.getBeanName());
                } else {
                    marshaller.writeObject((Object)locator.getIdentifier());
                    marshaller.writeObject((Object)invocationContext.getMethodLocator());
                    marshaller.writeInt(peerIdentityId);
                    marshaller.writeObject((Object)invocationContext.getWeakAffinity());
                    if (invocationContext.isCompressResponse()) {
                        marshaller.writeByte(invocationContext.getCompressionLevel());
                    } else {
                        marshaller.writeByte(0);
                    }
                    invocation.setOutflowHandle(this.writeTransaction(invocationContext.getTransaction(), (DataOutput)marshaller));
                }
                marshaller.writeObject(locator);
                if (parameters != null && parameters.length > 0) {
                    for (Object object : parameters) {
                        marshaller.writeObject(object);
                    }
                }
                Map<AttachmentKey<?>, ?> privateAttachments = invocationContext.getAttachments();
                Map<String, Object> contextData = invocationContext.getContextData();
                int totalContextData = contextData.size();
                if (this.version >= 3) {
                    PackedInteger.writePackedInteger((DataOutput)marshaller, totalContextData);
                    for (Map.Entry<String, Object> invocationContextData : contextData.entrySet()) {
                        marshaller.writeObject((Object)invocationContextData.getKey());
                        marshaller.writeObject(invocationContextData.getValue());
                    }
                } else {
                    boolean hasPrivateAttachments;
                    Transaction transaction = invocationContext.getTransaction();
                    HashMap marshalledPrivateAttachments = new HashMap();
                    for (Map.Entry<AttachmentKey<?>, ?> entry : privateAttachments.entrySet()) {
                        AttachmentKey<?> key = entry.getKey();
                        if (key == AttachmentKeys.TRANSACTION_ID_KEY || ProtocolV1ObjectTable.INSTANCE.getObjectWriter(key) == null) continue;
                        marshalledPrivateAttachments.put(key, entry.getValue());
                    }
                    if (transaction != null) {
                        marshalledPrivateAttachments.put(AttachmentKeys.TRANSACTION_ID_KEY, this.calculateTransactionId(transaction));
                    }
                    boolean bl = hasPrivateAttachments = !marshalledPrivateAttachments.isEmpty();
                    if (hasPrivateAttachments) {
                        ++totalContextData;
                    }
                    if (transaction != null) {
                        ++totalContextData;
                    }
                    PackedInteger.writePackedInteger((DataOutput)marshaller, totalContextData);
                    for (Map.Entry<String, Object> invocationContextData : contextData.entrySet()) {
                        marshaller.writeObject((Object)invocationContextData.getKey());
                        marshaller.writeObject(invocationContextData.getValue());
                    }
                    if (hasPrivateAttachments) {
                        marshaller.writeObject((Object)"org.jboss.ejb.client.invocation.attachments");
                        marshaller.writeObject(marshalledPrivateAttachments);
                    }
                    if (transaction != null) {
                        marshaller.writeObject((Object)"jboss.transaction.id");
                        marshaller.writeObject(marshalledPrivateAttachments.get(AttachmentKeys.TRANSACTION_ID_KEY));
                    }
                }
                marshaller.finish();
            }
            catch (IOException e) {
                out.cancel();
                throw e;
            }
        }
        catch (IOException e) {
            receiverContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(e.getMessage(), e, true)));
        }
        catch (RuntimeException | RollbackException | SystemException e) {
            receiverContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException(e.getMessage(), (Exception)e)));
            return;
        }
    }

    private TransactionID calculateTransactionId(Transaction transaction) throws RollbackException, SystemException, InvalidTransactionException {
        URI location = this.channel.getConnection().getPeerURI();
        Assert.assertNotNull((Object)transaction);
        if (transaction instanceof RemoteTransaction) {
            SimpleIdResolver ir = (SimpleIdResolver)((RemoteTransaction)transaction).getProviderInterface(SimpleIdResolver.class);
            if (ir == null) {
                throw Logs.TXN.cannotEnlistTx();
            }
            return new UserTransactionID(this.channel.getConnection().getRemoteEndpointName(), ir.getTransactionId(this.channel.getConnection()));
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(location, localTransaction);
            outflowHandle.verifyEnlistment();
            return new XidTransactionID(outflowHandle.getXid());
        }
        throw Logs.TXN.cannotEnlistTx();
    }

    private XAOutflowHandle writeTransaction(Transaction transaction, DataOutput dataOutput) throws IOException, RollbackException, SystemException {
        URI location = this.channel.getConnection().getPeerURI();
        if (transaction == null) {
            dataOutput.writeByte(0);
            return null;
        }
        if (transaction instanceof RemoteTransaction) {
            dataOutput.writeByte(1);
            SimpleIdResolver ir = (SimpleIdResolver)((RemoteTransaction)transaction).getProviderInterface(SimpleIdResolver.class);
            if (ir == null) {
                throw Logs.TXN.cannotEnlistTx();
            }
            int id = ir.getTransactionId(this.channel.getConnection());
            dataOutput.writeInt(id);
            PackedInteger.writePackedInteger(dataOutput, ((RemoteTransaction)transaction).getEstimatedRemainingTime());
            return null;
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(location, localTransaction);
            Xid xid = outflowHandle.getXid();
            dataOutput.writeByte(2);
            PackedInteger.writePackedInteger(dataOutput, xid.getFormatId());
            byte[] gtid = xid.getGlobalTransactionId();
            dataOutput.writeByte(gtid.length);
            dataOutput.write(gtid);
            byte[] bq = xid.getBranchQualifier();
            dataOutput.writeByte(bq.length);
            dataOutput.write(bq);
            PackedInteger.writePackedInteger(dataOutput, outflowHandle.getRemainingTime());
            return outflowHandle;
        }
        throw Logs.TXN.cannotEnlistTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        if (this.version < 3 && !cancelIfRunning) {
            return false;
        }
        MethodInvocation invocation = receiverContext.getClientInvocationContext().getAttachment(INV_KEY);
        if (invocation == null) {
            return false;
        }
        if (invocation.alloc()) {
            try {
                int index = invocation.getIndex();
                try (MessageOutputStream out = this.invocationTracker.allocateMessage();){
                    out.write(4);
                    out.writeShort(index);
                    if (this.version >= 3) {
                        out.writeBoolean(cancelIfRunning);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                invocation.free();
            }
        }
        return invocation.receiverInvocationContext.getClientInvocationContext().awaitCancellationResult();
    }

    private Marshaller getMarshaller() throws IOException {
        return this.marshallerFactory.createMarshaller(this.configuration);
    }

    public <T> StatefulEJBLocator<T> openSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        SessionOpenInvocation invocation = (SessionOpenInvocation)this.invocationTracker.addInvocation(id -> new SessionOpenInvocation(id, statelessLocator));
        try (MessageOutputStream out = this.invocationTracker.allocateMessage();){
            out.write(1);
            out.writeShort(invocation.getIndex());
            EJBClientChannel.writeRawIdentifier(statelessLocator, out);
            if (this.version >= 3) {
                out.writeInt(this.channel.getConnection().getPeerIdentityId());
                this.writeTransaction((Transaction)ContextTransactionManager.getInstance().getTransaction(), (DataOutput)out);
            }
        }
        catch (IOException e) {
            CreateException createException = new CreateException(e.getMessage());
            createException.initCause((Throwable)e);
            throw createException;
        }
        return invocation.getResult();
    }

    private static <T> void writeRawIdentifier(EJBLocator<T> statelessLocator, MessageOutputStream out) throws IOException {
        String appName = statelessLocator.getAppName();
        out.writeUTF(appName == null ? "" : appName);
        out.writeUTF(statelessLocator.getModuleName());
        String distinctName = statelessLocator.getDistinctName();
        out.writeUTF(distinctName == null ? "" : distinctName);
        out.writeUTF(statelessLocator.getBeanName());
    }

    static IoFuture<EJBClientChannel> construct(final Channel channel, final ServiceRegistry persistentClusterRegistry, final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<ClusterDiscKey, ServiceRegistration>>> clusterRegistrationsMap) {
        final FutureResult futureResult = new FutureResult();
        channel.receiveMessage(new Channel.Receiver(){

            public void handleError(Channel channel, IOException error) {
                futureResult.setException(error);
            }

            public void handleEnd(Channel channel) {
                futureResult.setCancelled();
            }

            public void handleMessage(Channel channel, MessageInputStream message) {
                try {
                    int version = Math.min(3, StreamUtils.readInt8((InputStream)message));
                    while (message.read() != -1) {
                        message.skip(Long.MAX_VALUE);
                    }
                    try (MessageOutputStream out = channel.writeMessage();){
                        out.write(version);
                        out.writeUTF("river");
                    }
                    final EJBClientChannel ejbClientChannel = new EJBClientChannel(channel, version, persistentClusterRegistry, clusterRegistrationsMap, (FutureResult<EJBClientChannel>)futureResult);
                    channel.receiveMessage(new Channel.Receiver(){

                        public void handleError(Channel channel, IOException error) {
                            IoUtils.safeClose((Closeable)channel);
                        }

                        public void handleEnd(Channel channel) {
                            IoUtils.safeClose((Closeable)channel);
                        }

                        public void handleMessage(Channel channel, MessageInputStream message) {
                            try {
                                ejbClientChannel.processMessage(message);
                            }
                            finally {
                                channel.receiveMessage((Channel.Receiver)this);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    channel.closeAsync();
                    channel.addCloseHandler((closed, exception) -> futureResult.setException(e));
                }
            }
        });
        futureResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                if (futureResult.setCancelled()) {
                    IoUtils.safeClose((Closeable)channel);
                }
                return this;
            }
        });
        return futureResult.getIoFuture();
    }

    InvocationTracker getInvocationTracker() {
        return this.invocationTracker;
    }

    Unmarshaller createUnmarshaller() throws IOException {
        return this.marshallerFactory.createUnmarshaller(this.configuration);
    }

    Channel getChannel() {
        return this.channel;
    }

    UserTransactionID allocateUserTransactionID() {
        UserTransactionID uti;
        byte[] nameBytes;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String nodeName = this.getChannel().getConnection().getRemoteEndpointName();
        try {
            nameBytes = nodeName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Assert.unreachableCode();
        }
        int length = nameBytes.length;
        if (length > 255) {
            throw Assert.unreachableCode();
        }
        byte[] target = new byte[6 + length];
        target[0] = 1;
        target[1] = (byte)length;
        System.arraycopy(nameBytes, 0, target, 2, length);
        while (true) {
            int id;
            if (this.userTxnIds.containsKey(id = random.nextInt())) {
                continue;
            }
            target[2 + length] = (byte)(id >> 24);
            target[3 + length] = (byte)(id >> 16);
            target[4 + length] = (byte)(id >> 8);
            target[5 + length] = (byte)id;
            uti = (UserTransactionID)TransactionID.createTransactionID(target);
            if (this.userTxnIds.putIfAbsent((Object)uti) == null) break;
        }
        return uti;
    }

    DiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    void finishPart(int bit) {
        FutureResult<EJBClientChannel> futureResult;
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.finishedParts.get()), (int)bit)) continue;
            return;
        } while (!this.finishedParts.compareAndSet(oldVal, newVal = oldVal | bit));
        if (newVal == 3 && (futureResult = this.futureResultRef.get()) != null && this.futureResultRef.compareAndSet(futureResult, null)) {
            futureResult.setResult((Object)this);
        }
    }

    private static /* synthetic */ ConcurrentMap lambda$processMessage$2(String x) {
        return new ConcurrentHashMap();
    }

    private static /* synthetic */ ConcurrentMap lambda$processMessage$1(String x) {
        return new ConcurrentHashMap();
    }

    static class ResponseMessageInputStream
    extends MessageInputStream
    implements ByteInput {
        private final InputStream delegate;
        private final int id;

        ResponseMessageInputStream(InputStream delegate, int id) {
            this.delegate = delegate;
            this.id = id;
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int getId() {
            return this.id;
        }
    }

    final class MethodInvocation
    extends Invocation {
        private final EJBReceiverInvocationContext receiverInvocationContext;
        private final AtomicInteger refCounter;
        private XAOutflowHandle outflowHandle;

        MethodInvocation(int index, EJBReceiverInvocationContext receiverInvocationContext) {
            super(index);
            this.refCounter = new AtomicInteger(1);
            this.receiverInvocationContext = receiverInvocationContext;
        }

        boolean alloc() {
            int oldVal;
            AtomicInteger refCounter = this.refCounter;
            do {
                if ((oldVal = refCounter.get()) != 0) continue;
                return false;
            } while (!refCounter.compareAndSet(oldVal, oldVal + 1));
            return true;
        }

        void free() {
            AtomicInteger refCounter = this.refCounter;
            int newVal = refCounter.decrementAndGet();
            if (newVal == 0) {
                EJBClientChannel.this.invocationTracker.remove((Invocation)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleResponse(int id, MessageInputStream inputStream) {
            switch (id) {
                case 27: {
                    this.free();
                    this.receiverInvocationContext.resultReady(new MethodCallResultProducer(new InflaterInputStream((InputStream)inputStream), id));
                    return;
                }
                case 5: {
                    this.free();
                    if (EJBClientChannel.this.version >= 3) {
                        try {
                            int cmd = inputStream.readUnsignedByte();
                            XAOutflowHandle outflowHandle = this.getOutflowHandle();
                            if (outflowHandle != null) {
                                if (cmd == 0) {
                                    outflowHandle.forgetEnlistment();
                                } else if (cmd == 1) {
                                    outflowHandle.verifyEnlistment();
                                } else if (cmd == 2) {
                                    outflowHandle.nonMasterEnlistment();
                                }
                            }
                            if (inputStream.readBoolean()) {
                                byte[] encoded = new byte[PackedInteger.readPackedInteger((DataInput)inputStream)];
                                inputStream.read(encoded);
                                SessionID sessionID = SessionID.createSessionID(encoded);
                                EJBClientInvocationContext context = this.receiverInvocationContext.getClientInvocationContext();
                                EJBClient.convertToStateful(context.getInvokedProxy(), sessionID);
                            }
                        }
                        catch (IOException | RuntimeException | RollbackException | SystemException e) {
                            this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException((Exception)e)));
                            IoUtils.safeClose((Closeable)inputStream);
                            return;
                        }
                    }
                    this.receiverInvocationContext.resultReady(new MethodCallResultProducer((InputStream)inputStream, id));
                    return;
                }
                case 7: {
                    this.free();
                    this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(Logs.REMOTING.requestCancelled()));
                    return;
                }
                case 6: {
                    this.free();
                    this.receiverInvocationContext.resultReady(new ExceptionResultProducer((InputStream)inputStream, id));
                    return;
                }
                case 10: {
                    this.free();
                    try {
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new NoSuchEJBException(message)));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException("Failed to read 'No such EJB' response", (Exception)e)));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 28: {
                    this.free();
                    try {
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)Logs.REMOTING.invalidViewTypeForInvocation(message)));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException("Failed to read 'Bad EJB view type' response", (Exception)e)));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 11: {
                    this.free();
                    try {
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new IllegalArgumentException(message)));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException("Failed to read 'No such EJB method' response", (Exception)e)));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 12: {
                    this.free();
                    try {
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException(message)));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException("Failed to read 'Session not active' response", (Exception)e)));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 13: {
                    this.free();
                    try {
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException(message)));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException("Failed to read 'EJB not stateful' response", (Exception)e)));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 14: {
                    IoUtils.safeClose((Closeable)inputStream);
                    this.receiverInvocationContext.proceedAsynchronously();
                    return;
                }
                default: {
                    this.free();
                    IoUtils.safeClose((Closeable)inputStream);
                    this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException("Unknown protocol response")));
                }
            }
        }

        public void handleClosed() {
            this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException((Exception)new ClosedChannelException())));
        }

        public void handleException(IOException cause) {
            this.receiverInvocationContext.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)new EJBException((Exception)cause)));
        }

        XAOutflowHandle getOutflowHandle() {
            return this.outflowHandle;
        }

        void setOutflowHandle(XAOutflowHandle outflowHandle) {
            this.outflowHandle = outflowHandle;
        }

        class ExceptionResultProducer
        implements EJBReceiverInvocationContext.ResultProducer {
            private final InputStream inputStream;
            private final int id;

            ExceptionResultProducer(InputStream inputStream, int id) {
                this.inputStream = inputStream;
                this.id = id;
            }

            @Override
            public Object getResult() throws Exception {
                Exception e;
                try (ResponseMessageInputStream response = new ResponseMessageInputStream(this.inputStream, this.id);){
                    if (EJBClientChannel.this.version >= 3) {
                        int cmd = response.readUnsignedByte();
                        XAOutflowHandle outflowHandle = MethodInvocation.this.getOutflowHandle();
                        if (outflowHandle != null) {
                            if (cmd == 0) {
                                outflowHandle.forgetEnlistment();
                            } else if (cmd == 1) {
                                try {
                                    outflowHandle.verifyEnlistment();
                                }
                                catch (RollbackException | SystemException e1) {
                                    throw new EJBException((Exception)e1);
                                }
                            } else if (cmd == 2) {
                                outflowHandle.nonMasterEnlistment();
                            }
                        }
                    }
                    try (Unmarshaller unmarshaller = EJBClientChannel.this.createUnmarshaller();){
                        unmarshaller.start((ByteInput)response);
                        e = (Exception)unmarshaller.readObject(Exception.class);
                        if (EJBClientChannel.this.version < 3) {
                            int attachments = unmarshaller.readUnsignedByte();
                            for (int i = 0; i < attachments; ++i) {
                                unmarshaller.readObject();
                                unmarshaller.readObject();
                            }
                        }
                        unmarshaller.finish();
                    }
                }
                catch (IOException | ClassNotFoundException ex) {
                    throw new EJBException("Failed to read response", ex);
                }
                if (e == null) {
                    throw new EJBException("Null exception response");
                }
                throw e;
            }

            @Override
            public void discardResult() {
                IoUtils.safeClose((Closeable)this.inputStream);
            }
        }

        class MethodCallResultProducer
        implements EJBReceiverInvocationContext.ResultProducer {
            private final InputStream inputStream;
            private final int id;

            MethodCallResultProducer(InputStream inputStream, int id) {
                this.inputStream = inputStream;
                this.id = id;
            }

            @Override
            public Object getResult() throws Exception {
                Object result;
                ResponseMessageInputStream response = new ResponseMessageInputStream(this.inputStream, this.id);
                try (Unmarshaller unmarshaller = EJBClientChannel.this.createUnmarshaller();){
                    unmarshaller.start((ByteInput)response);
                    result = unmarshaller.readObject();
                    int attachments = unmarshaller.readUnsignedByte();
                    for (int i = 0; i < attachments; ++i) {
                        String key = (String)unmarshaller.readObject(String.class);
                        if (key.equals("jboss.ejb.weak.affinity")) {
                            MethodInvocation.this.receiverInvocationContext.getClientInvocationContext().putAttachment(AttachmentKeys.WEAK_AFFINITY, unmarshaller.readObject(Affinity.class));
                            continue;
                        }
                        unmarshaller.readObject();
                    }
                    unmarshaller.finish();
                }
                catch (IOException | ClassNotFoundException ex) {
                    throw new EJBException("Failed to read response", ex);
                }
                return result;
            }

            @Override
            public void discardResult() {
                IoUtils.safeClose((Closeable)this.inputStream);
            }
        }
    }

    final class SessionOpenInvocation<T>
    extends Invocation {
        private final StatelessEJBLocator<T> statelessLocator;
        private int id;
        private MessageInputStream inputStream;
        private XAOutflowHandle outflowHandle;

        protected SessionOpenInvocation(int index, StatelessEJBLocator<T> statelessLocator) {
            super(index);
            this.statelessLocator = statelessLocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(int id, MessageInputStream inputStream) {
            SessionOpenInvocation sessionOpenInvocation = this;
            synchronized (sessionOpenInvocation) {
                this.id = id;
                this.inputStream = inputStream;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClosed() {
            SessionOpenInvocation sessionOpenInvocation = this;
            synchronized (sessionOpenInvocation) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        void setOutflowHandle(XAOutflowHandle outflowHandle) {
            this.outflowHandle = outflowHandle;
        }

        XAOutflowHandle getOutflowHandle() {
            return this.outflowHandle;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        StatefulEJBLocator<T> getResult() throws Exception {
            try {
                response = this.removeInvocationResult();
                var3_3 = null;
                try {
                    switch (this.id) {
                        case 2: {
                            size = StreamUtils.readPackedUnsignedInt32((InputStream)response);
                            bytes = new byte[size];
                            response.readFully(bytes);
                            if (1 <= EJBClientChannel.access$200(EJBClientChannel.this) && EJBClientChannel.access$200(EJBClientChannel.this) <= 2) {
                                unmarshaller = EJBClientChannel.this.createUnmarshaller();
                                var8_13 = null;
                                try {
                                    unmarshaller.start((ByteInput)response);
                                    affinity = (Affinity)unmarshaller.readObject(Affinity.class);
                                    unmarshaller.finish();
                                }
                                catch (Throwable var9_24) {
                                    var8_13 = var9_24;
                                    throw var9_24;
                                }
                                finally {
                                    if (unmarshaller != null) {
                                        if (var8_13 != null) {
                                            try {
                                                unmarshaller.close();
                                            }
                                            catch (Throwable var9_23) {
                                                var8_13.addSuppressed(var9_23);
                                            }
                                        } else {
                                            unmarshaller.close();
                                        }
                                    }
                                }
                            } else {
                                affinity = this.statelessLocator.getAffinity();
                                cmd = response.readUnsignedByte();
                                outflowHandle = this.getOutflowHandle();
                                if (outflowHandle != null) {
                                    if (cmd == 0) {
                                        outflowHandle.forgetEnlistment();
                                    } else if (cmd == 1) {
                                        try {
                                            outflowHandle.verifyEnlistment();
                                        }
                                        catch (RollbackException | SystemException e1) {
                                            throw new EJBException((Exception)e1);
                                        }
                                    } else if (cmd == 2) {
                                        outflowHandle.nonMasterEnlistment();
                                    }
                                }
                            }
                            var7_12 = this.statelessLocator.withSessionAndAffinity(SessionID.createSessionID(bytes), affinity);
                            return var7_12;
                        }
                        case 6: {
                            if (EJBClientChannel.access$200(EJBClientChannel.this) >= 3) {
                                cmd = response.readUnsignedByte();
                                outflowHandle = this.getOutflowHandle();
                                if (outflowHandle != null) {
                                    if (cmd == 0) {
                                        outflowHandle.forgetEnlistment();
                                    } else if (cmd == 1) {
                                        try {
                                            outflowHandle.verifyEnlistment();
                                        }
                                        catch (RollbackException | SystemException e1) {
                                            throw new EJBException((Exception)e1);
                                        }
                                    } else if (cmd == 2) {
                                        outflowHandle.nonMasterEnlistment();
                                    }
                                }
                            }
                            unmarshaller = EJBClientChannel.this.createUnmarshaller();
                            var5_5 = null;
                            try {
                                unmarshaller.start((ByteInput)response);
                                e = (Exception)unmarshaller.readObject(Exception.class);
                                unmarshaller.finish();
                                if (EJBClientChannel.access$200(EJBClientChannel.this) < 3) {
                                    while (response.read() != -1) {
                                        response.skip(0x7FFFFFFFFFFFFFFFL);
                                    }
                                }
                                if (unmarshaller == null) break;
                                if (var5_5 != null) {
                                }
                                ** GOTO lbl103
                            }
                            catch (Throwable var6_9) {
                                try {
                                    var5_5 = var6_9;
                                    throw var6_9;
                                }
                                catch (Throwable var12_29) {
                                    if (unmarshaller == null) throw var12_29;
                                    if (var5_5 == null) {
                                        unmarshaller.close();
                                        throw var12_29;
                                    }
                                    try {
                                        unmarshaller.close();
                                        throw var12_29;
                                    }
                                    catch (Throwable var13_30) {
                                        var5_5.addSuppressed(var13_30);
                                        throw var12_29;
                                    }
                                }
                            }
                            try {
                                unmarshaller.close();
                                ** break;
lbl98:
                                // 1 sources

                            }
                            catch (Throwable var6_8) {
                                var5_5.addSuppressed(var6_8);
                                ** break;
                            }
lbl102:
                            // 1 sources

                            break;
lbl103:
                            // 1 sources

                            unmarshaller.close();
                            ** break;
lbl105:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            throw Logs.REMOTING.requestCancelled();
                        }
                        case 10: {
                            message = response.readUTF();
                            throw new NoSuchEJBException(message);
                        }
                        case 28: {
                            message = response.readUTF();
                            throw Logs.REMOTING.invalidViewTypeForInvocation(message);
                        }
                        case 13: {
                            message = response.readUTF();
                            throw new IllegalArgumentException(message);
                        }
                        default: {
                            throw new EJBException("Invalid EJB creation response (id " + this.id + ")");
                        }
                    }
                }
                catch (Throwable var4_22) {
                    var3_3 = var4_22;
                    throw var4_22;
                }
                finally {
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable var8_14) {
                                var3_3.addSuppressed(var8_14);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new EJBException("Failed to read session create response", ex);
            }
            if (e != null) throw e;
            throw new EJBException("Null exception response");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ResponseMessageInputStream removeInvocationResult() {
            MessageInputStream mis;
            int id;
            try {
                SessionOpenInvocation sessionOpenInvocation = this;
                synchronized (sessionOpenInvocation) {
                    while (true) {
                        id = this.getIndex();
                        if (this.inputStream != null) break;
                        if (id == -1) {
                            throw new EJBException("Connection closed");
                        }
                        ((Object)((Object)this)).wait();
                    }
                    mis = this.inputStream;
                    this.inputStream = null;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new EJBException("Session creation interrupted");
            }
            return new ResponseMessageInputStream((InputStream)mis, id);
        }
    }

    static class ClusterDiscKey {
        private final String clusterName;
        private final String nodeName;
        private final byte[] ipBytes;
        private final int maskBits;
        private final int hashCode;

        ClusterDiscKey(String clusterName, String nodeName, byte[] ipBytes, int maskBits) {
            this.clusterName = clusterName;
            this.nodeName = nodeName;
            this.ipBytes = ipBytes;
            this.maskBits = maskBits;
            this.hashCode = HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)maskBits, (int)Arrays.hashCode(ipBytes)), (int)nodeName.hashCode()), (int)clusterName.hashCode());
        }

        public boolean equals(Object obj) {
            return obj instanceof ClusterDiscKey && this.equals((ClusterDiscKey)obj);
        }

        private boolean equals(ClusterDiscKey other) {
            return other == this || this.clusterName.equals(other.clusterName) && this.nodeName.equals(other.nodeName) && Arrays.equals(this.ipBytes, other.ipBytes) && this.maskBits == other.maskBits;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static class DiscKey {
        private final String appName;
        private final String moduleName;
        private final String distinctName;
        private final int hashCode;

        DiscKey(String appName, String moduleName, String distinctName) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.distinctName = distinctName;
            this.hashCode = Objects.hash(appName, moduleName, distinctName);
        }

        public boolean equals(Object obj) {
            return obj instanceof DiscKey && this.equals((DiscKey)obj);
        }

        private boolean equals(DiscKey other) {
            return other == this || this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.distinctName.equals(other.distinctName);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

