package org.jboss.ejb._private;

import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.naming.Name;
import java.lang.RuntimeException;
import java.lang.ReflectiveOperationException;
import javax.transaction.SystemException;
import org.jboss.logging.BasicLogger;
import javax.naming.NamingException;
import java.io.InvalidObjectException;
import org.jboss.ejb.client.EJBLocator;
import java.util.concurrent.ExecutionException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import java.lang.IllegalArgumentException;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb.client.EJBMethodLocator;
import javax.annotation.Generated;
import javax.naming.CommunicationException;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.remoting3.Channel;
import java.io.IOException;
import java.lang.Exception;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.CancellationException;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.Affinity;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import javax.transaction.NotSupportedException;
import javax.ejb.EJBException;
import org.jboss.ejb.client.EJBIdentifier;
import org.wildfly.client.config.ConfigXMLParseException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-05-03T22:52:46-0500")
public class Logs_$logger extends DelegatingBasicLogger implements Logs,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Logs_$logger.class.getName();
    public Logs_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void greeting(final String version) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, greeting$str(), version);
    }
    private static final String greeting = "JBoss EJB Client version %s";
    protected String greeting$str() {
        return greeting;
    }
    private static final String emptyModuleName = "Module name cannot be null or empty";
    protected String emptyModuleName$str() {
        return emptyModuleName;
    }
    @Override
    public final IllegalArgumentException emptyModuleName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(emptyModuleName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyBeanName = "EJBCLIENT000001: Bean name cannot be null or empty";
    protected String emptyBeanName$str() {
        return emptyBeanName;
    }
    @Override
    public final IllegalArgumentException emptyBeanName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(emptyBeanName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullViewType = "EJBCLIENT000002: Bean interface type cannot be null";
    protected String nullViewType$str() {
        return nullViewType;
    }
    @Override
    public final IllegalArgumentException nullViewType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nullViewType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void incorrectMaxAllowedConnectedNodesValueForCluster(final String value, final String clusterName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, incorrectMaxAllowedConnectedNodesValueForCluster$str(), value, clusterName, fallbackDefaultValue);
    }
    private static final String incorrectMaxAllowedConnectedNodesValueForCluster = "EJBCLIENT000003: Incorrect max-allowed-connected-nodes value %s specified for cluster named %s. Defaulting to %s";
    protected String incorrectMaxAllowedConnectedNodesValueForCluster$str() {
        return incorrectMaxAllowedConnectedNodesValueForCluster;
    }
    @Override
    public final void incorrectConnectionTimeoutValueForCluster(final String value, final String clusterName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, incorrectConnectionTimeoutValueForCluster$str(), value, clusterName, fallbackDefaultValue);
    }
    private static final String incorrectConnectionTimeoutValueForCluster = "EJBCLIENT000004: Incorrect connection timeout value %s specified for cluster named %s. Defaulting to %s";
    protected String incorrectConnectionTimeoutValueForCluster$str() {
        return incorrectConnectionTimeoutValueForCluster;
    }
    @Override
    public final void incorrectConnectionTimeoutValueForNodeInCluster(final String value, final String nodeName, final String clusterName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, incorrectConnectionTimeoutValueForNodeInCluster$str(), value, nodeName, clusterName, fallbackDefaultValue);
    }
    private static final String incorrectConnectionTimeoutValueForNodeInCluster = "EJBCLIENT000005: Incorrect connection timeout value %s specified for node %s in cluster named %s. Defaulting to %s";
    protected String incorrectConnectionTimeoutValueForNodeInCluster$str() {
        return incorrectConnectionTimeoutValueForNodeInCluster;
    }
    @Override
    public final void skippingConnectionCreationDueToMissingHostOrPort(final String connectionName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, skippingConnectionCreationDueToMissingHostOrPort$str(), connectionName);
    }
    private static final String skippingConnectionCreationDueToMissingHostOrPort = "EJBCLIENT000006: No host/port configured for connection named %s. Skipping connection creation";
    protected String skippingConnectionCreationDueToMissingHostOrPort$str() {
        return skippingConnectionCreationDueToMissingHostOrPort;
    }
    @Override
    public final void skippingConnectionCreationDueToInvalidPortNumber(final String port, final String connectionName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, skippingConnectionCreationDueToInvalidPortNumber$str(), port, connectionName);
    }
    private static final String skippingConnectionCreationDueToInvalidPortNumber = "EJBCLIENT000007: Incorrect port value %s specified for connection named %s. Skipping connection creation";
    protected String skippingConnectionCreationDueToInvalidPortNumber$str() {
        return skippingConnectionCreationDueToInvalidPortNumber;
    }
    @Override
    public final void incorrectConnectionTimeoutValueForConnection(final String value, final String connectionName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, incorrectConnectionTimeoutValueForConnection$str(), value, connectionName, fallbackDefaultValue);
    }
    private static final String incorrectConnectionTimeoutValueForConnection = "EJBCLIENT000008: Incorrect connection timeout value %s specified for connection named %s. Defaulting to %s";
    protected String incorrectConnectionTimeoutValueForConnection$str() {
        return incorrectConnectionTimeoutValueForConnection;
    }
    @Override
    public final void incorrectInvocationTimeoutValue(final String value, final String fallbackDefaultValue) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, incorrectInvocationTimeoutValue$str(), value, fallbackDefaultValue);
    }
    private static final String incorrectInvocationTimeoutValue = "EJBCLIENT000009: Incorrect invocation timeout value %s specified. Defaulting to %s";
    protected String incorrectInvocationTimeoutValue$str() {
        return incorrectInvocationTimeoutValue;
    }
    @Override
    public final void incorrectReconnectTasksTimeoutValue(final String value, final String fallbackDefaultValue) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, incorrectReconnectTasksTimeoutValue$str(), value, fallbackDefaultValue);
    }
    private static final String incorrectReconnectTasksTimeoutValue = "EJBCLIENT000010: Incorrect reconnect tasks timeout value %s specified. Defaulting to %s";
    protected String incorrectReconnectTasksTimeoutValue$str() {
        return incorrectReconnectTasksTimeoutValue;
    }
    @Override
    public final void discardingInvocationResult(final short invocationId) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, discardingInvocationResult$str(), invocationId);
    }
    private static final String discardingInvocationResult = "EJBCLIENT000011: Discarding result for invocation id %s since no waiting context found";
    protected String discardingInvocationResult$str() {
        return discardingInvocationResult;
    }
    @Override
    public final void cannotCreateEJBReceiverDueToUnknownTarget(final String clusterNode) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, cannotCreateEJBReceiverDueToUnknownTarget$str(), clusterNode);
    }
    private static final String cannotCreateEJBReceiverDueToUnknownTarget = "EJBCLIENT000012: Cannot create a EJB receiver for %s since there was no match for a target destination";
    protected String cannotCreateEJBReceiverDueToUnknownTarget$str() {
        return cannotCreateEJBReceiverDueToUnknownTarget;
    }
    @Override
    public final void initialModuleAvailabilityReportNotReceived(final EJBReceiver ejbReceiver) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, initialModuleAvailabilityReportNotReceived$str(), ejbReceiver);
    }
    private static final String initialModuleAvailabilityReportNotReceived = "EJBCLIENT000015: Initial module availability report for %s wasn't received during the receiver context association";
    protected String initialModuleAvailabilityReportNotReceived$str() {
        return initialModuleAvailabilityReportNotReceived;
    }
    @Override
    public final void channelCanNoLongerProcessMessages(final Channel channel) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, channelCanNoLongerProcessMessages$str(), channel);
    }
    private static final String channelCanNoLongerProcessMessages = "EJBCLIENT000016: Channel %s can no longer process messages";
    protected String channelCanNoLongerProcessMessages$str() {
        return channelCanNoLongerProcessMessages;
    }
    @Override
    public final void receivedServerVersionAndMarshallingStrategies(final int version, final Set<String> marshallingStrategies) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, receivedServerVersionAndMarshallingStrategies$str(), version, marshallingStrategies);
    }
    private static final String receivedServerVersionAndMarshallingStrategies = "EJBCLIENT000017: Received server version %d and marshalling strategies %s";
    protected String receivedServerVersionAndMarshallingStrategies$str() {
        return receivedServerVersionAndMarshallingStrategies;
    }
    private static final String noEJBClientContextAvailable = "EJBCLIENT000022: No EJB client context is available";
    protected String noEJBClientContextAvailable$str() {
        return noEJBClientContextAvailable;
    }
    @Override
    public final IllegalStateException noEJBClientContextAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(noEJBClientContextAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noEJBReceiverAvailable = "EJBCLIENT000024: Not able to find EJB matching \"%s\"";
    protected String noEJBReceiverAvailable$str() {
        return noEJBReceiverAvailable;
    }
    @Override
    public final IllegalStateException noEJBReceiverAvailable(final EJBLocator<? extends Object> locator) {
        final IllegalStateException result = new IllegalStateException(String.format(noEJBReceiverAvailable$str(), locator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noEJBReceiverForNode = "EJBCLIENT000027: No EJBReceiver available for node name %s";
    protected String noEJBReceiverForNode$str() {
        return noEJBReceiverForNode;
    }
    @Override
    public final IllegalStateException noEJBReceiverForNode(final String nodeName) {
        final IllegalStateException result = new IllegalStateException(String.format(noEJBReceiverForNode$str(), nodeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noReceiverContextsInCluster = "EJBCLIENT000028: No EJB receiver contexts available in cluster %s";
    protected String noReceiverContextsInCluster$str() {
        return noReceiverContextsInCluster;
    }
    @Override
    public final IllegalStateException noReceiverContextsInCluster(final String clusterName) {
        final IllegalStateException result = new IllegalStateException(String.format(noReceiverContextsInCluster$str(), clusterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noClusterContextAvailable = "EJBCLIENT000029: No cluster context available for cluster named %s";
    protected String noClusterContextAvailable$str() {
        return noClusterContextAvailable;
    }
    @Override
    public final IllegalStateException noClusterContextAvailable(final String clusterName) {
        final IllegalStateException result = new IllegalStateException(String.format(noClusterContextAvailable$str(), clusterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sendRequestCalledDuringWrongPhase = "EJBCLIENT000030: sendRequest() called during wrong phase";
    protected String sendRequestCalledDuringWrongPhase$str() {
        return sendRequestCalledDuringWrongPhase;
    }
    @Override
    public final IllegalStateException sendRequestCalledDuringWrongPhase() {
        final IllegalStateException result = new IllegalStateException(String.format(sendRequestCalledDuringWrongPhase$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noReceiverAssociatedWithInvocation = "EJBCLIENT000031: No receiver associated with invocation";
    protected String noReceiverAssociatedWithInvocation$str() {
        return noReceiverAssociatedWithInvocation;
    }
    @Override
    public final IllegalStateException noReceiverAssociatedWithInvocation() {
        final IllegalStateException result = new IllegalStateException(String.format(noReceiverAssociatedWithInvocation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRetryRequest = "EJBCLIENT000032: Cannot retry a request which hasn't previously been completed";
    protected String cannotRetryRequest$str() {
        return cannotRetryRequest;
    }
    @Override
    public final IllegalStateException cannotRetryRequest() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotRetryRequest$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getResultCalledDuringWrongPhase = "EJBCLIENT000033: getResult() called during wrong phase";
    protected String getResultCalledDuringWrongPhase$str() {
        return getResultCalledDuringWrongPhase;
    }
    @Override
    public final IllegalStateException getResultCalledDuringWrongPhase() {
        final IllegalStateException result = new IllegalStateException(String.format(getResultCalledDuringWrongPhase$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String discardResultCalledDuringWrongPhase = "EJBCLIENT000034: discardResult() called during wrong phase";
    protected String discardResultCalledDuringWrongPhase$str() {
        return discardResultCalledDuringWrongPhase;
    }
    @Override
    public final IllegalStateException discardResultCalledDuringWrongPhase() {
        final IllegalStateException result = new IllegalStateException(String.format(discardResultCalledDuringWrongPhase$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedNamingOperation = "EJBCLIENT000035: Not supported";
    protected String unsupportedNamingOperation$str() {
        return unsupportedNamingOperation;
    }
    @Override
    public final NamingException unsupportedNamingOperation() {
        final NamingException result = new NamingException(String.format(unsupportedNamingOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedNamingOperationForReadOnlyContext = "EJBCLIENT000036: Read only naming context, operation not supported";
    protected String unsupportedNamingOperationForReadOnlyContext$str() {
        return unsupportedNamingOperationForReadOnlyContext;
    }
    @Override
    public final NamingException unsupportedNamingOperationForReadOnlyContext() {
        final NamingException result = new NamingException(String.format(unsupportedNamingOperationForReadOnlyContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotLoadProxyClass = "EJBCLIENT000037: Could not load ejb proxy class %s";
    protected String couldNotLoadProxyClass$str() {
        return couldNotLoadProxyClass;
    }
    @Override
    public final NamingException couldNotLoadProxyClass(final String viewClassName) {
        final NamingException result = new NamingException(String.format(couldNotLoadProxyClass$str(), viewClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txEnlistmentDidNotYieldTxId = "EJBCLIENT000038: Transaction enlistment did not yield a transaction ID";
    protected String txEnlistmentDidNotYieldTxId$str() {
        return txEnlistmentDidNotYieldTxId;
    }
    @Override
    public final IllegalStateException txEnlistmentDidNotYieldTxId() {
        final IllegalStateException result = new IllegalStateException(String.format(txEnlistmentDidNotYieldTxId$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotEnlistTx = "EJBCLIENT000039: Cannot enlist transaction";
    protected String cannotEnlistTx$str() {
        return cannotEnlistTx;
    }
    @Override
    public final IllegalStateException cannotEnlistTx() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotEnlistTx$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String primaryKeyNotRelevantForSessionBeans = "EJBCLIENT000041: A session bean does not have a primary key class";
    protected String primaryKeyNotRelevantForSessionBeans$str() {
        return primaryKeyNotRelevantForSessionBeans;
    }
    @Override
    public final RuntimeException primaryKeyNotRelevantForSessionBeans() {
        final RuntimeException result = new RuntimeException(String.format(primaryKeyNotRelevantForSessionBeans$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToFindEjbClientConfigFileSpecifiedBySysProp(final String sysPropName, final Exception e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedToFindEjbClientConfigFileSpecifiedBySysProp$str(), sysPropName, e);
    }
    private static final String failedToFindEjbClientConfigFileSpecifiedBySysProp = "EJBCLIENT000042: Failed to load EJB client configuration file specified in %s system property: %s";
    protected String failedToFindEjbClientConfigFileSpecifiedBySysProp$str() {
        return failedToFindEjbClientConfigFileSpecifiedBySysProp;
    }
    private static final String failedToReadEjbClientConfigFile = "EJBCLIENT000043: Error reading EJB client properties file %s";
    protected String failedToReadEjbClientConfigFile$str() {
        return failedToReadEjbClientConfigFile;
    }
    @Override
    public final RuntimeException failedToReadEjbClientConfigFile(final Exception e, final String file) {
        final RuntimeException result = new RuntimeException(String.format(failedToReadEjbClientConfigFile$str(), file), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTxContextAvailable = "EJBCLIENT000044: No transaction context available";
    protected String noTxContextAvailable$str() {
        return noTxContextAvailable;
    }
    @Override
    public final IllegalStateException noTxContextAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(noTxContextAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userTxNotSupportedByTxContext = "EJBCLIENT000045: User transactions not supported by this context";
    protected String userTxNotSupportedByTxContext$str() {
        return userTxNotSupportedByTxContext;
    }
    @Override
    public final IllegalStateException userTxNotSupportedByTxContext() {
        final IllegalStateException result = new IllegalStateException(String.format(userTxNotSupportedByTxContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txAlreadyAssociatedWithThread = "EJBCLIENT000046: A transaction is already associated with this thread";
    protected String txAlreadyAssociatedWithThread$str() {
        return txAlreadyAssociatedWithThread;
    }
    @Override
    public final NotSupportedException txAlreadyAssociatedWithThread() {
        final NotSupportedException result = new NotSupportedException(String.format(txAlreadyAssociatedWithThread$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTxAssociatedWithThread = "EJBCLIENT000047: A transaction is not associated with this thread";
    protected String noTxAssociatedWithThread$str() {
        return noTxAssociatedWithThread;
    }
    @Override
    public final IllegalStateException noTxAssociatedWithThread() {
        final IllegalStateException result = new IllegalStateException(String.format(noTxAssociatedWithThread$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txNotActiveForThread = "EJBCLIENT000048: Transaction for this thread is not active";
    protected String txNotActiveForThread$str() {
        return txNotActiveForThread;
    }
    @Override
    public final IllegalStateException txNotActiveForThread() {
        final IllegalStateException result = new IllegalStateException(String.format(txNotActiveForThread$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txNodeIsExcludedForInvocation = "EJBCLIENT000049: Cannot proceed with invocation since transaction is pinned to node %s which has been excluded from handling invocation for the current invocation context %s";
    protected String txNodeIsExcludedForInvocation$str() {
        return txNodeIsExcludedForInvocation;
    }
    @Override
    public final IllegalStateException txNodeIsExcludedForInvocation(final String nodeName, final EJBClientInvocationContext invocationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(txNodeIsExcludedForInvocation$str(), nodeName, invocationContext));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nodeDoesNotAcceptLocator = "EJBCLIENT000050: Node of the current transaction %s does not accept %s";
    protected String nodeDoesNotAcceptLocator$str() {
        return nodeDoesNotAcceptLocator;
    }
    @Override
    public final IllegalStateException nodeDoesNotAcceptLocator(final String nodeName, final EJBLocator<? extends Object> locator) {
        final IllegalStateException result = new IllegalStateException(String.format(nodeDoesNotAcceptLocator$str(), nodeName, locator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredNodeExcludedFromInvocation = "EJBCLIENT000051: Cannot proceed with invocation since the locator %s has an affinity on node %s which has been excluded from current invocation context %s";
    protected String requiredNodeExcludedFromInvocation$str() {
        return requiredNodeExcludedFromInvocation;
    }
    @Override
    public final IllegalStateException requiredNodeExcludedFromInvocation(final EJBLocator<? extends Object> locator, final String nodeName, final EJBClientInvocationContext invocationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(requiredNodeExcludedFromInvocation$str(), locator, nodeName, invocationContext));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedClusterNodeSelectorClassType = "EJBCLIENT000052: %s for cluster %s is not of type org.jboss.ejb.client.ClusterNodeSelector";
    protected String unexpectedClusterNodeSelectorClassType$str() {
        return unexpectedClusterNodeSelectorClassType;
    }
    @Override
    public final RuntimeException unexpectedClusterNodeSelectorClassType(final Class<? extends Object> nodeSelectorClass, final String clusterName) {
        final RuntimeException result = new RuntimeException(String.format(unexpectedClusterNodeSelectorClassType$str(), nodeSelectorClass, clusterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateClusterNodeSelector = "EJBCLIENT000053: Could not create the cluster node selector for cluster %s";
    protected String couldNotCreateClusterNodeSelector$str() {
        return couldNotCreateClusterNodeSelector;
    }
    @Override
    public final RuntimeException couldNotCreateClusterNodeSelector(final Exception e, final String clusterName) {
        final RuntimeException result = new RuntimeException(String.format(couldNotCreateClusterNodeSelector$str(), clusterName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSpecifyBothCallbackHandlerAndUserPass = "EJBCLIENT000054: Cannot specify both a callback handler and a username/password";
    protected String cannotSpecifyBothCallbackHandlerAndUserPass$str() {
        return cannotSpecifyBothCallbackHandlerAndUserPass;
    }
    @Override
    public final IllegalStateException cannotSpecifyBothCallbackHandlerAndUserPass() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotSpecifyBothCallbackHandlerAndUserPass$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDecodeBase64Password = "EJBCLIENT000055: Could not decode base64 encoded password";
    protected String couldNotDecodeBase64Password$str() {
        return couldNotDecodeBase64Password;
    }
    @Override
    public final RuntimeException couldNotDecodeBase64Password(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(couldNotDecodeBase64Password$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSpecifyBothPlainTextAndEncodedPassword = "EJBCLIENT000056: Cannot specify both a plain text and base64 encoded password";
    protected String cannotSpecifyBothPlainTextAndEncodedPassword$str() {
        return cannotSpecifyBothPlainTextAndEncodedPassword;
    }
    @Override
    public final IllegalStateException cannotSpecifyBothPlainTextAndEncodedPassword() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotSpecifyBothPlainTextAndEncodedPassword$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateDeploymentNodeSelector = "EJBCLIENT000058: Failed to instantiate deployment node selector class \"%s\"";
    protected String cannotInstantiateDeploymentNodeSelector$str() {
        return cannotInstantiateDeploymentNodeSelector;
    }
    @Override
    public final IllegalArgumentException cannotInstantiateDeploymentNodeSelector(final String name, final ReflectiveOperationException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotInstantiateDeploymentNodeSelector$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToSendInvocationCancellationMessage(final short invocationId, final Exception e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, failedToSendInvocationCancellationMessage$str(), invocationId);
    }
    private static final String failedToSendInvocationCancellationMessage = "EJBCLIENT000059: Could not send a message over remoting channel, to cancel invocation for invocation id %s";
    protected String failedToSendInvocationCancellationMessage$str() {
        return failedToSendInvocationCancellationMessage;
    }
    private static final String failedToCreateScopedEjbClientContext = "EJBCLIENT000060: Failed to create scoped EJB client context";
    protected String failedToCreateScopedEjbClientContext$str() {
        return failedToCreateScopedEjbClientContext;
    }
    @Override
    public final RuntimeException failedToCreateScopedEjbClientContext(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(failedToCreateScopedEjbClientContext$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void transactionRecoveryMessageNotSupported(final EJBReceiver receiver) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, transactionRecoveryMessageNotSupported$str(), receiver);
    }
    private static final String transactionRecoveryMessageNotSupported = "EJBCLIENT000061: Cannot send a transaction recovery message to the server since the protocol version of EJBReceiver %s doesn't support it";
    protected String transactionRecoveryMessageNotSupported$str() {
        return transactionRecoveryMessageNotSupported;
    }
    private static final String lookupFailed = "EJBCLIENT000062: Failed to look up \"%s\"";
    protected String lookupFailed$str() {
        return lookupFailed;
    }
    @Override
    public final CommunicationException lookupFailed(final Name resolvedName, final Name name, final Exception e) {
        final CommunicationException result = new CommunicationException(String.format(lookupFailed$str(), name));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.setResolvedName(resolvedName);
        return result;
    }
    private static final String ejbIsAlreadyStateful = "EJBCLIENT000063: EJB proxy is already stateful";
    protected String ejbIsAlreadyStateful$str() {
        return ejbIsAlreadyStateful;
    }
    @Override
    public final IllegalArgumentException ejbIsAlreadyStateful() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(ejbIsAlreadyStateful$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ejbURLContextFactoryDeprecated() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, ejbURLContextFactoryDeprecated$str());
    }
    private static final String ejbURLContextFactoryDeprecated = "EJBCLIENT000064: org.jboss.ejb.client.naming.ejb.ejbURLContextFactory is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    protected String ejbURLContextFactoryDeprecated$str() {
        return ejbURLContextFactoryDeprecated;
    }
    private static final String nullSessionCreated = "EJBCLIENT000065: Null session was created for \"%s\", affinity %s, identifier %s";
    protected String nullSessionCreated$str() {
        return nullSessionCreated;
    }
    @Override
    public final CommunicationException nullSessionCreated(final Name resolvedName, final Name name, final Affinity affinity, final EJBIdentifier identifier) {
        final CommunicationException result = new CommunicationException(String.format(nullSessionCreated$str(), name, affinity, identifier));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.setResolvedName(resolvedName);
        return result;
    }
    private static final String operationInterrupted = "EJBCLIENT000066: Operation interrupted";
    protected String operationInterrupted$str() {
        return operationInterrupted;
    }
    @Override
    public final EJBException operationInterrupted() {
        final EJBException result = new EJBException(String.format(operationInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertToStateful = "EJBCLIENT000067: Cannot convert %s to stateful";
    protected String cannotConvertToStateful$str() {
        return cannotConvertToStateful;
    }
    @Override
    public final IllegalArgumentException cannotConvertToStateful(final EJBLocator<? extends Object> locator) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotConvertToStateful$str(), locator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateCallbackHandler = "EJBCLIENT000068: Failed to instantiate callback handler class \"%s\"";
    protected String cannotInstantiateCallbackHandler$str() {
        return cannotInstantiateCallbackHandler;
    }
    @Override
    public final IllegalArgumentException cannotInstantiateCallbackHandler(final String name, final ReflectiveOperationException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotInstantiateCallbackHandler$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void legacyEJBPropertiesSecurityConfigurationInUse() {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.INFO) && legacyEJBPropertiesSecurityConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, legacyEJBPropertiesSecurityConfigurationInUse$str());
        }
    }
    private static final String legacyEJBPropertiesSecurityConfigurationInUse = "EJBCLIENT000069: Using legacy jboss-ejb-client.properties security configuration";
    protected String legacyEJBPropertiesSecurityConfigurationInUse$str() {
        return legacyEJBPropertiesSecurityConfigurationInUse;
    }
    private static final AtomicBoolean legacyEJBPropertiesSecurityConfigurationInUse_$Once = new AtomicBoolean(false);
    @Override
    public final void legacyEJBPropertiesRemotingConfigurationInUse() {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.INFO) && legacyEJBPropertiesRemotingConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, legacyEJBPropertiesRemotingConfigurationInUse$str());
        }
    }
    private static final String legacyEJBPropertiesRemotingConfigurationInUse = "EJBCLIENT000070: Using legacy jboss-ejb-client.properties Remoting configuration";
    protected String legacyEJBPropertiesRemotingConfigurationInUse$str() {
        return legacyEJBPropertiesRemotingConfigurationInUse;
    }
    private static final AtomicBoolean legacyEJBPropertiesRemotingConfigurationInUse_$Once = new AtomicBoolean(false);
    @Override
    public final void legacyEJBPropertiesDiscoveryConfigurationInUse() {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.INFO) && legacyEJBPropertiesDiscoveryConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, legacyEJBPropertiesDiscoveryConfigurationInUse$str());
        }
    }
    private static final String legacyEJBPropertiesDiscoveryConfigurationInUse = "EJBCLIENT000071: Using legacy jboss-ejb-client.properties discovery configuration";
    protected String legacyEJBPropertiesDiscoveryConfigurationInUse$str() {
        return legacyEJBPropertiesDiscoveryConfigurationInUse;
    }
    private static final AtomicBoolean legacyEJBPropertiesDiscoveryConfigurationInUse_$Once = new AtomicBoolean(false);
    @Override
    public final void legacyEJBPropertiesEJBConfigurationInUse() {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.INFO) && legacyEJBPropertiesEJBConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, legacyEJBPropertiesEJBConfigurationInUse$str());
        }
    }
    private static final String legacyEJBPropertiesEJBConfigurationInUse = "EJBCLIENT000072: Using legacy jboss-ejb-client.properties EJB client configuration";
    protected String legacyEJBPropertiesEJBConfigurationInUse$str() {
        return legacyEJBPropertiesEJBConfigurationInUse;
    }
    private static final AtomicBoolean legacyEJBPropertiesEJBConfigurationInUse_$Once = new AtomicBoolean(false);
    private static final String failedToConstructEndpoint = "EJBCLIENT000073: Failed to construct Remoting endpoint";
    protected String failedToConstructEndpoint$str() {
        return failedToConstructEndpoint;
    }
    @Override
    public final IllegalStateException failedToConstructEndpoint(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(failedToConstructEndpoint$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String selectorReturnedNull = "EJBCLIENT000074: Configured selector \"%s\" returned null";
    protected String selectorReturnedNull$str() {
        return selectorReturnedNull;
    }
    @Override
    public final IllegalStateException selectorReturnedNull(final Object selector) {
        final IllegalStateException result = new IllegalStateException(String.format(selectorReturnedNull$str(), selector));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransportProvider = "EJBCLIENT000075: No transport provider available for URI scheme %2$s for locator %1$s";
    protected String noTransportProvider$str() {
        return noTransportProvider;
    }
    @Override
    public final IllegalStateException noTransportProvider(final EJBLocator<? extends Object> locator, final String scheme) {
        final IllegalStateException result = new IllegalStateException(String.format(noTransportProvider$str(), locator, scheme));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownProxy = "EJBCLIENT000100: Object '%s' is not a valid proxy object";
    protected String unknownProxy$str() {
        return unknownProxy;
    }
    @Override
    public final IllegalArgumentException unknownProxy(final Object proxy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownProxy$str(), proxy));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String proxyNotOurs = "EJBCLIENT000101: Proxy object '%s' was not generated by %s";
    protected String proxyNotOurs$str() {
        return proxyNotOurs;
    }
    @Override
    public final IllegalArgumentException proxyNotOurs(final Object proxy, final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(proxyNotOurs$str(), proxy, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAsyncInProgress = "EJBCLIENT000102: No asynchronous operation in progress";
    protected String noAsyncInProgress$str() {
        return noAsyncInProgress;
    }
    @Override
    public final IllegalStateException noAsyncInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(noAsyncInProgress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noJBossModules = "EJBCLIENT000200: Cannot load from a module when jboss-modules is not available";
    protected String noJBossModules$str() {
        return noJBossModules;
    }
    @Override
    public final ConfigXMLParseException noJBossModules(final ConfigurationXMLStreamReader streamReader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(noJBossModules$str()), streamReader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInterceptorConstructor = "EJBCLIENT000300: No valid no-argument constructor on interceptor %s";
    protected String noInterceptorConstructor$str() {
        return noInterceptorConstructor;
    }
    @Override
    public final IllegalArgumentException noInterceptorConstructor(final Class<? extends Object> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noInterceptorConstructor$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptorConstructorNotAccessible = "EJBCLIENT000301: Constructor is not accessible on interceptor %s";
    protected String interceptorConstructorNotAccessible$str() {
        return interceptorConstructorNotAccessible;
    }
    @Override
    public final IllegalArgumentException interceptorConstructorNotAccessible(final Class<? extends Object> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(interceptorConstructorNotAccessible$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptorConstructorFailed = "EJBCLIENT000302: Construction of interceptor %s failed";
    protected String interceptorConstructorFailed$str() {
        return interceptorConstructorFailed;
    }
    @Override
    public final IllegalStateException interceptorConstructorFailed(final Class<? extends Object> type, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(interceptorConstructorFailed$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteInvFailed = "EJBCLIENT000400: Remote invocation failed due to an exception";
    protected String remoteInvFailed$str() {
        return remoteInvFailed;
    }
    @Override
    public final ExecutionException remoteInvFailed(final Throwable cause) {
        final ExecutionException result = new ExecutionException(String.format(remoteInvFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String oneWayInvocation = "EJBCLIENT000401: Result was discarded (one-way invocation)";
    protected String oneWayInvocation$str() {
        return oneWayInvocation;
    }
    @Override
    public final IllegalStateException oneWayInvocation() {
        final IllegalStateException result = new IllegalStateException(String.format(oneWayInvocation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requestCancelled = "EJBCLIENT000402: Remote invocation request was cancelled";
    protected String requestCancelled$str() {
        return requestCancelled;
    }
    @Override
    public final CancellationException requestCancelled() {
        final CancellationException result = new CancellationException(String.format(requestCancelled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timedOut = "EJBCLIENT000403: Timed out";
    protected String timedOut$str() {
        return timedOut;
    }
    @Override
    public final TimeoutException timedOut() {
        final TimeoutException result = new TimeoutException(String.format(timedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionNoLongerActive = "EJBCLIENT000408: Inflowed transaction is no longer active";
    protected String transactionNoLongerActive$str() {
        return transactionNoLongerActive;
    }
    @Override
    public final SystemException transactionNoLongerActive() {
        final SystemException result = new SystemException(String.format(transactionNoLongerActive$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mismatchedMethodLocation = "EJBCLIENT000500: Protocol error: mismatched method location";
    protected String mismatchedMethodLocation$str() {
        return mismatchedMethodLocation;
    }
    @Override
    public final InvalidObjectException mismatchedMethodLocation() {
        final InvalidObjectException result = new InvalidObjectException(String.format(mismatchedMethodLocation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidMessageReceived(final int code) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, invalidMessageReceived$str(), code);
    }
    private static final String invalidMessageReceived = "EJBCLIENT000501: Protocol error: invalid message ID %02x received";
    protected String invalidMessageReceived$str() {
        return invalidMessageReceived;
    }
    private static final String invalidTransactionType = "EJBCLIENT000502: Protocol error: invalid transaction type %02x received";
    protected String invalidTransactionType$str() {
        return invalidTransactionType;
    }
    @Override
    public final IOException invalidTransactionType(final int type) {
        final IOException result = new IOException(String.format(invalidTransactionType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInflowTxn = "EJBCLIENT000503: Protocol error: unable to inflow remote transaction";
    protected String unableToInflowTxn$str() {
        return unableToInflowTxn;
    }
    @Override
    public final IOException unableToInflowTxn(final Exception e) {
        final IOException result = new IOException(String.format(unableToInflowTxn$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSessionCreated = "EJBCLIENT000504: Server error: no session was created";
    protected String noSessionCreated$str() {
        return noSessionCreated;
    }
    @Override
    public final IllegalStateException noSessionCreated() {
        final IllegalStateException result = new IllegalStateException(String.format(noSessionCreated$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noRemoteTransportOnEJBContext = "EJBCLIENT000505: No remote transport is present on the current EJB client context";
    protected String noRemoteTransportOnEJBContext$str() {
        return noRemoteTransportOnEJBContext;
    }
    @Override
    public final IllegalStateException noRemoteTransportOnEJBContext() {
        final IllegalStateException result = new IllegalStateException(String.format(noRemoteTransportOnEJBContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidViewTypeForInvocation = "EJBCLIENT000506: Server error (invalid view): %s";
    protected String invalidViewTypeForInvocation$str() {
        return invalidViewTypeForInvocation;
    }
    @Override
    public final EJBException invalidViewTypeForInvocation(final String serverMessage) {
        final EJBException result = new EJBException(String.format(invalidViewTypeForInvocation$str(), serverMessage));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteMessageNoSuchEJB = "No such EJB: %s";
    protected String remoteMessageNoSuchEJB$str() {
        return remoteMessageNoSuchEJB;
    }
    @Override
    public final String remoteMessageNoSuchEJB(final EJBIdentifier ejbIdentifier) {
        return String.format(remoteMessageNoSuchEJB$str(), ejbIdentifier);
    }
    private static final String remoteMessageEJBNotStateful = "EJB is not stateful: %s";
    protected String remoteMessageEJBNotStateful$str() {
        return remoteMessageEJBNotStateful;
    }
    @Override
    public final String remoteMessageEJBNotStateful(final EJBIdentifier ejbIdentifier) {
        return String.format(remoteMessageEJBNotStateful$str(), ejbIdentifier);
    }
    private static final String remoteMessageNoSuchMethod = "No such EJB method %s found on %s";
    protected String remoteMessageNoSuchMethod$str() {
        return remoteMessageNoSuchMethod;
    }
    @Override
    public final String remoteMessageNoSuchMethod(final EJBMethodLocator methodLocator, final EJBIdentifier ejbIdentifier) {
        return String.format(remoteMessageNoSuchMethod$str(), methodLocator, ejbIdentifier);
    }
    private static final String remoteMessageSessionNotActive = "Session is not active for invocation of method %s on %s";
    protected String remoteMessageSessionNotActive$str() {
        return remoteMessageSessionNotActive;
    }
    @Override
    public final String remoteMessageSessionNotActive(final EJBMethodLocator methodLocator, final EJBIdentifier locator) {
        return String.format(remoteMessageSessionNotActive$str(), methodLocator, locator);
    }
    private static final String remoteMessageBadViewType = "EJB view is not remote: %s";
    protected String remoteMessageBadViewType$str() {
        return remoteMessageBadViewType;
    }
    @Override
    public final String remoteMessageBadViewType(final EJBIdentifier ejbIdentifier) {
        return String.format(remoteMessageBadViewType$str(), ejbIdentifier);
    }
}
