/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.security.AccessController;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.legacy.JBossEJBProperties;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.LegacyConfiguration;
import org.wildfly.security.auth.client.MatchRule;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.sasl.SaslUtils;

public final class ElytronLegacyConfiguration
implements LegacyConfiguration {
    private static final String useQuietAuth = AccessController.doPrivileged(() -> System.getProperty("jboss.sasl.local-user.quiet-auth"));
    private static final String[] NO_STRINGS = new String[0];

    public AuthenticationContext getConfiguredAuthenticationContext() {
        AuthenticationContext context = AuthenticationContext.empty();
        JBossEJBProperties properties = JBossEJBProperties.getCurrent();
        if (properties == null) {
            return context;
        }
        Logs.MAIN.legacyEJBPropertiesSecurityConfigurationInUse();
        for (JBossEJBProperties.ConnectionConfiguration connectionConfiguration : properties.getConnectionList()) {
            MatchRule rule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
            AuthenticationConfiguration config = AuthenticationConfiguration.EMPTY;
            String host = connectionConfiguration.getHost();
            if (host == null) continue;
            rule = rule.matchHost(host);
            int port = connectionConfiguration.getPort();
            if (port != -1) {
                rule = rule.matchPort(port);
            }
            config = ElytronLegacyConfiguration.configureCommon(properties, connectionConfiguration, config);
            context = context.with(rule, config);
        }
        for (Map.Entry entry : properties.getClusterConfigurations().entrySet()) {
            String clusterName = (String)entry.getKey();
            JBossEJBProperties.ClusterConfiguration configuration = (JBossEJBProperties.ClusterConfiguration)entry.getValue();
            MatchRule defaultRule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
            AuthenticationConfiguration defaultConfig = AuthenticationConfiguration.EMPTY;
            defaultRule = defaultRule.matchProtocol("cluster");
            defaultRule = defaultRule.matchUrnName(clusterName);
            defaultConfig = ElytronLegacyConfiguration.configureCommon(properties, configuration, defaultConfig);
            context = context.with(defaultRule, defaultConfig);
            List<JBossEJBProperties.ClusterNodeConfiguration> nodeConfigurations = configuration.getNodeConfigurations();
            if (nodeConfigurations == null) continue;
            for (JBossEJBProperties.ClusterNodeConfiguration nodeConfiguration : nodeConfigurations) {
                MatchRule rule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
                AuthenticationConfiguration config = AuthenticationConfiguration.EMPTY;
                rule = rule.matchProtocol("node");
                rule = rule.matchUrnName(nodeConfiguration.getNodeName());
                config = ElytronLegacyConfiguration.configureCommon(properties, nodeConfiguration, config);
                context = context.with(rule, config);
            }
        }
        return context;
    }

    private static AuthenticationConfiguration configureCommon(JBossEJBProperties properties, JBossEJBProperties.CommonSubconfiguration configuration, AuthenticationConfiguration config) {
        String password;
        String realm;
        String userName;
        JBossEJBProperties.AuthenticationConfiguration authenticationConfiguration = configuration.getAuthenticationConfiguration();
        String string = userName = authenticationConfiguration == null ? null : authenticationConfiguration.getUserName();
        if (userName != null) {
            config = config.useName(userName);
        }
        String string2 = realm = authenticationConfiguration == null ? null : authenticationConfiguration.getMechanismRealm();
        if (realm != null) {
            config = config.useRealm(realm);
        }
        ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier = authenticationConfiguration == null ? null : authenticationConfiguration.getCallbackHandlerSupplier();
        CallbackHandler callbackHandler = null;
        if (callbackHandlerSupplier != null) {
            try {
                callbackHandler = (CallbackHandler)callbackHandlerSupplier.get();
            }
            catch (ReflectiveOperationException e) {
                throw Logs.MAIN.cannotInstantiateCallbackHandler(properties.getDefaultCallbackHandlerClassName(), e);
            }
            config = config.useCallbackHandler(callbackHandler);
        }
        String string3 = password = authenticationConfiguration == null ? null : authenticationConfiguration.getPassword();
        if (password != null) {
            config = config.usePassword(password);
        }
        OptionMap options = configuration.getConnectionOptions();
        if (useQuietAuth != null) {
            options = ElytronLegacyConfiguration.setQuietLocalAuth(options, Boolean.valueOf(useQuietAuth));
        } else if (callbackHandler != null || userName != null) {
            options = ElytronLegacyConfiguration.setQuietLocalAuth(options, false);
        }
        Map props = SaslUtils.createPropertyMap((OptionMap)options, (boolean)false);
        if (!props.isEmpty()) {
            config = config.useMechanismProperties(props);
        }
        if (options.contains(Options.SASL_DISALLOWED_MECHANISMS)) {
            config = config.forbidSaslMechanisms((String[])((Sequence)options.get(Options.SASL_DISALLOWED_MECHANISMS)).toArray((Object[])NO_STRINGS));
        } else if (options.contains(Options.SASL_MECHANISMS)) {
            config = config.allowSaslMechanisms((String[])((Sequence)options.get(Options.SASL_MECHANISMS)).toArray((Object[])NO_STRINGS));
        }
        config = config.useProvidersFromClassLoader(ElytronLegacyConfiguration.class.getClassLoader());
        return config;
    }

    private static OptionMap setQuietLocalAuth(OptionMap optionMap, boolean useQuietAuth) {
        Sequence existingSaslProps = (Sequence)optionMap.get(Options.SASL_PROPERTIES);
        if (existingSaslProps != null) {
            for (Property prop : existingSaslProps) {
                String propKey = prop.getKey();
                if (!propKey.equals("wildfly.sasl.local-user.quiet-auth") && !propKey.equals("jboss.sasl.local-user.quiet-auth")) continue;
                return optionMap;
            }
            existingSaslProps.add((Object)Property.of((String)"wildfly.sasl.local-user.quiet-auth", (String)Boolean.toString(useQuietAuth)));
            return optionMap;
        }
        OptionMap.Builder updatedOptionMapBuilder = OptionMap.builder().addAll(optionMap);
        updatedOptionMapBuilder.set(Options.SASL_PROPERTIES, (Object)Sequence.of((Object[])new Property[]{Property.of((String)"wildfly.sasl.local-user.quiet-auth", (String)Boolean.toString(useQuietAuth))}));
        return updatedOptionMapBuilder.getMap();
    }
}

