/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.concurrent.Executor;
import javax.ejb.CreateException;
import javax.net.ssl.SSLContext;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.ejb.protocol.remote.RemotingEJBDiscoveryProvider;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemoteEJBReceiver
extends EJBReceiver {
    static final AttachmentKey<EJBClientChannel> EJBCC_KEY = new AttachmentKey();
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final RemoteTransportProvider remoteTransportProvider;
    private final EJBReceiverContext receiverContext;
    private final RemotingEJBDiscoveryProvider discoveredNodeRegistry;
    final ClientServiceHandle<EJBClientChannel> serviceHandle;
    final IoFuture.HandlingNotifier<ConnectionPeerIdentity, EJBReceiverInvocationContext> notifier = new IoFuture.HandlingNotifier<ConnectionPeerIdentity, EJBReceiverInvocationContext>(){

        public void handleDone(ConnectionPeerIdentity peerIdentity, EJBReceiverInvocationContext attachment) {
            EJBClientChannel ejbClientChannel;
            try {
                ejbClientChannel = RemoteEJBReceiver.this.getClientChannel(peerIdentity.getConnection());
            }
            catch (IOException e) {
                attachment.requestFailed(new RequestSendFailedException(e + "@" + peerIdentity.getConnection().getPeerURI(), false), (Executor)peerIdentity.getConnection().getEndpoint().getXnioWorker());
                return;
            }
            attachment.getClientInvocationContext().putAttachment(EJBCC_KEY, ejbClientChannel);
            ejbClientChannel.processInvocation(attachment, peerIdentity);
        }

        public void handleCancelled(EJBReceiverInvocationContext attachment) {
            attachment.requestCancelled();
        }

        public void handleFailed(IOException exception, EJBReceiverInvocationContext attachment) {
            attachment.requestFailed(new RequestSendFailedException(exception, false), (Executor)Endpoint.getCurrent().getXnioWorker());
        }
    };

    RemoteEJBReceiver(RemoteTransportProvider remoteTransportProvider, EJBReceiverContext receiverContext, RemotingEJBDiscoveryProvider discoveredNodeRegistry) {
        this.remoteTransportProvider = remoteTransportProvider;
        this.receiverContext = receiverContext;
        this.discoveredNodeRegistry = discoveredNodeRegistry;
        this.serviceHandle = new ClientServiceHandle("jboss.ejb", channel -> EJBClientChannel.construct(channel, this.discoveredNodeRegistry));
    }

    RemoteTransportProvider getRemoteTransportProvider() {
        return this.remoteTransportProvider;
    }

    RemotingEJBDiscoveryProvider getDiscoveredNodeRegistry() {
        return this.discoveredNodeRegistry;
    }

    EJBReceiverContext getReceiverContext() {
        return this.receiverContext;
    }

    EJBClientChannel getClientChannel(Connection connection) throws IOException {
        try {
            return (EJBClientChannel)this.serviceHandle.getClientService(connection, OptionMap.EMPTY).getInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        AuthenticationConfiguration authenticationConfiguration = receiverContext.getAuthenticationConfiguration();
        SSLContext sslContext = receiverContext.getSSLContext();
        IoFuture<ConnectionPeerIdentity> futureConnection = this.getConnection(receiverContext.getClientInvocationContext().getDestination(), authenticationConfiguration, sslContext);
        futureConnection.addNotifier(this.notifier, (Object)receiverContext);
    }

    @Override
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        try {
            EJBClientChannel channel = receiverContext.getClientInvocationContext().getAttachment(EJBCC_KEY);
            return channel != null && channel.cancelInvocation(receiverContext, cancelIfRunning);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected StatefulEJBLocator<?> createSession(EJBReceiverSessionCreationContext context) throws Exception {
        StatelessEJBLocator<?> statelessLocator = context.getClientInvocationContext().getLocator().asStateless();
        AuthenticationConfiguration authenticationConfiguration = context.getAuthenticationConfiguration();
        SSLContext sslContext = context.getSSLContext();
        try {
            IoFuture<ConnectionPeerIdentity> futureConnection = this.getConnection(context.getClientInvocationContext().getDestination(), authenticationConfiguration, sslContext);
            ConnectionPeerIdentity identity = (ConnectionPeerIdentity)futureConnection.getInterruptibly();
            EJBClientChannel ejbClientChannel = this.getClientChannel(identity.getConnection());
            return ejbClientChannel.openSession(statelessLocator, identity);
        }
        catch (IOException e) {
            CreateException createException = new CreateException("Failed to create stateful EJB: " + e.getMessage());
            createException.initCause((Throwable)e);
            throw createException;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CreateException("Stateful EJB creation interrupted");
        }
    }

    @Override
    protected InetSocketAddress getSourceAddress(InetSocketAddress destination) {
        return Endpoint.getCurrent().getXnioWorker().getBindAddress(destination.getAddress());
    }

    @Override
    protected boolean isConnected(URI uri) {
        IoFuture future = Endpoint.getCurrent().getConnectedIdentityIfExists(uri, "ejb", "jboss", AuthenticationContext.captureCurrent());
        try {
            return future != null && future.getStatus() == IoFuture.Status.DONE && ((ConnectionPeerIdentity)future.get()).getConnection().isOpen();
        }
        catch (IOException e) {
            throw Assert.unreachableCode();
        }
    }

    private <T> IoFuture<ConnectionPeerIdentity> getConnection(URI target, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext) throws Exception {
        if (authenticationConfiguration == null) {
            authenticationConfiguration = CLIENT.getAuthenticationConfiguration(target, AuthenticationContext.captureCurrent(), -1, "ejb", "jboss");
        }
        if (sslContext == null) {
            sslContext = CLIENT.getSSLContext(target, AuthenticationContext.captureCurrent(), "ejb", "jboss");
        }
        SSLContext finalSslContext = sslContext;
        AuthenticationConfiguration finalAuthenticationConfiguration = authenticationConfiguration;
        return AccessController.doPrivileged(() -> Endpoint.getCurrent().getConnectedIdentity(target, finalSslContext, finalAuthenticationConfiguration));
    }
}

