/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.ejb.backwardscompatibility.ejb2;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.qa.ejb.backwardscompatibility.TestCaseParent;
import org.jboss.qa.ejb.backwardscompatibility.shared.SendRequest;
import org.jboss.qa.ejb.backwardscompatibility.shared.SendRequestRemote;
import org.jboss.qa.ejb.backwardscompatibility.shared.StaticInfoProvider;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb2.HomeInterface;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb2.RemoteInterface;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb2.StatelessBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.runner.RunWith;

/**
 * @author ochaloup@rehat.com
 */
@RunWith(Arquillian.class)
@RunAsClient
public class EJB2StatelessBeanTestCase extends TestCaseParent {
    private static final Logger log = Logger.getLogger(EJB2StatelessBeanTestCase.class);
    private static final String jarName = "ejb2-test";

    @Deployment(name = "ejb2-test", managed=true, testable=false)
    public static Archive<?> createDeployment() {
        JavaArchive jar = ShrinkWrap.create(JavaArchive.class, jarName + ".jar")
          .addClasses(StatelessBean.class, HomeInterface.class, RemoteInterface.class);
        jar.addClasses(SendRequest.class, SendRequestRemote.class, StaticInfoProvider.class);
        jar.addAsManifestResource("ejb2/ejb-jar-stateless.xml", "ejb-jar.xml");
        return jar;
    }

    @Override
    protected SendRequestRemote getBean() throws NamingException {
        HomeInterface homeIntf = ctxDirectory.lookupEJB2(jarName, StatelessBean.class, HomeInterface.class);
        try {
            return homeIntf.create();
        } catch (Exception e) {
            throw new RuntimeException(e); 
        }
    }

}
