/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.ejb.backwardscompatibility.ejb31;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import javax.naming.NamingException;

import junit.framework.Assert;

import org.apache.log4j.Logger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.qa.ejb.backwardscompatibility.ejb2.EJB2StatelessBeanTestCase;
import org.jboss.qa.ejb.backwardscompatibility.shared.SendRequest;
import org.jboss.qa.ejb.backwardscompatibility.shared.SendRequestRemote;
import org.jboss.qa.ejb.backwardscompatibility.shared.StaticInfoProvider;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.AsyncBeanRemote;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.AsyncStatefulBean;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.AsyncStatelessBean;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.SingletonBean;
import org.jboss.qa.ejb.jndi.InitialContextDirectory;
import org.jboss.qa.ejb.jndi.InitialContextDirectoryFactory;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author ochaloup@redhat.com
 */
@RunWith(Arquillian.class)
@RunAsClient
public class AsyncInvocationTestCase {

    private static final String jarName = "async-invocation-test";
    protected static InitialContextDirectory ctxDirectory;
    private static final Logger log = Logger.getLogger(EJB2StatelessBeanTestCase.class);

    @BeforeClass
    public static void prepare() {
        ctxDirectory = InitialContextDirectoryFactory.createDirectory();
    }

    @Deployment(name = "ejb3-test", managed=true, testable=false)
    public static Archive<?> createDeployment() {
        JavaArchive jar = ShrinkWrap.create(JavaArchive.class, jarName + ".jar")
          .addClasses(SingletonBean.class);
        jar.addClasses(AsyncStatelessBean.class, AsyncStatefulBean.class, AsyncBeanRemote.class);
        jar.addClasses(SendRequest.class, SendRequestRemote.class, StaticInfoProvider.class);
        return jar;
    }

    @Test
    public void testAsyncStateless() throws NamingException, InterruptedException, ExecutionException {
        log.info("************************** testAsync, stateless bean ****************************");
        AsyncBeanRemote bean = ctxDirectory.lookupStateless(jarName, AsyncStatelessBean.class, AsyncBeanRemote.class);
        // just calling async method
        bean.asyncMethod();
        // async method with returning value
        Future<Boolean> ret = bean.futureMethod();
        Assert.assertEquals("Async call on stateless bean should return true but it did not happen",
                Boolean.TRUE, ret.get());
    }

    @Test
    public void testAsyncStateful() throws NamingException, InterruptedException, ExecutionException {
        log.info("************************** testAsync, stateful bean ****************************");
        AsyncBeanRemote bean = ctxDirectory.lookupStateful(jarName, AsyncStatefulBean.class, AsyncBeanRemote.class);
        // just calling async method
        bean.asyncMethod();
        // async method with returning value
        Future<Boolean> ret = bean.futureMethod();
        Assert.assertEquals("Async call on stateful bean should return true but it did not happen",
                Boolean.TRUE, ret.get());
    }
}
