/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.ejb.jndi;

import org.apache.log4j.Logger;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;

/**
 * @author ochaloup
 */
public class InitialContextDirectoryEAP5HTTP extends InitialContextDirectory {
    private static final Logger log = Logger.getLogger(InitialContextDirectoryEAP5HTTP.class);
    // default credentials for http connection on eap 5.1.2
    private static final String USER_NAME = "admin";
    private static final String PASSWORD = "admin";
    
    public InitialContextDirectoryEAP5HTTP(String hostname, String port) {
        log.info("Using: " + this.getClass().getName() + " on host: " + hostname + ", port: " + port);
        try {
            prepareInitialContext(hostname, port);
        } catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }
    
    public InitialContextDirectoryEAP5HTTP(String hostname) {
        this(hostname, "8080");
    }
    
    public InitialContextDirectoryEAP5HTTP() {
        this("localhost");
    }
    
    private void prepareInitialContext(String hostname, String port) throws NamingException {
        Properties env = new Properties();
        env.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.jboss.naming.HttpNamingContextFactory");
        env.setProperty(Context.PROVIDER_URL, "http://" + hostname + ":" + port + "/invoker/JNDIFactory");
        env.put(Context.URL_PKG_PREFIXES, "org.jboss.naming");
        ctx = new InitialContext(env);
    }
    
    public <T> String createJndiName(String earName, Class<T> beanClass, BeanType beanType) {
        earName = (earName == null || earName.trim().isEmpty()) ? "" : earName + "/";
        String interfaceType = "remote";
        if(beanType == BeanType.EJB2) {
            // returning home interface - no other is remotely available
            interfaceType = "home";
        }
        if(beanType == BeanType.ENTITY) {
            // entity bean are bound somelike strange - check resources/entity/ejb-jar.xml
            return String.format("%s%s", earName, beanClass.getSimpleName());
        }
        String jndiName = earName + beanClass.getSimpleName() + "/" + interfaceType;
        return jndiName;
    }

    @Override
    public <T> T lookup(String earName, String jarName, Class<?> beanClass, Class<T> beanInterface, BeanType beanType, String distinctName)
            throws NamingException {
        String name = createJndiName(earName, beanClass, beanType);
        return getBean(name, beanInterface);
    }
}
