/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.tools.arquillian.extension;

/**
 * This type is intended to be checked from System.getProperty by ServerConfiguration definition.
 * 
 * @author ochaloup
 */
public enum EAP6AuthType {
    /** Is intended for standard authentication of user via credentials. On local machine you need to define 
     *  jboss-ejb-client.properties and set
     *  remote.connection.*.connect.options.org.xnio.Options.SASL_DISALLOWED_MECHANISMS to JBOSS-LOCAL-USER
     *  */
    USER,
    /**
     * This is possible just for localy run of the remote client. When remote client resides on the same machine as
     * the jboss server the server tries to write some dummy data to disk and when client is able to change them 
     * (= on the same system with sufficient disk write rights) then the client is automatically authenticated
     * for remote calls. 
     * You need to leave the property
     * remote.connection.*.connect.options.org.xnio.Options.SASL_DISALLOWED_MECHANISMS 
     * undefined or set it to NONE
     */
    LOCAL, 
    /**
     * The test will disable authentication on remote connector on server side. Then no authentication for
     * remote calls will be needed.
     */
    DISABLED
}
