package org.jboss.qa.tools.arquillian.extension;

import java.io.IOException;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.OP;
import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.OP_ADDR;
import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.OUTCOME;
import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.SUCCESS;

/**
 * @author jmartisk
 * @since 3/22/13
 */
public class EAP6LoggingLevelSetting implements ServerConfigurationDefinition {

    private LoggerLevel level;

    public EAP6LoggingLevelSetting(
            LoggerLevel level) {
        this.level = level;
    }

    @Override
    public void beforeStart(ManagementClient managementClient, ArquillianDescriptor descriptor) {

    }

    @Override
    public void afterStart(ManagementClient managementClient, ArquillianDescriptor descriptor) {
        setOtherLoggerLevels(managementClient.getControllerClient());
        setConsoleHandlerFormatter(managementClient.getControllerClient());
        setRootLoggerLevel(level, managementClient.getControllerClient());
        setConsoleHandlerLevel(level, managementClient.getControllerClient());
    }

    @Override
    public void beforeShutdown(ManagementClient managementClient, ArquillianDescriptor descriptor) {

    }

    @Override
    public void afterShutdown(ManagementClient managementClient, ArquillianDescriptor descriptor) {

    }

    enum LoggerLevel {
        ALL,
        FINEST,
        FINER,
        TRACE,
        DEBUG,
        FINE,
        CONFIG,
        INFO,
        WARN,
        WARNING,
        ERROR,
        FATAL,
        OFF
    }

    private void setRootLoggerLevel(LoggerLevel level, ModelControllerClient client) {
        ModelNode op = new ModelNode();
        op.get(OP_ADDR).add("subsystem", "logging");
        op.get(OP_ADDR).add("root-logger", "ROOT");
        op.get(OP).set("change-root-log-level");
        op.get("level").set(level.toString());
        try {
            ModelNode ret = client.execute(op);
            Assert.assertTrue(ret.get(OUTCOME).asString().equals(SUCCESS));
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }

    }

    private void setConsoleHandlerLevel(LoggerLevel level, ModelControllerClient client) {
        ModelNode op = new ModelNode();
        op.get(OP_ADDR).add("subsystem", "logging");
        op.get(OP_ADDR).add("console-handler", "CONSOLE");
        op.get(OP).set("change-log-level");
        op.get("level").set(level.toString());
        try {
            ModelNode ret = client.execute(op);
            Assert.assertTrue(ret.get(OUTCOME).asString().equals(SUCCESS));
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /**
     * prepends the word "SERVER" before all server-side logs into the console, so they can be easily separated from client logs.
     */
    private void setConsoleHandlerFormatter(ModelControllerClient client) {
        ModelNode op = new ModelNode();
        op.get(OP_ADDR).add("subsystem", "logging");
        op.get(OP_ADDR).add("console-handler", "CONSOLE");
        op.get(OP).set("write-attribute");
        op.get("name").set("formatter");
        op.get("value").set("SERVER: %K{level}%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%E%n");
        try {
            ModelNode ret = client.execute(op);
            Assert.assertTrue(ret.get(OUTCOME).asString().equals(SUCCESS));
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
        sets logger level to INFO for other loggers, which are not necessary for this testsuite - to prevent spam in logs
     */
    private void setOtherLoggerLevels(ModelControllerClient client) {
        for(String logger: new String[] {
                "org.jboss.as.webservices",
                "org.jboss.modules",
                "org.jboss.threads",
                "org.jboss.as.controller.management-operation",
                "org.jboss.as.server.deployment.scanner",
                "org.jboss.as.controller.client",
                "org.apache.catalina.session",
                "org.xnio.safe-close",
                "org.jboss.as.server.deployment",
                "javax.enterprise.resource.webcontainer.jsf.config",
        }) {
            System.out.println("setting logger " + logger + " to INFO");
            ModelNode op = new ModelNode();
            op.get(OP_ADDR).add("subsystem", "logging");
            op.get(OP_ADDR).add("logger", logger);
            op.get(OP).set("add");
            op.get("level").set("INFO");
            try     {
                client.execute(op);
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

}
