package org.jboss.qa.ejb.backwardscompatibility.shared.ejb31;

import org.apache.log4j.Logger;

import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateful;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
 * @author ochaloup
 */
@Stateful
@Asynchronous
public class AsyncStatefulBean implements AsyncBeanRemote {
    private static final Logger log = Logger.getLogger(AsyncStatefulBean.class);
    
    public void asyncMethod() throws InterruptedException {
        log.info("asyncMethod on stateful bean called");
    }

    public Future<Boolean> futureMethod() throws InterruptedException, ExecutionException {
        log.info("futureMethod on stateful bean called");
        return new AsyncResult<Boolean>(true);
    }
}
