package org.jboss.qa.ejb.backwardscompatibility.shared.ejb31;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;

import org.apache.log4j.Logger;

/**
 * @author ochaloup
 */
@Stateless
@Asynchronous
public class AsyncStatelessBean implements AsyncBeanRemote {
    private static final Logger log = Logger.getLogger(AsyncStatelessBean.class);
    
    public void asyncMethod() throws InterruptedException {
        log.info("asyncMethod on stateless bean called");
    }

    public Future<Boolean> futureMethod() throws InterruptedException, ExecutionException {
        log.info("futureMethod on stateless bean called");
        return new AsyncResult<Boolean>(true);
    }
}
