package org.jboss.qa.ejb.backwardscompatibility.eap6only.clientinterceptor;

import javax.naming.NamingException;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.qa.ejb.backwardscompatibility.shared.TestHelper;
import org.jboss.qa.ejb.jndi.InitialContextDirectory;
import org.jboss.qa.ejb.jndi.InitialContextDirectoryFactory;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * The client passes invocation context data to the server using a client-side interceptor.
 * The server side bean is supposed to read the context data and return it back to the client.
 * WeirdCompoundValue is used as the class for the passed context data.
 * @author Jan Martiska
 */
@RunWith(Arquillian.class)
@RunAsClient
public class ClientInterceptorTestCase {

    public static final String MODULE_NAME = "client-interceptor";

    protected static InitialContextDirectory ctxDirectory;

    @Deployment(name = MODULE_NAME, testable = false)
    public static JavaArchive deployment() {
        final JavaArchive jar = ShrinkWrap.create(JavaArchive.class, MODULE_NAME + ".jar");
        jar.addPackage(ClientInterceptorTestCase.class.getPackage());
        return jar;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        // only for non-scoped EJB client contexts
        // TODO perhaps it will be possible when EJBCLIENT-90 is resolved somehow
        Assume.assumeTrue(TestHelper.getJndiLookupType().equalsIgnoreCase("ejb"));
        ctxDirectory = InitialContextDirectoryFactory
                .createDirectory();
    }

    @Test
    @SuppressWarnings("unchecked")
    public void doStateful() throws NamingException {
        Object o = ctxDirectory.lookupStateful(MODULE_NAME, BeanAcceptingContextDataStateful.class, BeanAcceptingContextData.class);
        System.out.println(o.getClass() + o.toString());
        BeanAcceptingContextData<WeirdCompoundValue> instance = (BeanAcceptingContextData<WeirdCompoundValue>)o;
        WeirdCompoundValue original = new WeirdCompoundValue();
        EJBClientContext.getCurrent().registerInterceptor(1,
                new TestEJBClientInterceptorAddingContextData<WeirdCompoundValue>("key", original));
        WeirdCompoundValue returned = instance.returnContextData("key");
        Assert.assertNotNull("Server did not return context data", returned);
        Assert.assertEquals("Server returned context data, but it is corrupt", original, returned);
    }

    @Test
    @SuppressWarnings("unchecked")
    public void doStateless() throws NamingException {
        Object o = ctxDirectory.lookupStateless(MODULE_NAME, BeanAcceptingContextDataStateless.class, BeanAcceptingContextData.class);
        System.out.println(o.getClass() + o.toString());
        BeanAcceptingContextData<WeirdCompoundValue> instance = (BeanAcceptingContextData<WeirdCompoundValue>)o;
        WeirdCompoundValue original = new WeirdCompoundValue();
        EJBClientContext.getCurrent().registerInterceptor(1,
                new TestEJBClientInterceptorAddingContextData<WeirdCompoundValue>("key", original));
        WeirdCompoundValue returned = instance.returnContextData("key");
        Assert.assertNotNull("Server did not return context data", returned);
        Assert.assertEquals("Server returned context data, but it is corrupt", original, returned);
    }

    @Test
    @SuppressWarnings("unchecked")
    public void doSingleton() throws NamingException {
        Object o = ctxDirectory.lookupStateless(MODULE_NAME, BeanAcceptingContextDataSingleton.class, BeanAcceptingContextData.class);
        System.out.println(o.getClass() + o.toString());
        BeanAcceptingContextData<WeirdCompoundValue> instance = (BeanAcceptingContextData<WeirdCompoundValue>)o;
        WeirdCompoundValue original = new WeirdCompoundValue();
        EJBClientContext.requireCurrent().registerInterceptor(1,
                new TestEJBClientInterceptorAddingContextData<WeirdCompoundValue>("key", original));
        WeirdCompoundValue returned = instance.returnContextData("key");
        Assert.assertNotNull("Server did not return context data", returned);
        Assert.assertEquals("Server returned context data, but it is corrupt", original, returned);
    }

}
