package org.jboss.qa.ejb.backwardscompatibility.ejb31;

import javax.naming.NamingException;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.qa.ejb.backwardscompatibility.TestCaseParent;
import org.jboss.qa.ejb.backwardscompatibility.shared.SendRequest;
import org.jboss.qa.ejb.backwardscompatibility.shared.SendRequestRemote;
import org.jboss.qa.ejb.backwardscompatibility.shared.StaticInfoProvider;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.AsyncBeanRemote;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.AsyncStatefulBean;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.AsyncStatelessBean;
import org.jboss.qa.ejb.backwardscompatibility.shared.ejb31.SingletonBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.runner.RunWith;

/**
 * @author jmartisk
 */
@RunWith(Arquillian.class)
@RunAsClient
public class EJB31SingletonBeanTestCase extends TestCaseParent {

    private static final String jarName = "ee6-test";

    @Deployment(name = "ejb3-test", managed=true, testable=false)
    public static Archive<?> createDeployment() {
        JavaArchive jar = ShrinkWrap.create(JavaArchive.class, jarName + ".jar")
                .addClasses(SingletonBean.class);
        jar.addClasses(AsyncStatelessBean.class, AsyncStatefulBean.class, AsyncBeanRemote.class);
        jar.addClasses(SendRequest.class, SendRequestRemote.class, StaticInfoProvider.class);
        return jar;
    }

    @Override
    protected SendRequestRemote getBean() throws NamingException {
        return ctxDirectory.lookupSingleton(jarName, SingletonBean.class, SendRequestRemote.class);
    }

}
