/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.ejb.backwardscompatibility.entitybean;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchEJBException;

/**
 * @author ochaloup
 */
public class TestingEntityBean implements EntityBean {
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger ID = new AtomicInteger();

    private String value;
    private EntityContext entityContext;
    private boolean ejbPostCreateCalled = false;

    public Integer ejbCreateEmpty() {
        int primaryKey = ID.incrementAndGet();
        DataStore.DATA.put(primaryKey, this.value);
        return primaryKey;
    }

    public Integer ejbCreateWithValue(String value) {
        int primaryKey = ID.incrementAndGet();
        this.value = value;
        DataStore.DATA.put(primaryKey, value);
        return primaryKey;
    }


    public void ejbPostCreateEmpty() {
        ejbPostCreateCalled = true;
    }

    public void ejbPostCreateWithValue(String value) {
        ejbPostCreateCalled = true;
    }

    public Integer ejbFindByValue(String value)  {
        for (Map.Entry<Integer, String> entry : DataStore.DATA.entrySet()) {
            if (entry.getValue().equals(value)) {
                return entry.getKey();
            }
        }
        return null;
    }

    public Integer ejbFindByPrimaryKey(Integer primaryKey)  {
        return DataStore.DATA.containsKey(primaryKey) ? primaryKey : null;
    }

    public Collection<Integer> ejbFindCollection()  {
        return DataStore.DATA.keySet();
    }

    @Override
    public void setEntityContext(final EntityContext ctx) {
        this.entityContext = ctx;
    }

    @Override
    public void unsetEntityContext() {
        this.entityContext = null;
    }

    @Override
    public void ejbRemove() {
        DataStore.DATA.remove(entityContext.getPrimaryKey());
    }

    @Override
    public void ejbActivate() {

    }

    @Override
    public void ejbPassivate() {
        this.value = null;
    }

    @Override
    public void ejbLoad() throws EJBException, RemoteException {
        if (!DataStore.DATA.containsKey(entityContext.getPrimaryKey())) {
            throw new NoSuchEJBException("no EJB with id "
                    + entityContext.getPrimaryKey());
        }
        this.value = DataStore.DATA.get(entityContext.getPrimaryKey());
    }

    @Override
    public void ejbStore() {
        DataStore.DATA.put((Integer) entityContext.getPrimaryKey(), this.value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(final String value) {
        this.value = value;
    }

    public boolean isEjbPostCreateCalled() {
        return ejbPostCreateCalled;
    }
}
