package org.jboss.qa.ejb.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.qa.tools.arquillian.extension.EAP6AuthType;
import org.jboss.qa.tools.arquillian.extension.EAP6TestProperties;
import org.jboss.qa.tools.arquillian.extension.EAP6UserAuthConfiguration;

/**
 * @author jmartisk
 */
public class InitialContextDirectoryEAP6EJBMapBased extends InitialContextDirectory {
    private static final Logger log = Logger.getLogger(InitialContextDirectoryEAP6EJBMapBased.class);
    private ContextSelector<EJBClientContext> previousSelector;
    private String previousClassLoaderSkipPropertyValue;

    public InitialContextDirectoryEAP6EJBMapBased(String hostname, String port) {
        log.info("Using: " + this.getClass().getName() + " on host: " + hostname + ", port: " + port);
        try {
            prepareIntialContext(hostname, port);
        } catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    public InitialContextDirectoryEAP6EJBMapBased(String hostname) {
        this(hostname, "4447");
    }

    public InitialContextDirectoryEAP6EJBMapBased() {
        this("localhost");
    }
    
    private void prepareIntialContext(String hostname, String port) throws NamingException {
        previousClassLoaderSkipPropertyValue = System.getProperty(CLASSLOADER_SCAN_PROPERTY_NAME);
        System.setProperty(CLASSLOADER_SCAN_PROPERTY_NAME, "true");

        Properties env = new Properties();
        env.put(Context.URL_PKG_PREFIXES, "org.jboss.ejb.client.naming");
        env.put("org.jboss.ejb.client.scoped.context", true);
        env.put("endpoint.name", "client-endpoint");
        env.put("remote.connections", "main");
        env.put("remote.connection.main.host", hostname);
        env.put("remote.connection.main.port", port);
        env.put("remote.connection.main.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS","true");
        env.put("remote.connection.main.connect.options.org.xnio.Options.SASL_POLICY_NOPLAINTEXT","true");
        env.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
        if(EAP6TestProperties.AUTH_TYPE == EAP6AuthType.USER || EAP6TestProperties.AUTH_TYPE == EAP6AuthType.DISABLED) {
            env.put("remote.connection.main.connect.options.org.xnio.Options.SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
        }
        if(EAP6TestProperties.AUTH_TYPE == EAP6AuthType.LOCAL) {
            env.put("remote.connection.default.connect.options.org.xnio.Options.SASL_DISALLOWED_MECHANISMS", "NONE");
        }
        env.put("remote.connection.main.username", EAP6UserAuthConfiguration.USER_NAME);
        env.put("remote.connection.main.password", EAP6UserAuthConfiguration.PASSWORD);
        ctx = new InitialContext(env);
    }
    
    public <T> String createJndiName(String earName, String jarName, Class<?> beanClass, Class<T> beanInterface, BeanType type, String distinctName) {
        return String.format("ejb:%s/%s/%s/%s!%s%s",
                earName, jarName, distinctName == null ? "" : distinctName, beanClass.getSimpleName(), beanInterface.getName(),
                (type == BeanType.STATEFUL) ? "?stateful" : "");
    }

    @Override
    public <T> T lookup(String earName, String jarName, Class<?> beanClass, Class<T> beanInterface, BeanType beanType, String distinctName)
            throws NamingException {
        earName = earName == null ? "" : earName;
        String name = createJndiName(earName, jarName, beanClass, beanInterface, beanType, distinctName);
        return getBean(name, beanInterface);
    }
    
    @Override
    public void close() {
        if(previousClassLoaderSkipPropertyValue != null)
            System.setProperty(CLASSLOADER_SCAN_PROPERTY_NAME, previousClassLoaderSkipPropertyValue);
        super.close();
    }
}
