/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.tools.arquillian.extension;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.as.arquillian.container.ManagementClient;

/**
 * @author ochaloup
 */
public class EAP6TestProperties implements ServerConfigurationDefinition {
    // properties checked in tests
    public static EAP6AuthType AUTH_TYPE = EAP6AuthType.USER;
    
    // system properties names that will be checked
    private static String SYSTEM_PROPERTY_AUTHTYPE = "eap6.auth.type";

    @Override
    public void beforeStart(ManagementClient managementClient, ArquillianDescriptor descriptor) {
        String authType = System.getProperty(SYSTEM_PROPERTY_AUTHTYPE, "USER");

        // in case of incorrect auth type the system will throw IllegalArgumentException
        AUTH_TYPE = EAP6AuthType.valueOf(authType.toUpperCase());
    }

    @Override
    public void afterShutdown(ManagementClient managementClient, ArquillianDescriptor descriptor) {
        // nothing to do
    }

    @Override
    public void afterStart(ManagementClient managementClient, ArquillianDescriptor descriptor) {
        // nothing to do
    }

    @Override
    public void beforeShutdown(ManagementClient managementClient, ArquillianDescriptor descriptor) {
        // nothing to do        
    }

}
