/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jboss.metadata.plugins.loader.BasicMetaDataLoader;
import org.jboss.metadata.plugins.loader.SimpleMetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedElementMetaDataLoader
extends BasicMetaDataLoader {
    private AnnotatedElement annotated;

    private static final ScopeKey getScopeKey(AnnotatedElement annotated) {
        Scope scope;
        if (annotated instanceof Class) {
            Class clazz = (Class)Class.class.cast(annotated);
            scope = new Scope(CommonLevels.CLASS, clazz);
        } else if (annotated instanceof Member) {
            Member member = (Member)((Object)annotated);
            scope = new Scope(CommonLevels.JOINPOINT, member);
        } else {
            return ScopeKey.DEFAULT_SCOPE;
        }
        return new ScopeKey(scope);
    }

    public AnnotatedElementMetaDataLoader(AnnotatedElement annotated) {
        super(AnnotatedElementMetaDataLoader.getScopeKey(annotated));
        if (annotated == null) {
            throw new IllegalArgumentException("Null annotated element");
        }
        this.annotated = annotated;
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        Annotation[] annotations = this.annotated.getAnnotations();
        if (annotations.length == 0) {
            return SimpleAnnotationsItem.NO_ANNOTATIONS;
        }
        AnnotationItem[] items = new AnnotationItem[annotations.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SimpleAnnotationItem<Annotation>(annotations[i]);
        }
        return new SimpleAnnotationsItem(items);
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        T annotation = this.annotated.getAnnotation(annotationType);
        if (annotation == null) {
            return null;
        }
        return new SimpleAnnotationItem<T>(annotation);
    }

    @Override
    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        if (signature == null) {
            return null;
        }
        if (this.annotated instanceof Class) {
            Class clazz = (Class)Class.class.cast(this.annotated);
            if (signature instanceof ConstructorSignature) {
                try {
                    Constructor constructor = clazz.getConstructor(signature.getParametersTypes(clazz));
                    return new AnnotatedElementMetaDataLoader(constructor);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
            if (signature instanceof MethodSignature) {
                try {
                    Method method = clazz.getMethod(signature.getName(), signature.getParametersTypes(clazz));
                    return new AnnotatedElementMetaDataLoader(method);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
            if (signature instanceof MethodParametersSignature) {
                try {
                    Method method = clazz.getMethod(signature.getName(), signature.getParametersTypes(clazz));
                    Annotation[][] paramAnnotations = method.getParameterAnnotations();
                    MethodParametersSignature sig = (MethodParametersSignature)signature;
                    return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
            if (signature instanceof FieldSignature) {
                try {
                    Field field = clazz.getField(signature.getName());
                    return new AnnotatedElementMetaDataLoader(field);
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
        }
        if (this.annotated instanceof Method && signature instanceof MethodParametersSignature) {
            Method method = (Method)this.annotated;
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            MethodParametersSignature sig = (MethodParametersSignature)signature;
            return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
        }
        if (this.annotated instanceof Constructor && signature instanceof MethodParametersSignature) {
            Constructor constructor = (Constructor)Constructor.class.cast(this.annotated);
            Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
            MethodParametersSignature sig = (MethodParametersSignature)signature;
            return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        Annotation[] annotations = this.annotated.getAnnotations();
        return annotations == null || annotations.length == 0;
    }

    public String toString() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        Strings.defaultToString((JBossStringBuilder)buffer, (Object)this);
        buffer.append("[");
        buffer.append((Object)this.annotated);
        buffer.append("]");
        return buffer.toString();
    }
}

