/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.reflection.test;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.loader.reflection.support.NotPublic;
import org.jboss.test.metadata.loader.reflection.support.SuperClassOfNotPublic;
import org.jboss.test.metadata.shared.support.ExpectedAnnotations;
import org.jboss.test.metadata.shared.support.NotPresentAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation;

public class AnnotatedElementLoaderNotPublicUnitTestCase
extends AbstractMetaDataTest {
    public AnnotatedElementLoaderNotPublicUnitTestCase(String name) {
        super(name);
    }

    public void testNotPublicConstructor() throws Exception {
        MetaData metaData = this.createMetaData();
        this.testTestAnnotation(metaData.getComponentMetaData((Signature)new ConstructorSignature(new Class[0])));
    }

    public void testNotPublicMethod() throws Exception {
        MetaData metaData = this.createMetaData();
        this.testTestAnnotation(metaData.getComponentMetaData((Signature)new MethodSignature("notPublic", new Class[0])));
    }

    public void testNotPublicField() throws Exception {
        MetaData metaData = this.createMetaData();
        this.testTestAnnotation(metaData.getComponentMetaData((Signature)new FieldSignature("notPublic")));
    }

    public void testNotPublicMethodSuperClass() throws Exception {
        MetaData metaData = this.createMetaData();
        this.testTestAnnotation(metaData.getComponentMetaData((Signature)new MethodSignature("notPublicSuperClass", new Class[0])));
    }

    public void testNotPublicFieldSuperClass() throws Exception {
        MetaData metaData = this.createMetaData();
        this.testTestAnnotation(metaData.getComponentMetaData((Signature)new FieldSignature("notPublicSuperClass")));
    }

    public void testSameName() throws Exception {
        MetaData metaData = this.createMetaData();
        Method superMethod = SuperClassOfNotPublic.class.getDeclaredMethod("sameName", new Class[0]);
        MetaData superMethodMetaData = metaData.getComponentMetaData(Signature.getSignature((Member)superMethod));
        this.assertAnnotation(superMethodMetaData, TestAnnotation.class);
        Method method = NotPublic.class.getDeclaredMethod("sameName", new Class[0]);
        MetaData methodMetaData = metaData.getComponentMetaData(Signature.getSignature((Member)method));
        this.assertNoAnnotation(methodMetaData, TestAnnotation.class);
    }

    protected void testTestAnnotation(MetaData metaData) throws Exception {
        AnnotatedElementLoaderNotPublicUnitTestCase.assertNotNull((Object)metaData);
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        expectedAnnotations.add(TestAnnotation.class);
        this.assertAllAnnotations(metaData, expectedAnnotations, false);
    }

    protected MetaData createMetaData() {
        AnnotatedElementMetaDataLoader loader = new AnnotatedElementMetaDataLoader(NotPublic.class);
        return new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)loader);
    }
}

