/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.repository.test;

import java.util.HashSet;
import java.util.Set;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.repository.support.TestMetaDataRetrievalFactory;

public abstract class MutableMetaDataRepositoryTest
extends AbstractMetaDataTest {
    private static ScopeLevel testLevel1 = new ScopeLevel(1, "ONE");
    private static ScopeLevel testLevel2 = new ScopeLevel(2, "TWO");
    private static ScopeLevel testLevel3 = new ScopeLevel(3, "THREE");
    private static String testQualifier1 = "qualifier1";
    private static String testQualifier1Different = "qualifier1Different";
    private static String testQualifier2 = "qualifier2";
    private static String testQualifier2Different = "qualifier2Different";
    private static String testQualifier3 = "qualifier3";
    private static Scope testScope1 = new Scope(testLevel1, (Object)testQualifier1);
    private static Scope testScope1Different = new Scope(testLevel1, (Object)testQualifier1Different);
    private static Scope testScope2 = new Scope(testLevel2, (Object)testQualifier2);
    private static Scope testScope2Different = new Scope(testLevel2, (Object)testQualifier2Different);
    private static Scope testScope3 = new Scope(testLevel3, (Object)testQualifier3);
    private static ScopeKey testKey1 = new ScopeKey(testScope1);
    private static ScopeKey testKey2 = new ScopeKey(testScope2);
    private static ScopeKey testKey1Different = new ScopeKey(testScope1Different);
    private static ScopeKey testKey12 = new ScopeKey(new Scope[]{testScope1, testScope2});
    private static ScopeKey testKey12Different = new ScopeKey(new Scope[]{testScope1, testScope2Different});
    private static ScopeKey testKey123 = new ScopeKey(new Scope[]{testScope1, testScope2, testScope3});
    private static ScopeKey testKey123Different = new ScopeKey(new Scope[]{testScope1Different, testScope2, testScope3});

    public MutableMetaDataRepositoryTest(String name) {
        super(name);
    }

    protected abstract MutableMetaDataRepository setupEmpty();

    public void testAddOneScope() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader == retrieval ? 1 : 0) != 0);
    }

    public void testAddOneScopeDifferent() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MutableMetaDataLoader loader1Different = this.createTestMutableMetaDataLoader(testKey1Different);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1Different, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        retrieval = repository.getMetaDataRetrieval(testKey1Different);
        MutableMetaDataRepositoryTest.assertTrue((loader1Different == retrieval ? 1 : 0) != 0);
    }

    public void testReplaceOneScope() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader2, (MetaDataRetrieval)loader1);
        retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader2 == retrieval ? 1 : 0) != 0);
    }

    public void testRemoveOneScope() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        this.assertRemoveMetaDataRetrieval(repository, testKey1, (MetaDataRetrieval)loader1);
        retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertNull((Object)retrieval);
    }

    public void testRemoveOneScopeDifferent() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        this.assertRemoveMetaDataRetrieval(repository, testKey1Different, null);
        retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
    }

    public void testAddMutlipleScope() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader == retrieval ? 1 : 0) != 0);
    }

    public void testAddMultipleScopeDifferent() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MutableMetaDataLoader loader1Different = this.createTestMutableMetaDataLoader(testKey123Different);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1Different, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        retrieval = repository.getMetaDataRetrieval(testKey123Different);
        MutableMetaDataRepositoryTest.assertTrue((loader1Different == retrieval ? 1 : 0) != 0);
    }

    public void testReplaceMultipleScope() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader2, (MetaDataRetrieval)loader1);
        retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader2 == retrieval ? 1 : 0) != 0);
    }

    public void testRemoveMultipleScope() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        this.assertRemoveMetaDataRetrieval(repository, testKey123, (MetaDataRetrieval)loader1);
        retrieval = repository.getMetaDataRetrieval(testKey1);
        MutableMetaDataRepositoryTest.assertNull((Object)retrieval);
    }

    public void testRemoveMultipleScopeDifferent() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
        this.assertRemoveMetaDataRetrieval(repository, testKey123Different, null);
        retrieval = repository.getMetaDataRetrieval(testKey123);
        MutableMetaDataRepositoryTest.assertTrue((loader1 == retrieval ? 1 : 0) != 0);
    }

    public void testGetChildrenEmpty() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        Set result = repository.getChildren(testKey1);
        MutableMetaDataRepositoryTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryTest.assertEquals((int)0, (int)result.size());
    }

    public void testGetNoChildren() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        Set result = repository.getChildren(testKey1);
        MutableMetaDataRepositoryTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryTest.assertEquals((int)0, (int)result.size());
    }

    public void testOneChild() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MutableMetaDataLoader loader12 = this.createTestMutableMetaDataLoader(testKey12);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader12, null);
        Set result = repository.getChildren(testKey1);
        MutableMetaDataRepositoryTest.assertNotNull((Object)result);
        HashSet<ScopeKey> expected = new HashSet<ScopeKey>();
        expected.add(testKey12);
        MutableMetaDataRepositoryTest.assertEquals(expected, (Object)result);
    }

    public void testTwoChild() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MutableMetaDataLoader loader12 = this.createTestMutableMetaDataLoader(testKey12);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader12, null);
        MutableMetaDataLoader loader12Different = this.createTestMutableMetaDataLoader(testKey12Different);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader12Different, null);
        Set result = repository.getChildren(testKey1);
        MutableMetaDataRepositoryTest.assertNotNull((Object)result);
        HashSet<ScopeKey> expected = new HashSet<ScopeKey>();
        expected.add(testKey12);
        expected.add(testKey12Different);
        MutableMetaDataRepositoryTest.assertEquals(expected, (Object)result);
    }

    public void testTooManyScopes() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader1, null);
        MutableMetaDataLoader loader123 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader123, null);
        Set result = repository.getChildren(testKey1);
        MutableMetaDataRepositoryTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryTest.assertEquals((int)0, (int)result.size());
    }

    public void testManyScopes() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader12 = this.createTestMutableMetaDataLoader(testKey12);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader12, null);
        MutableMetaDataLoader loader123 = this.createTestMutableMetaDataLoader(testKey123);
        this.assertAddMetaDataRetrieval(repository, (MetaDataRetrieval)loader123, null);
        Set result = repository.getChildren(testKey12);
        MutableMetaDataRepositoryTest.assertNotNull((Object)result);
        HashSet<ScopeKey> expected = new HashSet<ScopeKey>();
        expected.add(testKey123);
        MutableMetaDataRepositoryTest.assertEquals(expected, (Object)result);
    }

    public void testAddMetaDataRetrievalFactory() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataRepositoryTest.assertNull((Object)repository.getMetaDataRetrievalFactory(testLevel1));
        TestMetaDataRetrievalFactory factory1 = new TestMetaDataRetrievalFactory();
        MutableMetaDataRepositoryTest.assertNull((Object)repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory1));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory1, (Object)repository.getMetaDataRetrievalFactory(testLevel1));
        TestMetaDataRetrievalFactory factory2 = new TestMetaDataRetrievalFactory();
        MutableMetaDataRepositoryTest.assertEquals((Object)factory1, (Object)repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory2));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory2, (Object)repository.getMetaDataRetrievalFactory(testLevel1));
        TestMetaDataRetrievalFactory factory3 = new TestMetaDataRetrievalFactory();
        MutableMetaDataRepositoryTest.assertNull((Object)repository.addMetaDataRetrievalFactory(testLevel2, (MetaDataRetrievalFactory)factory3));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory2, (Object)repository.getMetaDataRetrievalFactory(testLevel1));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory3, (Object)repository.getMetaDataRetrievalFactory(testLevel2));
    }

    public void testRemoveMetaDataRetrievalFactory() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataRepositoryTest.assertNull((Object)repository.getMetaDataRetrievalFactory(testLevel1));
        TestMetaDataRetrievalFactory factory1 = new TestMetaDataRetrievalFactory();
        MutableMetaDataRepositoryTest.assertNull((Object)repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory1));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory1, (Object)repository.removeMetaDataRetrievalFactory(testLevel1));
        MutableMetaDataRepositoryTest.assertNull((Object)repository.getMetaDataRetrievalFactory(testLevel1));
        MutableMetaDataRepositoryTest.assertNull((Object)repository.removeMetaDataRetrievalFactory(testLevel1));
        TestMetaDataRetrievalFactory factory2 = new TestMetaDataRetrievalFactory();
        MutableMetaDataRepositoryTest.assertNull((Object)repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory1));
        MutableMetaDataRepositoryTest.assertNull((Object)repository.addMetaDataRetrievalFactory(testLevel2, (MetaDataRetrievalFactory)factory2));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory1, (Object)repository.removeMetaDataRetrievalFactory(testLevel1));
        MutableMetaDataRepositoryTest.assertNull((Object)repository.getMetaDataRetrievalFactory(testLevel1));
        MutableMetaDataRepositoryTest.assertNull((Object)repository.removeMetaDataRetrievalFactory(testLevel1));
        MutableMetaDataRepositoryTest.assertEquals((Object)factory2, (Object)repository.getMetaDataRetrievalFactory(testLevel2));
    }

    public void testBasicMetaDataRetrievalFactory() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        TestMetaDataRetrievalFactory factory1 = new TestMetaDataRetrievalFactory();
        repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory1);
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        factory1.retrievals.put(testScope1, (MetaDataRetrieval)loader1);
        MutableMetaDataRepositoryTest.assertEquals((Object)loader1, (Object)repository.getMetaDataRetrieval(testKey1));
    }

    public void testMultipleRetrievalMetaDataRetrievalFactory() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        TestMetaDataRetrievalFactory factory1 = new TestMetaDataRetrievalFactory();
        repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory1);
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        factory1.retrievals.put(testScope1, (MetaDataRetrieval)loader1);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey1Different);
        factory1.retrievals.put(testScope1Different, (MetaDataRetrieval)loader2);
        MutableMetaDataRepositoryTest.assertEquals((Object)loader1, (Object)repository.getMetaDataRetrieval(testKey1));
        MutableMetaDataRepositoryTest.assertEquals((Object)loader2, (Object)repository.getMetaDataRetrieval(testKey1Different));
    }

    public void testMultipleMetaDataRetrievalFactories() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        TestMetaDataRetrievalFactory factory1 = new TestMetaDataRetrievalFactory();
        repository.addMetaDataRetrievalFactory(testLevel1, (MetaDataRetrievalFactory)factory1);
        TestMetaDataRetrievalFactory factory2 = new TestMetaDataRetrievalFactory();
        repository.addMetaDataRetrievalFactory(testLevel2, (MetaDataRetrievalFactory)factory2);
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        factory1.retrievals.put(testScope1, (MetaDataRetrieval)loader1);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey2);
        factory2.retrievals.put(testScope2, (MetaDataRetrieval)loader2);
        MutableMetaDataRepositoryTest.assertEquals((Object)loader1, (Object)repository.getMetaDataRetrieval(testKey1));
        MutableMetaDataRepositoryTest.assertEquals((Object)loader2, (Object)repository.getMetaDataRetrieval(testKey2));
    }

    protected void assertAddMetaDataRetrieval(MutableMetaDataRepository repository, MetaDataRetrieval add, MetaDataRetrieval expected) throws Exception {
        MetaDataRetrieval previous = repository.addMetaDataRetrieval(add);
        MutableMetaDataRepositoryTest.assertEquals((Object)expected, (Object)previous);
    }

    protected void assertRemoveMetaDataRetrieval(MutableMetaDataRepository repository, ScopeKey key, MetaDataRetrieval expected) throws Exception {
        MetaDataRetrieval previous = repository.removeMetaDataRetrieval(key);
        MutableMetaDataRepositoryTest.assertEquals((Object)expected, (Object)previous);
    }
}

