/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.scope.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.CommonLevelsUtil;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;

public class CommonLevelsUnitTestCase
extends AbstractMetaDataTest {
    private ScopeLevel[] commonLevels = new ScopeLevel[]{CommonLevels.DOMAIN, CommonLevels.CLUSTER, CommonLevels.MACHINE, CommonLevels.NODE, CommonLevels.JVM, CommonLevels.SERVER, CommonLevels.SUBSYSTEM, CommonLevels.APPLICATION, CommonLevels.DEPLOYMENT, CommonLevels.CLASS, CommonLevels.INSTANCE, CommonLevels.JOINPOINT, CommonLevels.JOINPOINT_OVERRIDE, CommonLevels.THREAD, CommonLevels.WORK, CommonLevels.REQUEST};

    public CommonLevelsUnitTestCase(String name) {
        super(name);
    }

    public void testCommonLevels() throws Exception {
        int lastLevel = 0;
        String lastName = "";
        for (ScopeLevel level : this.commonLevels) {
            CommonLevelsUnitTestCase.assertTrue((level.getLevel() - lastLevel == 100 ? 1 : 0) != 0);
            CommonLevelsUnitTestCase.assertFalse((boolean)lastName.equals(level.getName()));
            lastLevel = level.getLevel();
            lastName = level.getName();
        }
        TreeSet<ScopeLevel> set = new TreeSet<ScopeLevel>();
        for (ScopeLevel level : this.commonLevels) {
            set.add(level);
        }
        CommonLevelsUnitTestCase.assertTrue((this.commonLevels.length == set.size() ? 1 : 0) != 0);
        int index = 0;
        for (ScopeLevel level : set) {
            CommonLevelsUnitTestCase.assertTrue((this.commonLevels[index++] == level ? 1 : 0) != 0);
        }
    }

    public void testLevelsUtils() throws Exception {
        List<ScopeLevel> levels = Arrays.asList(this.commonLevels);
        CommonLevelsUnitTestCase.assertEquals(levels, (Object)CommonLevelsUtil.getSubLevels((ScopeLevel)CommonLevels.DOMAIN));
        this.assertEmpty(CommonLevelsUtil.getExclusiveSubLevels((ScopeLevel)CommonLevels.REQUEST));
        CommonLevelsUnitTestCase.assertEquals((Object)CommonLevelsUtil.getExclusiveSubLevels((ScopeLevel)CommonLevels.WORK), Collections.singletonList(CommonLevels.REQUEST));
        List<ScopeLevel> instanceLevels = Arrays.asList(CommonLevels.INSTANCE, CommonLevels.JOINPOINT, CommonLevels.JOINPOINT_OVERRIDE, CommonLevels.THREAD, CommonLevels.WORK, CommonLevels.REQUEST);
        CommonLevelsUnitTestCase.assertEquals(instanceLevels, (Object)CommonLevelsUtil.getSubLevels((ScopeLevel)CommonLevels.INSTANCE));
        List<ScopeLevel> subInstanceLevels = Arrays.asList(CommonLevels.JOINPOINT, CommonLevels.JOINPOINT_OVERRIDE, CommonLevels.THREAD, CommonLevels.WORK, CommonLevels.REQUEST);
        CommonLevelsUnitTestCase.assertEquals(subInstanceLevels, (Object)CommonLevelsUtil.getExclusiveSubLevels((ScopeLevel)CommonLevels.INSTANCE));
        try {
            CommonLevelsUtil.getSubLevels((ScopeLevel)new ScopeLevel(7, "foobar"));
            CommonLevelsUnitTestCase.fail((String)"Should not be here");
        }
        catch (Exception e) {
            this.assertInstanceOf(e, IllegalArgumentException.class);
        }
        try {
            CommonLevelsUtil.getExclusiveSubLevels((ScopeLevel)new ScopeLevel(7, "foobar"));
            CommonLevelsUnitTestCase.fail((String)"Should not be here");
        }
        catch (Exception e) {
            this.assertInstanceOf(e, IllegalArgumentException.class);
        }
    }
}

