/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.shared;

import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.ExpectedAnnotations;
import org.jboss.test.metadata.shared.support.NotPresentAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation1;
import org.jboss.test.metadata.shared.support.TestAnnotation2;

public abstract class ComponentBasicAnnotationsTest
extends AbstractMetaDataTest {
    protected boolean local;

    public ComponentBasicAnnotationsTest(String name, boolean local) {
        super(name);
        this.local = local;
    }

    protected abstract MetaData setupConstructor();

    protected abstract MetaData setupField();

    protected abstract MetaData setupMethod();

    protected abstract MetaData setupMethodParams();

    protected abstract MetaData setupConstructorParams();

    public void testFieldEmpty() throws Exception {
        MetaData metaData = this.setupField();
        metaData = metaData.getComponentMetaData((Signature)new FieldSignature("empty"));
        this.testEmpty(metaData);
    }

    public void testConstructorEmpty() throws Exception {
        MetaData metaData = this.setupConstructor();
        metaData = metaData.getComponentMetaData((Signature)new ConstructorSignature(new Class[0]));
        this.testEmpty(metaData);
    }

    public void testMethodEmpty() throws Exception {
        MetaData metaData = this.setupMethod();
        metaData = metaData.getComponentMetaData((Signature)new MethodSignature("empty", new Class[0]));
        this.testEmpty(metaData);
    }

    public void testMethodParamsEmpty() throws Exception {
        MetaData metaData = this.setupMethodParams();
        metaData = metaData.getComponentMetaData((Signature)new MethodParametersSignature("empty", 0, new Class[]{String.class}));
        this.testEmpty(metaData);
    }

    public void testConstructorParamsEmpty() throws Exception {
        MetaData metaData = this.setupConstructorParams();
        metaData = metaData.getComponentMetaData((Signature)new ConstructorParametersSignature(0, new Class[]{String.class}));
        this.testEmpty(metaData);
    }

    protected void testEmpty(MetaData metaData) throws Exception {
        ComponentBasicAnnotationsTest.assertNotNull((Object)metaData);
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations(metaData, expectedAnnotations, this.local);
    }

    public void testFieldTestAnnotation() throws Exception {
        MetaData metaData = this.setupField();
        metaData = metaData.getComponentMetaData((Signature)new FieldSignature("testAnnotation"));
        this.testTestAnnotation(metaData);
    }

    public void testConstructorTestAnnotation() throws Exception {
        MetaData metaData = this.setupConstructor();
        metaData = metaData.getComponentMetaData((Signature)new ConstructorSignature(new Class[]{String.class}));
        this.testTestAnnotation(metaData);
    }

    public void testMethodTestAnnotation() throws Exception {
        MetaData metaData = this.setupMethod();
        metaData = metaData.getComponentMetaData((Signature)new MethodSignature("testAnnotation", new Class[]{String.class}));
        this.testTestAnnotation(metaData);
    }

    public void testMethodParamsTestAnnotation() throws Exception {
        MetaData metaData = this.setupMethodParams();
        metaData = metaData.getComponentMetaData((Signature)new MethodParametersSignature("testAnnotation", 0, new Class[]{String.class}));
        this.testTestAnnotation(metaData);
    }

    public void testConstructorParamsTestAnnotation() throws Exception {
        MetaData metaData = this.setupConstructorParams();
        metaData = metaData.getComponentMetaData((Signature)new ConstructorParametersSignature(0, new Class[]{Integer.class}));
        this.testTestAnnotation(metaData);
    }

    protected void testTestAnnotation(MetaData metaData) throws Exception {
        ComponentBasicAnnotationsTest.assertNotNull((Object)metaData);
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        expectedAnnotations.add(TestAnnotation.class);
        this.assertAllAnnotations(metaData, expectedAnnotations, this.local);
    }

    public void testFieldTestAnnotation12() throws Exception {
        MetaData metaData = this.setupField();
        metaData = metaData.getComponentMetaData((Signature)new FieldSignature("testAnnotation12"));
        this.testTestAnnotation12(metaData);
    }

    public void testConstructorTestAnnotation12() throws Exception {
        MetaData metaData = this.setupConstructor();
        metaData = metaData.getComponentMetaData((Signature)new ConstructorSignature(new Class[]{String.class, Class.class}));
        this.testTestAnnotation12(metaData);
    }

    public void testMethodTestAnnotation12() throws Exception {
        MetaData metaData = this.setupMethod();
        metaData = metaData.getComponentMetaData((Signature)new MethodSignature("testAnnotation12", new Class[]{String.class, Class.class}));
        this.testTestAnnotation12(metaData);
    }

    public void testMethodParamTestAnnotation12() throws Exception {
        MetaData metaData = this.setupMethodParams();
        metaData = metaData.getComponentMetaData((Signature)new MethodParametersSignature("testAnnotation12", 1, new Class[]{String.class, Class.class}));
        this.testTestAnnotation12(metaData);
    }

    public void testConstructorParamTestAnnotation12() throws Exception {
        MetaData metaData = this.setupConstructorParams();
        metaData = metaData.getComponentMetaData((Signature)new ConstructorParametersSignature(1, new Class[]{String.class, Class.class}));
        this.testTestAnnotation12(metaData);
    }

    protected void testTestAnnotation12(MetaData metaData) throws Exception {
        ComponentBasicAnnotationsTest.assertNotNull((Object)metaData);
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertAnnotation(metaData, TestAnnotation1.class);
        this.assertAnnotation(metaData, TestAnnotation2.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        expectedAnnotations.add(TestAnnotation1.class);
        expectedAnnotations.add(TestAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations, this.local);
    }
}

