/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.annotation.factory.test;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.AnnotationValidationException;
import org.jboss.test.ContainerTest;
import org.jboss.test.annotation.factory.support.Complex;
import org.jboss.test.annotation.factory.support.MyEnum;
import org.jboss.test.annotation.factory.support.Simple;
import org.jboss.test.annotation.factory.support.SimpleValue;

public abstract class AnnotationCreatorTest
extends ContainerTest {
    public AnnotationCreatorTest(String name) {
        super(name);
    }

    public void testSimple() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Simple";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Simple.class);
        AnnotationCreatorTest.assertEquals(Simple.class, annotation.annotationType());
    }

    public void testSimpleValue() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.SimpleValue(\"Test\")";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, SimpleValue.class);
        AnnotationCreatorTest.assertEquals(SimpleValue.class, annotation.annotationType());
        AnnotationCreatorTest.assertEquals((String)"Test", (String)((SimpleValue)annotation).value());
    }

    public void testSimpleValueWithPropertyReplacement() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.SimpleValue(\"${value1}\")";
        System.setProperty("value1", "Test");
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, SimpleValue.class);
        AnnotationCreatorTest.assertEquals(SimpleValue.class, annotation.annotationType());
        AnnotationCreatorTest.assertEquals((String)"Test", (String)((SimpleValue)annotation).value());
    }

    public void testComplex() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Complex(ch='a', string=\"Test123\", flt=9.9, dbl=123456789.99, shrt=1, lng=987654321, integer=123, bool=true, annotation=@org.jboss.test.annotation.factory.support.SimpleValue(\"Yes\"), array={\"Test\", \"123\"}, clazz=java.lang.Long.class, enumVal=org.jboss.test.annotation.factory.support.MyEnum.TWO)";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Complex.class);
        AnnotationCreatorTest.assertEquals(Complex.class, annotation.annotationType());
        Complex complex = (Complex)annotation;
        AnnotationCreatorTest.assertEquals((char)'a', (char)complex.ch());
        AnnotationCreatorTest.assertEquals((String)"Test123", (String)complex.string());
        AnnotationCreatorTest.assertEquals((float)9.0f, (float)9.0f, (float)complex.flt());
        this.assertEquals(1.2345678999E8, complex.dbl());
        AnnotationCreatorTest.assertEquals((int)1, (int)complex.shrt());
        AnnotationCreatorTest.assertEquals((long)987654321L, (long)complex.lng());
        AnnotationCreatorTest.assertEquals((int)123, (int)complex.integer());
        AnnotationCreatorTest.assertEquals((boolean)true, (boolean)complex.bool());
        AnnotationCreatorTest.assertEquals(Long.class, complex.clazz());
        AnnotationCreatorTest.assertEquals((String)"Yes", (String)complex.annotation().value());
        this.assertEquals(new String[]{"Test", "123"}, complex.array());
        AnnotationCreatorTest.assertEquals((Object)((Object)MyEnum.TWO), (Object)((Object)complex.enumVal()));
    }

    public void testComplexWithPropertyReplacement() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Complex(ch='${ch}', string=\"${string}\", flt=${flt}, dbl=${dbl}, shrt=${shrt}, lng=${lng}, integer=${integer}, bool=${bool}, annotation=${annotation}, array=${array}, clazz=${clazz}, enumVal=${enumVal})";
        System.setProperty("ch", "a");
        System.setProperty("string", "Test123");
        System.setProperty("flt", "9.9");
        System.setProperty("dbl", "123456789.99");
        System.setProperty("shrt", "1");
        System.setProperty("lng", "987654321");
        System.setProperty("integer", "123");
        System.setProperty("bool", "true");
        System.setProperty("annotation", "@org.jboss.test.annotation.factory.support.SimpleValue(\"Yes\")");
        System.setProperty("array", "{\"Test\", \"123\"}");
        System.setProperty("clazz", "java.lang.Long.class");
        System.setProperty("enumVal", "org.jboss.test.annotation.factory.support.MyEnum.TWO");
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Complex.class);
        AnnotationCreatorTest.assertEquals(Complex.class, annotation.annotationType());
        Complex complex = (Complex)annotation;
        AnnotationCreatorTest.assertEquals((char)'a', (char)complex.ch());
        AnnotationCreatorTest.assertEquals((String)"Test123", (String)complex.string());
        AnnotationCreatorTest.assertEquals((float)9.0f, (float)9.0f, (float)complex.flt());
        this.assertEquals(1.2345678999E8, complex.dbl());
        AnnotationCreatorTest.assertEquals((int)1, (int)complex.shrt());
        AnnotationCreatorTest.assertEquals((long)987654321L, (long)complex.lng());
        AnnotationCreatorTest.assertEquals((int)123, (int)complex.integer());
        AnnotationCreatorTest.assertEquals((boolean)true, (boolean)complex.bool());
        AnnotationCreatorTest.assertEquals(Long.class, complex.clazz());
        AnnotationCreatorTest.assertEquals((String)"Yes", (String)complex.annotation().value());
        this.assertEquals(new String[]{"Test", "123"}, complex.array());
        AnnotationCreatorTest.assertEquals((Object)((Object)MyEnum.TWO), (Object)((Object)complex.enumVal()));
    }

    public void testSerializable() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Complex(ch='a', string=\"Test123\", flt=9.9, dbl=123456789.99, shrt=1, lng=987654321, integer=123, bool=true, annotation=@org.jboss.test.annotation.factory.support.SimpleValue(\"Yes\"), array={\"Test\", \"123\"}, clazz=java.lang.Long.class, enumVal=org.jboss.test.annotation.factory.support.MyEnum.TWO)";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Complex.class);
        this.assertInstanceOf(annotation, Serializable.class);
        byte[] bytes = this.serialize((Serializable)((Object)annotation));
        Object desAnn = this.deserialize(bytes);
        AnnotationCreatorTest.assertEquals((Object)annotation, (Object)desAnn);
    }

    public void testMissingAttributeAndNoDefault() throws Exception {
        try {
            String expr = "@org.jboss.test.annotation.factory.support.SimpleValue";
            AnnotationCreator.createAnnotation((String)expr, SimpleValue.class);
            AnnotationCreatorTest.fail((String)"Should have picked up on missing attribute");
        }
        catch (AnnotationValidationException annotationValidationException) {
            // empty catch block
        }
    }
}

