/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.threadlocal.test;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.jboss.metadata.plugins.loader.thread.ThreadLocalMetaDataLoader;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.metadata.AbstractMetaDataTest;

public class ThreadLocalLoaderScopeUnitTestCase
extends AbstractMetaDataTest {
    ThreadLocalMetaDataLoader loader = ThreadLocalMetaDataLoader.INSTANCE;
    CountDownLatch entryLatch;

    public ThreadLocalLoaderScopeUnitTestCase(String name) {
        super(name);
    }

    public void testThreadScope() throws Exception {
        int i;
        TestScopeRunnable[] runnables = new TestScopeRunnable[5];
        Thread[] threads = new Thread[runnables.length];
        this.entryLatch = new CountDownLatch(runnables.length);
        for (i = 0; i < 5; ++i) {
            runnables[i] = new TestScopeRunnable();
            threads[i] = new Thread((Runnable)runnables[i], "Thread" + i);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
            ThreadLocalLoaderScopeUnitTestCase.assertNull((Object)runnables[i].error);
        }
    }

    public class TestScopeRunnable
    implements Runnable {
        Throwable error;

        public void run() {
            try {
                ThreadLocalLoaderScopeUnitTestCase.this.entryLatch.countDown();
                ThreadLocalLoaderScopeUnitTestCase.this.entryLatch.await();
                ScopeKey scopeKey = ThreadLocalLoaderScopeUnitTestCase.this.loader.getScope();
                Assert.assertNotNull((Object)scopeKey);
                Collection scopes = scopeKey.getScopes();
                Assert.assertEquals((int)1, (int)scopes.size());
                Scope scope = (Scope)scopes.iterator().next();
                Assert.assertEquals((Object)CommonLevels.THREAD, (Object)scope.getScopeLevel());
                Assert.assertEquals((Object)Thread.currentThread().getName(), (Object)scope.getQualifier());
            }
            catch (Throwable t) {
                ThreadLocalLoaderScopeUnitTestCase.this.log.error((Object)"Error", t);
                this.error = t;
            }
        }
    }
}

