/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.retrieval.test;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.context.CachingMetaDataContext;
import org.jboss.metadata.plugins.loader.SimpleMetaDataLoader;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.plugins.loader.thread.ThreadLocalMetaDataLoader;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.retrieval.support.TestAnnotated;
import org.jboss.test.metadata.retrieval.support.TestAnnotation;

public class EmptyTestCase
extends AbstractMetaDataTest {
    public EmptyTestCase(String name) {
        super(name);
    }

    protected MetaDataRetrieval[] getSimpleMetaDataRetrievals() {
        MetaDataRetrieval[] retrievals = new MetaDataRetrieval[]{new AnnotatedElementMetaDataLoader(((Object)((Object)this)).getClass()), new MemoryMetaDataLoader(), new SimpleMetaDataLoader(new Annotation[0]), ThreadLocalMetaDataLoader.INSTANCE};
        return retrievals;
    }

    protected MetaDataContext[] getMetaDataContexts(MetaDataRetrieval[] retrievals, MetaDataContext emptyContext, MetaDataRetrieval emptyRetrieval) {
        boolean mix = emptyContext != null && emptyRetrieval != null;
        int size = mix ? 10 : 6;
        MetaDataContext[] contexts = new MetaDataContext[size];
        contexts[0] = new AbstractMetaDataContext(retrievals[0]);
        contexts[1] = new AbstractMetaDataContext(contexts[0], retrievals[1]);
        contexts[2] = new AbstractMetaDataContext(contexts[0], Arrays.asList(retrievals));
        contexts[3] = new CachingMetaDataContext((MetaDataRetrieval)contexts[0]);
        contexts[4] = new CachingMetaDataContext(contexts[0], retrievals[1]);
        contexts[5] = new CachingMetaDataContext(contexts[0], Arrays.asList(retrievals));
        if (mix) {
            contexts[6] = new AbstractMetaDataContext(emptyContext, retrievals[0]);
            contexts[7] = new AbstractMetaDataContext(contexts[0], emptyRetrieval);
            contexts[8] = new CachingMetaDataContext(emptyContext, retrievals[0]);
            contexts[9] = new CachingMetaDataContext(contexts[0], emptyRetrieval);
        }
        return contexts;
    }

    protected TestAnnotation getAnnotation() {
        return new TestAnnotation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return TestAnnotation.class;
            }
        };
    }

    public void testEmpty() throws Exception {
        MetaDataContext[] contexts;
        MetaDataRetrieval[] retrievals;
        for (MetaDataRetrieval rdr : retrievals = this.getSimpleMetaDataRetrievals()) {
            EmptyTestCase.assertTrue((String)rdr.toString(), (boolean)rdr.isEmpty());
        }
        for (MetaDataContext rdr : contexts = this.getMetaDataContexts(retrievals, null, null)) {
            EmptyTestCase.assertTrue((String)rdr.toString(), (boolean)rdr.isEmpty());
        }
        retrievals[0] = new AnnotatedElementMetaDataLoader(TestAnnotated.class);
        MemoryMetaDataLoader mmdl = new MemoryMetaDataLoader();
        TestAnnotation annotation = this.getAnnotation();
        mmdl.addMetaData((Object)annotation, TestAnnotation.class);
        retrievals[1] = mmdl;
        retrievals[2] = new SimpleMetaDataLoader(new Annotation[]{annotation});
        ThreadLocalMetaDataLoader tlmdl = ThreadLocalMetaDataLoader.INSTANCE;
        tlmdl.addAnnotation((Annotation)annotation);
        retrievals[3] = tlmdl;
        for (MetaDataRetrieval rdr : retrievals) {
            EmptyTestCase.assertFalse((String)rdr.toString(), (boolean)rdr.isEmpty());
        }
        mmdl.removeMetaData(TestAnnotation.class);
        EmptyTestCase.assertTrue((String)mmdl.toString(), (boolean)mmdl.isEmpty());
        tlmdl.removeAnnotation(TestAnnotation.class);
        EmptyTestCase.assertTrue((String)tlmdl.toString(), (boolean)tlmdl.isEmpty());
        MemoryMetaDataLoader emptyRetrieval = new MemoryMetaDataLoader();
        AbstractMetaDataContext emptyContext = new AbstractMetaDataContext((MetaDataRetrieval)emptyRetrieval);
        for (MetaDataContext rdr : contexts = this.getMetaDataContexts(retrievals, (MetaDataContext)emptyContext, (MetaDataRetrieval)emptyRetrieval)) {
            EmptyTestCase.assertFalse((String)rdr.toString(), (boolean)rdr.isEmpty());
        }
    }

    public void testScopedRetrieval() throws Exception {
        ScopeLevel[] commonLevels = new ScopeLevel[]{CommonLevels.DOMAIN, CommonLevels.CLUSTER, CommonLevels.MACHINE, CommonLevels.NODE, CommonLevels.JVM, CommonLevels.SERVER, CommonLevels.SUBSYSTEM, CommonLevels.APPLICATION, CommonLevels.DEPLOYMENT, CommonLevels.CLASS, CommonLevels.INSTANCE, CommonLevels.JOINPOINT, CommonLevels.JOINPOINT_OVERRIDE, CommonLevels.THREAD, CommonLevels.WORK, CommonLevels.REQUEST};
        MetaDataRetrieval[] retrievals = this.getSimpleMetaDataRetrievals();
        for (ScopeLevel level : commonLevels) {
            for (MetaDataRetrieval rdr : retrievals) {
                MetaDataRetrieval sr = rdr.getScopedRetrieval(level);
                if (sr == null) continue;
                EmptyTestCase.assertSame((Object)sr, (Object)rdr);
            }
        }
        AnnotatedElementMetaDataLoader aemdl = new AnnotatedElementMetaDataLoader(TestAnnotated.class);
        EmptyTestCase.assertNotNull((Object)aemdl.getScopedRetrieval(CommonLevels.CLASS));
        EmptyTestCase.assertNull((Object)aemdl.getScopedRetrieval(CommonLevels.INSTANCE));
        for (ScopeLevel level : commonLevels) {
            MemoryMetaDataLoader mmdl = new MemoryMetaDataLoader(new ScopeKey(level, (Object)"123"));
            for (ScopeLevel sl : commonLevels) {
                if (sl == level) continue;
                EmptyTestCase.assertNull((Object)mmdl.getScopedRetrieval(sl));
            }
        }
        AbstractMetaDataContext parent = new AbstractMetaDataContext(retrievals[0]);
        AbstractMetaDataContext context = new AbstractMetaDataContext((MetaDataContext)parent, (MetaDataRetrieval)aemdl);
        EmptyTestCase.assertSame((Object)aemdl, (Object)context.getScopedRetrieval(CommonLevels.CLASS));
        MemoryMetaDataLoader mmdl = new MemoryMetaDataLoader(new ScopeKey(CommonLevels.INSTANCE, (Object)"123"));
        context = new AbstractMetaDataContext((MetaDataContext)parent, (MetaDataRetrieval)mmdl);
        EmptyTestCase.assertSame((Object)mmdl, (Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        context = new AbstractMetaDataContext((MetaDataContext)parent, Arrays.asList(aemdl, mmdl));
        EmptyTestCase.assertNotNull((Object)context.getScopedRetrieval(CommonLevels.CLASS));
        EmptyTestCase.assertNotNull((Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        context = new CachingMetaDataContext((MetaDataContext)parent, Arrays.asList(aemdl, mmdl, aemdl, mmdl));
        EmptyTestCase.assertNotNull((Object)context.getScopedRetrieval(CommonLevels.CLASS));
        EmptyTestCase.assertNotNull((Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        MetaDataRetrieval expected1 = context.getScopedRetrieval(CommonLevels.CLASS);
        EmptyTestCase.assertSame((Object)expected1, (Object)context.getScopedRetrieval(CommonLevels.CLASS));
        MetaDataRetrieval expected2 = context.getScopedRetrieval(CommonLevels.INSTANCE);
        EmptyTestCase.assertSame((Object)expected2, (Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        context.append((MetaDataRetrieval)ThreadLocalMetaDataLoader.INSTANCE);
        context.remove((MetaDataRetrieval)ThreadLocalMetaDataLoader.INSTANCE);
        EmptyTestCase.assertNotNull((Object)context.getScopedRetrieval(CommonLevels.CLASS));
        EmptyTestCase.assertNotNull((Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        EmptyTestCase.assertNotSame((Object)expected1, (Object)context.getScopedRetrieval(CommonLevels.CLASS));
        EmptyTestCase.assertNotSame((Object)expected2, (Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        context = new AbstractMetaDataContext((MetaDataContext)parent, Arrays.asList(mmdl, mmdl));
        EmptyTestCase.assertNull((Object)context.getScopedRetrieval(CommonLevels.CLASS));
        context = new AbstractMetaDataContext((MetaDataContext)parent, Arrays.asList(aemdl, aemdl));
        EmptyTestCase.assertNull((Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        parent = new AbstractMetaDataContext((MetaDataRetrieval)new MemoryMetaDataLoader(new ScopeKey(CommonLevels.INSTANCE, (Object)"0123")));
        context = new CachingMetaDataContext((MetaDataContext)parent, Arrays.asList(mmdl, mmdl));
        EmptyTestCase.assertNull((Object)context.getScopedRetrieval(CommonLevels.CLASS));
        MetaDataRetrieval scr1 = context.getScopedRetrieval(CommonLevels.INSTANCE);
        EmptyTestCase.assertNotNull((Object)scr1);
        EmptyTestCase.assertTrue((boolean)scr1.isEmpty());
        parent = new AbstractMetaDataContext((MetaDataRetrieval)new MemoryMetaDataLoader(new ScopeKey(CommonLevels.CLASS, (Object)"0123")));
        context = new CachingMetaDataContext((MetaDataContext)parent, Arrays.asList(aemdl, aemdl));
        EmptyTestCase.assertNull((Object)context.getScopedRetrieval(CommonLevels.INSTANCE));
        MetaDataRetrieval scr2 = context.getScopedRetrieval(CommonLevels.CLASS);
        EmptyTestCase.assertNotNull((Object)scr2);
        EmptyTestCase.assertFalse((boolean)scr2.isEmpty());
    }
}

