/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader;

import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.ExpectedAnnotations;
import org.jboss.test.metadata.shared.support.NotPresentAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation1;
import org.jboss.test.metadata.shared.support.TestAnnotation1Impl;
import org.jboss.test.metadata.shared.support.TestAnnotation2;
import org.jboss.test.metadata.shared.support.TestAnnotation2Impl;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public abstract class MutableMetaDataLoaderAnnotationsInvalidationTest
extends AbstractMetaDataTest {
    public MutableMetaDataLoaderAnnotationsInvalidationTest(String name) {
        super(name);
    }

    public void testEmpty() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        this.assertValidTimeUnchanged((MetaDataRetrieval)metaData, last);
    }

    public void testTestAnnotation() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotationImpl(), expectedAnnotations, last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        this.assertRemoveAnnotation(metaData, TestAnnotation.class, expectedAnnotations, last);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
    }

    public void testTestAnnotation12() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation1.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation2.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotation1Impl(), expectedAnnotations, last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation1.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation2.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotation2Impl(), expectedAnnotations, last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation1.class);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation2.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        this.assertRemoveAnnotation(metaData, TestAnnotation1.class, expectedAnnotations, last);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation1.class);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation2.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        this.assertRemoveAnnotation(metaData, TestAnnotation2.class, expectedAnnotations, last);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation1.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation2.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
    }

    public void testAddTwice() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotationImpl(), expectedAnnotations, last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        last = this.assertAddAnnotationWithPrevious(metaData, new TestAnnotationImpl(), last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
    }

    public void testAddTwiceSameObject() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        last = this.assertAddAnnotationNoPrevious(metaData, annotation, expectedAnnotations, last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
        this.assertAddAnnotationWithPreviousSameObject(metaData, annotation, last);
        this.assertAnnotation((MetaDataRetrieval)metaData, TestAnnotation.class);
        this.assertNoAnnotation((MetaDataRetrieval)metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
    }

    public void testRemoveDoesNotExist() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNotRemovedAnnotation(metaData, TestAnnotation.class, last);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
    }

    public void testRemoveTwice() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotationImpl(), expectedAnnotations, last);
        this.assertRemoveAnnotation(metaData, TestAnnotation.class, expectedAnnotations, last);
        this.assertNotRemovedAnnotation(metaData, TestAnnotation.class, last);
        this.assertAllAnnotations((MetaDataRetrieval)metaData, expectedAnnotations);
    }

    protected abstract MutableMetaDataLoader setupEmpty();
}

