/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader;

import org.jboss.metadata.spi.MetaData;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.ExpectedMetaData;
import org.jboss.test.metadata.shared.support.MetaDataAndMutableMetaData;
import org.jboss.test.metadata.shared.support.NotPresentType;
import org.jboss.test.metadata.shared.support.TestMetaData;
import org.jboss.test.metadata.shared.support.TestMetaData1;
import org.jboss.test.metadata.shared.support.TestMetaData1Impl;
import org.jboss.test.metadata.shared.support.TestMetaData2;
import org.jboss.test.metadata.shared.support.TestMetaData2Impl;
import org.jboss.test.metadata.shared.support.TestMetaDataImpl;

public abstract class MutableMetaDataTest
extends AbstractMetaDataTest {
    public MutableMetaDataTest(String name) {
        super(name);
    }

    public void testEmpty() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertValidTimeUnchanged(metaData, last);
    }

    public void testTestMetaData() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, expected, last);
        this.assertMetaData((MetaData)metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertRemoveMetaData(metaData, TestMetaData.class, expected, last);
        this.assertNoMetaData(metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testTestMetaData12() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, TestMetaData1.class);
        this.assertNoMetaData(metaData, TestMetaData2.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData1Impl(), TestMetaData1.class, expected, last);
        this.assertMetaData((MetaData)metaData, TestMetaData1.class);
        this.assertNoMetaData(metaData, TestMetaData2.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData2Impl(), TestMetaData2.class, expected, last);
        this.assertMetaData((MetaData)metaData, TestMetaData1.class);
        this.assertMetaData((MetaData)metaData, TestMetaData2.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertRemoveMetaData(metaData, TestMetaData1.class, expected, last);
        this.assertNoMetaData(metaData, TestMetaData1.class);
        this.assertMetaData((MetaData)metaData, TestMetaData2.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertRemoveMetaData(metaData, TestMetaData2.class, expected, last);
        this.assertNoMetaData(metaData, TestMetaData1.class);
        this.assertNoMetaData(metaData, TestMetaData2.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testAddTwice() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, expected, last);
        this.assertMetaData((MetaData)metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataWithPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, last);
        this.assertMetaData((MetaData)metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testAddTwiceSameObject() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        TestMetaDataImpl object = new TestMetaDataImpl();
        last = this.assertAddMetaDataNoPrevious(metaData, object, TestMetaData.class, expected, last);
        this.assertMetaData((MetaData)metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertAddMetaDataWithPreviousSameObject(metaData, object, TestMetaData.class, last);
        this.assertMetaData((MetaData)metaData, TestMetaData.class);
        this.assertNoMetaData(metaData, NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testRemoveDoesNotExist() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNotRemovedMetaData(metaData, TestMetaData.class, last);
        this.assertAllMetaData(metaData, expected);
    }

    public void testRemoveTwice() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, expected, last);
        this.assertRemoveMetaData(metaData, TestMetaData.class, expected, last);
        this.assertNotRemovedMetaData(metaData, TestMetaData.class, last);
        this.assertAllMetaData(metaData, expected);
    }

    public void testTestMetaDataByName() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, expected, last);
        this.assertMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertRemoveMetaData(metaData, "Test", TestMetaData.class, expected, last);
        this.assertNoMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testTestMetaData12ByName() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, "Test1", TestMetaData1.class);
        this.assertNoMetaData(metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData1Impl(), "Test1", TestMetaData1.class, expected, last);
        this.assertMetaData(metaData, "Test1", TestMetaData1.class);
        this.assertNoMetaData(metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData2Impl(), "Test2", TestMetaData2.class, expected, last);
        this.assertMetaData(metaData, "Test1", TestMetaData1.class);
        this.assertMetaData(metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertRemoveMetaData(metaData, "Test1", TestMetaData1.class, expected, last);
        this.assertNoMetaData(metaData, "Test1", TestMetaData1.class);
        this.assertMetaData(metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertRemoveMetaData(metaData, "Test2", TestMetaData2.class, expected, last);
        this.assertNoMetaData(metaData, "Test1", TestMetaData1.class);
        this.assertNoMetaData(metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testAddTwiceByName() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, expected, last);
        this.assertMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        last = this.assertAddMetaDataWithPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, last);
        this.assertMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testAddTwiceSameObjectByName() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        TestMetaDataImpl object = new TestMetaDataImpl();
        last = this.assertAddMetaDataNoPrevious(metaData, object, "Test", TestMetaData.class, expected, last);
        this.assertMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
        this.assertAddMetaDataWithPreviousSameObject(metaData, object, "Test", TestMetaData.class, last);
        this.assertMetaData(metaData, "Test", TestMetaData.class);
        this.assertNoMetaData(metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData(metaData, expected);
    }

    public void testRemoveDoesNotExistByName() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNotRemovedMetaData(metaData, "Test", TestMetaData.class, last);
        this.assertAllMetaData(metaData, expected);
    }

    public void testRemoveTwiceByName() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, expected, last);
        this.assertRemoveMetaData(metaData, "Test", TestMetaData.class, expected, last);
        this.assertNotRemovedMetaData(metaData, "Test", TestMetaData.class, last);
        this.assertAllMetaData(metaData, expected);
    }

    protected abstract MetaDataAndMutableMetaData setupEmpty();
}

