/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.reflection.test;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.loader.reflection.support.TestAnnotationScopeBean;

public class AnnotatedElementLoaderScopeUnitTestCase
extends AbstractMetaDataTest {
    public AnnotatedElementLoaderScopeUnitTestCase(String name) {
        super(name);
    }

    public void testClassScope() throws Exception {
        AnnotatedElementMetaDataLoader loader = new AnnotatedElementMetaDataLoader(TestAnnotationScopeBean.class);
        ScopeKey scopeKey = loader.getScope();
        AnnotatedElementLoaderScopeUnitTestCase.assertNotNull((Object)scopeKey);
        Collection scopes = scopeKey.getScopes();
        AnnotatedElementLoaderScopeUnitTestCase.assertEquals((int)1, (int)scopes.size());
        Scope scope = (Scope)scopes.iterator().next();
        AnnotatedElementLoaderScopeUnitTestCase.assertEquals((Object)CommonLevels.CLASS, (Object)scope.getScopeLevel());
        AnnotatedElementLoaderScopeUnitTestCase.assertEquals(TestAnnotationScopeBean.class, (Object)scope.getQualifier());
    }

    public void testFieldScope() throws Exception {
        Field field = TestAnnotationScopeBean.class.getField("something");
        this.testMember(field);
    }

    public void testConstructorScope() throws Exception {
        Constructor constructor = TestAnnotationScopeBean.class.getConstructor(null);
        this.testMember(constructor);
    }

    public void testMethodScope() throws Exception {
        Method method = TestAnnotationScopeBean.class.getMethod("doSomething", null);
        this.testMember(method);
    }

    protected void testMember(Member member) throws Exception {
        AnnotatedElementLoaderScopeUnitTestCase.assertNotNull((Object)member);
        AnnotatedElementMetaDataLoader loader = new AnnotatedElementMetaDataLoader((AnnotatedElement)((Object)member));
        ScopeKey scopeKey = loader.getScope();
        AnnotatedElementLoaderScopeUnitTestCase.assertNotNull((Object)scopeKey);
        Collection scopes = scopeKey.getScopes();
        AnnotatedElementLoaderScopeUnitTestCase.assertEquals((int)1, (int)scopes.size());
        Scope scope = (Scope)scopes.iterator().next();
        AnnotatedElementLoaderScopeUnitTestCase.assertEquals((Object)CommonLevels.JOINPOINT, (Object)scope.getScopeLevel());
        AnnotatedElementLoaderScopeUnitTestCase.assertEquals((Object)member, (Object)scope.getQualifier());
    }
}

