/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.reflection.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.loader.reflection.support.MethodBean;
import org.jboss.test.metadata.loader.reflection.support.NoAnnotationBean;

public class AnnotatedElementMetadataLoaderTestCase
extends AbstractMetaDataTest {
    public AnnotatedElementMetadataLoaderTestCase(String name) {
        super(name);
    }

    public void testNoAnnotationPresent() throws Exception {
        AnnotatedElementMetaDataLoader annotatedElementLoader = new AnnotatedElementMetaDataLoader(NoAnnotationBean.class);
        MetaDataRetrievalToMetaDataBridge metadata = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)annotatedElementLoader);
        Object[] annotations = metadata.getAnnotations();
        AnnotatedElementMetadataLoaderTestCase.assertEmpty((Object[])annotations);
    }

    public void testMethodLevelAnnotationsWithDeclaredMethodSignature() throws Exception {
        AnnotatedElementMetaDataLoader annotatedElementLoader = new AnnotatedElementMetaDataLoader(MethodBean.class);
        Method methodWithOneAnnotation = MethodBean.class.getMethod("testAnnotation", String.class);
        DeclaredMethodSignature declaredMethodSignature = new DeclaredMethodSignature(methodWithOneAnnotation);
        MetaDataRetrieval retrieval = annotatedElementLoader.getComponentMetaDataRetrieval((Signature)declaredMethodSignature);
        MetaDataRetrievalToMetaDataBridge metadata = new MetaDataRetrievalToMetaDataBridge(retrieval);
        Annotation[] annotations = metadata.getAnnotations();
        AnnotatedElementMetadataLoaderTestCase.assertTrue((String)("Expected one annotation on " + methodWithOneAnnotation), (annotations.length == 1 ? 1 : 0) != 0);
        Method methodWithTwoAnnotations = MethodBean.class.getMethod("testAnnotation12", String.class, Class.class);
        DeclaredMethodSignature anotherDeclaredMethodSignature = new DeclaredMethodSignature(methodWithTwoAnnotations);
        MetaDataRetrieval anotherRetrieval = annotatedElementLoader.getComponentMetaDataRetrieval((Signature)anotherDeclaredMethodSignature);
        MetaDataRetrievalToMetaDataBridge anotherMetadata = new MetaDataRetrievalToMetaDataBridge(anotherRetrieval);
        Annotation[] annotationsOnMethodWithTwoAnnotations = anotherMetadata.getAnnotations();
        AnnotatedElementMetadataLoaderTestCase.assertTrue((String)("Expected two annotations on " + anotherDeclaredMethodSignature), (annotationsOnMethodWithTwoAnnotations.length == 2 ? 1 : 0) != 0);
    }

    public void testMethodLevelAnnotationsWithMethodSignature() throws Exception {
        AnnotatedElementMetaDataLoader annotatedElementLoader = new AnnotatedElementMetaDataLoader(MethodBean.class);
        MethodSignature methodSignature = new MethodSignature("testAnnotation", new Class[]{String.class});
        MetaDataRetrieval retrieval = annotatedElementLoader.getComponentMetaDataRetrieval((Signature)methodSignature);
        MetaDataRetrievalToMetaDataBridge metadata = new MetaDataRetrievalToMetaDataBridge(retrieval);
        Annotation[] annotations = metadata.getAnnotations();
        AnnotatedElementMetadataLoaderTestCase.assertTrue((String)("Expected one annotation on testAnnotation method of " + MethodBean.class), (annotations.length == 1 ? 1 : 0) != 0);
        MethodSignature anotherMethodSignature = new MethodSignature("testAnnotation12", new Class[]{String.class, Class.class});
        MetaDataRetrieval anotherRetrieval = annotatedElementLoader.getComponentMetaDataRetrieval((Signature)anotherMethodSignature);
        MetaDataRetrievalToMetaDataBridge anotherMetadata = new MetaDataRetrievalToMetaDataBridge(anotherRetrieval);
        Annotation[] annotationsOnMethodWithTwoAnnotations = anotherMetadata.getAnnotations();
        AnnotatedElementMetadataLoaderTestCase.assertTrue((String)("Expected two annotations on testAnnotation12 method of " + MethodBean.class), (annotationsOnMethodWithTwoAnnotations.length == 2 ? 1 : 0) != 0);
    }
}

