/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.annotation.factory.test;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.AnnotationValidationException;
import org.jboss.test.ContainerTest;
import org.jboss.test.annotation.factory.support.Complex;
import org.jboss.test.annotation.factory.support.MyEnum;
import org.jboss.test.annotation.factory.support.Name;
import org.jboss.test.annotation.factory.support.NameDefaults;
import org.jboss.test.annotation.factory.support.NameImpl;
import org.jboss.test.annotation.factory.support.Simple;
import org.jboss.test.annotation.factory.support.SimpleValue;

public abstract class AnnotationCreatorTest
extends ContainerTest {
    public AnnotationCreatorTest(String name) {
        super(name);
    }

    public void testSimple() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Simple";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Simple.class);
        AnnotationCreatorTest.assertEquals(Simple.class, annotation.annotationType());
    }

    public void testSimpleValue() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.SimpleValue(\"Test\")";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, SimpleValue.class);
        AnnotationCreatorTest.assertEquals(SimpleValue.class, annotation.annotationType());
        AnnotationCreatorTest.assertEquals((String)"Test", (String)((SimpleValue)annotation).value());
    }

    public void testSimpleValueWithPropertyReplacement() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.SimpleValue(\"${value1}\")";
        System.setProperty("value1", "Test");
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, SimpleValue.class, (boolean)true);
        AnnotationCreatorTest.assertEquals(SimpleValue.class, annotation.annotationType());
        AnnotationCreatorTest.assertEquals((String)"Test", (String)((SimpleValue)annotation).value());
    }

    public void testSimpleValueWithPropertyReplacementFromProperties() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.SimpleValue(\"${value1}\")";
        System.setProperty("value1", "Test");
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, SimpleValue.class, (Properties)System.getProperties());
        AnnotationCreatorTest.assertEquals(SimpleValue.class, annotation.annotationType());
        AnnotationCreatorTest.assertEquals((String)"Test", (String)((SimpleValue)annotation).value());
    }

    public void testComplex() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Complex(ch='a', string=\"Test123\", flt=9.9, dbl=123456789.99, shrt=1, lng=987654321, integer=123, bool=true, annotation=@org.jboss.test.annotation.factory.support.SimpleValue(\"Yes\"), array={\"Test\", \"123\"}, clazz=java.lang.Long.class, enumVal=org.jboss.test.annotation.factory.support.MyEnum.TWO, primitiveArray={1,2,3})";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Complex.class);
        AnnotationCreatorTest.assertEquals(Complex.class, annotation.annotationType());
        Complex complex = (Complex)annotation;
        AnnotationCreatorTest.assertEquals((char)'a', (char)complex.ch());
        AnnotationCreatorTest.assertEquals((String)"Test123", (String)complex.string());
        AnnotationCreatorTest.assertEquals((float)9.0f, (float)9.0f, (float)complex.flt());
        this.assertEquals(1.2345678999E8, complex.dbl());
        AnnotationCreatorTest.assertEquals((int)1, (int)complex.shrt());
        AnnotationCreatorTest.assertEquals((long)987654321L, (long)complex.lng());
        AnnotationCreatorTest.assertEquals((int)123, (int)complex.integer());
        AnnotationCreatorTest.assertEquals((boolean)true, (boolean)complex.bool());
        AnnotationCreatorTest.assertEquals(Long.class, complex.clazz());
        AnnotationCreatorTest.assertEquals((String)"Yes", (String)complex.annotation().value());
        this.assertEquals(new String[]{"Test", "123"}, complex.array());
        AnnotationCreatorTest.assertEquals((Object)((Object)MyEnum.TWO), (Object)((Object)complex.enumVal()));
        AnnotationCreatorTest.assertArrays(new int[]{1, 2, 3}, complex.primitiveArray());
    }

    public void testComplexWithPropertyReplacement() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Complex(ch='${ch}', string=\"${string}\", flt=${flt}, dbl=${dbl}, shrt=${shrt}, lng=${lng}, integer=${integer}, bool=${bool}, annotation=${annotation}, array=${array}, clazz=${clazz}, enumVal=${enumVal}, primitiveArray=${primitiveArray})";
        System.setProperty("ch", "a");
        System.setProperty("string", "Test123");
        System.setProperty("flt", "9.9");
        System.setProperty("dbl", "123456789.99");
        System.setProperty("shrt", "1");
        System.setProperty("lng", "987654321");
        System.setProperty("integer", "123");
        System.setProperty("bool", "true");
        System.setProperty("annotation", "@org.jboss.test.annotation.factory.support.SimpleValue(\"Yes\")");
        System.setProperty("array", "{\"Test\", \"123\"}");
        System.setProperty("clazz", "java.lang.Long.class");
        System.setProperty("enumVal", "org.jboss.test.annotation.factory.support.MyEnum.TWO");
        System.setProperty("primitiveArray", "{1, 2, 3}");
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Complex.class, (boolean)true);
        AnnotationCreatorTest.assertEquals(Complex.class, annotation.annotationType());
        Complex complex = (Complex)annotation;
        AnnotationCreatorTest.assertEquals((char)'a', (char)complex.ch());
        AnnotationCreatorTest.assertEquals((String)"Test123", (String)complex.string());
        AnnotationCreatorTest.assertEquals((float)9.0f, (float)9.0f, (float)complex.flt());
        this.assertEquals(1.2345678999E8, complex.dbl());
        AnnotationCreatorTest.assertEquals((int)1, (int)complex.shrt());
        AnnotationCreatorTest.assertEquals((long)987654321L, (long)complex.lng());
        AnnotationCreatorTest.assertEquals((int)123, (int)complex.integer());
        AnnotationCreatorTest.assertEquals((boolean)true, (boolean)complex.bool());
        AnnotationCreatorTest.assertEquals(Long.class, complex.clazz());
        AnnotationCreatorTest.assertEquals((String)"Yes", (String)complex.annotation().value());
        this.assertEquals(new String[]{"Test", "123"}, complex.array());
        AnnotationCreatorTest.assertEquals((Object)((Object)MyEnum.TWO), (Object)((Object)complex.enumVal()));
        AnnotationCreatorTest.assertArrays(new int[]{1, 2, 3}, complex.primitiveArray());
    }

    public void testSerializable() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.Complex(ch='a', string=\"Test123\", flt=9.9, dbl=123456789.99, shrt=1, lng=987654321, integer=123, bool=true, annotation=@org.jboss.test.annotation.factory.support.SimpleValue(\"Yes\"), array={\"Test\", \"123\"}, clazz=java.lang.Long.class, enumVal=org.jboss.test.annotation.factory.support.MyEnum.TWO, primitiveArray={1,2,3})";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, Complex.class);
        this.assertInstanceOf(annotation, Serializable.class);
        byte[] bytes = this.serialize((Serializable)((Object)annotation));
        Object desAnn = this.deserialize(bytes);
        AnnotationCreatorTest.assertEquals((Object)annotation, (Object)desAnn);
    }

    public void testMissingAttributeAndNoDefault() throws Exception {
        try {
            String expr = "@org.jboss.test.annotation.factory.support.SimpleValue";
            AnnotationCreator.createAnnotation((String)expr, SimpleValue.class);
            AnnotationCreatorTest.fail((String)"Should have picked up on missing attribute");
        }
        catch (AnnotationValidationException annotationValidationException) {
            // empty catch block
        }
    }

    public void testEquals() throws Exception {
        String expr = "@" + Name.class.getName() + "(type=\"type\",subtype=\"subtype\")";
        Name n0 = (Name)AnnotationCreator.createAnnotation((String)expr, Name.class);
        this.getLog().debug((Object)("n0: " + n0));
        Name n1 = NameDefaults.class.getAnnotation(Name.class);
        this.getLog().debug((Object)("n1: " + n1));
        AnnotationCreatorTest.assertEquals((Object)n0, (Object)n1);
        AnnotationCreatorTest.assertEquals((Object)n1, (Object)n0);
        Name defaultName = NameDefaults.defaultNameType();
        this.getLog().debug((Object)("defaultName: " + defaultName));
        AnnotationCreatorTest.assertFalse((String)(n1 + " != " + defaultName), (boolean)n1.equals(defaultName));
        AnnotationCreatorTest.assertFalse((String)(defaultName + " != " + n1), (boolean)defaultName.equals(n1));
        AnnotationCreatorTest.assertFalse((String)(n0 + " != " + defaultName), (boolean)n0.equals(defaultName));
        AnnotationCreatorTest.assertFalse((String)(defaultName + " != " + n0), (boolean)defaultName.equals(n0));
        NameImpl n2 = new NameImpl("type", "subtype");
        this.getLog().debug((Object)("n2: " + n2));
        AnnotationCreatorTest.assertEquals((Object)n0, (Object)n2);
        AnnotationCreatorTest.assertEquals((Object)n2, (Object)n0);
        AnnotationCreatorTest.assertEquals((Object)n1, (Object)n2);
        AnnotationCreatorTest.assertEquals((Object)n2, (Object)n1);
        NameImpl n3 = new NameImpl();
        AnnotationCreatorTest.assertFalse((String)(n0 + "!=" + n3), (boolean)n0.equals(n3));
        AnnotationCreatorTest.assertFalse((String)(n3 + "!=" + n0), (boolean)((Object)n3).equals(n0));
        AnnotationCreatorTest.assertFalse((String)(n1 + "!=" + n3), (boolean)n1.equals(n3));
        AnnotationCreatorTest.assertFalse((String)(n3 + "!=" + n1), (boolean)((Object)n3).equals(n1));
    }
}

