/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.annotation.factory.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Test;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.AnnotationValidationException;
import org.jboss.test.annotation.factory.support.ComplexWithDefault;
import org.jboss.test.annotation.factory.test.AnnotationCreatorTest;

public class NoJavassistAnnotationCreatorTestCase
extends AnnotationCreatorTest {
    public static Test suite() {
        return NoJavassistAnnotationCreatorTestCase.suite(NoJavassistAnnotationCreatorTestCase.class);
    }

    public NoJavassistAnnotationCreatorTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultValues() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        TestClassLoader test = new TestClassLoader();
        Thread.currentThread().setContextClassLoader(test);
        try {
            String expr = "@org.jboss.test.annotation.factory.support.ComplexWithDefault";
            Class<?> annotation = test.loadClass(ComplexWithDefault.class.getName());
            Class<?> annotationCreator = test.loadClass(AnnotationCreator.class.getName());
            Method createAnnotation = annotationCreator.getDeclaredMethod("createAnnotation", String.class, Class.class);
            createAnnotation.invoke(null, expr, annotation);
            NoJavassistAnnotationCreatorTestCase.fail((String)"Should have had a validation exception");
        }
        catch (InvocationTargetException expected) {
            Throwable cause = expected.getCause();
            NoJavassistAnnotationCreatorTestCase.assertEquals((String)AnnotationValidationException.class.getName(), (String)cause.getClass().getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestClassLoader
    extends ClassLoader {
        public TestClassLoader() {
            super(TestClassLoader.class.getClassLoader());
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            System.out.println(name);
            if (name.startsWith("javassist")) {
                throw new ClassNotFoundException("exluding javassist");
            }
            if (name.startsWith("org.jboss")) {
                String classPath = name.replace('.', '/') + ".class";
                try {
                    InputStream is = this.getResourceAsStream(classPath);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int read = is.read(bytes);
                    while (read >= 0) {
                        baos.write(bytes, 0, read);
                        read = is.read(bytes);
                    }
                    is.close();
                    baos.flush();
                    bytes = baos.toByteArray();
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.loadClass(name, resolve);
        }
    }
}

