/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.BaseTestCase;
import org.jboss.test.metadata.shared.support.ExpectedAnnotations;
import org.jboss.test.metadata.shared.support.ExpectedMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMetaDataTest
extends BaseTestCase {
    public AbstractMetaDataTest(String name) {
        super(name);
    }

    public void assertUnorderedArrayEquals(Object[] expected, Object[] actual) {
        List<Object> actualList;
        List<Object> expectedList;
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            AbstractMetaDataTest.fail((String)("Expected " + expected + " got " + actual));
        }
        if (!(expectedList = Arrays.asList(expected)).containsAll(actualList = Arrays.asList(actual)) || !actualList.containsAll(expectedList)) {
            AbstractMetaDataTest.fail((String)("Expected " + expectedList + " got " + actualList));
        }
    }

    public MutableMetaDataLoader createTestMutableMetaDataLoader() {
        return new MemoryMetaDataLoader();
    }

    public MutableMetaDataLoader createTestMutableMetaDataLoader(ScopeKey key) {
        return new MemoryMetaDataLoader(key);
    }

    protected <T extends Annotation> void assertAnnotation(MetaData metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isAnnotationPresent(type));
        this.checkAnnotation(type, metaData.getAnnotation(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
        this.checkAnnotation(type, metaData.getMetaData(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
        this.checkAnnotation(type, metaData.getMetaData(type.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        this.checkAnnotation(type, metaData.getMetaData(type.getName(), type));
    }

    protected <T extends Annotation> void assertAnnotation(MetaDataRetrieval metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        this.checkAnnotation(type, (AnnotationItem<? extends Annotation>)metaData.retrieveAnnotation(type));
        this.checkAnnotation(type, metaData.retrieveMetaData(type));
        this.checkAnnotation(type, metaData.retrieveMetaData(type.getName()));
    }

    protected <T> void assertMetaData(MetaData metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
        this.checkMetaData(type, metaData.getMetaData(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
        this.checkMetaData(type, metaData.getMetaData(type.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        this.checkMetaData(type, metaData.getMetaData(type.getName(), type));
    }

    protected <T> void assertMetaData(MetaDataRetrieval metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        this.checkMetaData(type, metaData.retrieveMetaData(type));
        this.checkMetaData(type, metaData.retrieveMetaData(type.getName()));
    }

    protected <T> void assertMetaData(MetaData metaData, String name, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name));
        this.checkMetaData(type, metaData.getMetaData(name));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name, type));
        this.checkMetaData(type, metaData.getMetaData(name, type));
    }

    protected <T> void assertMetaData(MetaDataRetrieval metaData, String name, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertNotNull(type);
        this.checkMetaData(type, metaData.retrieveMetaData(name));
    }

    protected <T extends Annotation> void assertNoAnnotation(MetaData metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isAnnotationPresent(type));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
    }

    protected <T extends Annotation> void assertNoAnnotation(MetaDataRetrieval metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNull((Object)metaData.retrieveAnnotation(type));
        AbstractMetaDataTest.assertNull((Object)metaData.retrieveMetaData(type));
        AbstractMetaDataTest.assertNull((Object)metaData.retrieveMetaData(type.getName()));
    }

    protected <T> void assertNoMetaData(MetaData metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
    }

    protected <T> void assertNoMetaData(MetaDataRetrieval metaData, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNull((Object)metaData.retrieveMetaData(type));
        AbstractMetaDataTest.assertNull((Object)metaData.retrieveMetaData(type.getName()));
    }

    protected <T> void assertNoMetaData(MetaData metaData, String name, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
    }

    protected <T> void assertNoMetaData(MetaDataRetrieval metaData, String name, Class<T> type) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNull((Object)metaData.retrieveMetaData(name));
    }

    protected void checkAnnotation(Class<?> expected, Object result) throws Exception {
        AbstractMetaDataTest.assertNotNull((String)"Annotation should not be null", (Object)result);
        AbstractMetaDataTest.assertTrue((String)(result.getClass().getName() + " should be an instance of " + expected.getName()), (boolean)expected.isInstance(result));
    }

    protected void checkAnnotation(Class<?> expected, AnnotationItem<? extends Annotation> result) throws Exception {
        AbstractMetaDataTest.assertNotNull((String)"AnnotationItem should not be null", result);
        AbstractMetaDataTest.assertTrue((boolean)result.isValid());
        Annotation annotation = result.getAnnotation();
        this.checkAnnotation(expected, annotation);
    }

    protected void checkAnnotation(Class<?> expected, MetaDataItem<?> result) throws Exception {
        AbstractMetaDataTest.assertNotNull((String)"MetaDataItem should not be null", result);
        AbstractMetaDataTest.assertTrue((boolean)result.isValid());
        Object object = result.getValue();
        this.checkAnnotation(expected, object);
    }

    protected void checkMetaData(Class<?> expected, Object result) throws Exception {
        AbstractMetaDataTest.assertNotNull((String)"MetaData should not be null", (Object)result);
        AbstractMetaDataTest.assertTrue((String)(result.getClass().getName() + " should be an instance of " + expected.getName()), (boolean)expected.isInstance(result));
    }

    protected void checkMetaData(Class<?> expected, MetaDataItem<?> result) throws Exception {
        AbstractMetaDataTest.assertNotNull((String)"MetaDataItem should not be null", result);
        AbstractMetaDataTest.assertTrue((boolean)result.isValid());
        Object object = result.getValue();
        this.checkMetaData(expected, object);
    }

    protected <T extends Annotation> long assertAddAnnotationNoPrevious(MutableMetaData mutable, T annotation, ExpectedAnnotations expectedAnnotations, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        return this.assertAddAnnotationNoPrevious(metaData, mutable, annotation, expectedAnnotations, last);
    }

    protected <T extends Annotation> long assertAddAnnotationNoPrevious(MetaData metaData, MutableMetaData mutable, T annotation, ExpectedAnnotations expectedAnnotations, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(annotation);
        Class<? extends Annotation> expected = annotation.annotationType();
        expectedAnnotations.add(expected);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        Annotation result = mutable.addAnnotation(annotation);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        return this.assertValidTimeChanged(metaData, last);
    }

    protected <T extends Annotation> long assertAddAnnotationNoPrevious(MutableMetaDataLoader mutable, T annotation, ExpectedAnnotations expectedAnnotations, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(annotation);
        Class<? extends Annotation> expected = annotation.annotationType();
        expectedAnnotations.add(expected);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveAnnotation(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected.getName()));
        Annotation result = mutable.addAnnotation(annotation);
        AbstractMetaDataTest.assertNull((Object)result);
        this.checkAnnotation(expected, (AnnotationItem<? extends Annotation>)mutable.retrieveAnnotation(expected));
        this.checkAnnotation(expected, mutable.retrieveMetaData(expected));
        this.checkAnnotation(expected, mutable.retrieveMetaData(expected.getName()));
        return this.assertValidTimeChanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> long assertAddMetaDataNoPrevious(MutableMetaData mutable, T object, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        return this.assertAddMetaDataNoPrevious(metaData, mutable, object, type, expected, last);
    }

    protected <T> long assertAddMetaDataNoPrevious(MetaData metaData, MutableMetaData mutable, T object, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        expected.add(type);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
        Object result = mutable.addMetaData(object, type);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        return this.assertValidTimeChanged(metaData, last);
    }

    protected <T> long assertAddMetaDataNoPrevious(MutableMetaDataLoader mutable, T object, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        expected.add(type);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type.getName()));
        Object result = mutable.addMetaData(object, type);
        AbstractMetaDataTest.assertNull((Object)result);
        this.checkMetaData(type, mutable.retrieveMetaData(type));
        this.checkMetaData(type, mutable.retrieveMetaData(type.getName()));
        return this.assertValidTimeChanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> long assertAddMetaDataNoPrevious(MutableMetaData mutable, T object, String name, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        return this.assertAddMetaDataNoPrevious(metaData, mutable, object, name, type, expected, last);
    }

    protected <T> long assertAddMetaDataNoPrevious(MetaData metaData, MutableMetaData mutable, T object, String name, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull((Object)name);
        expected.add(type);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name, type));
        Object result = mutable.addMetaData(name, object, type);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name, type));
        return this.assertValidTimeChanged(metaData, last);
    }

    protected <T> long assertAddMetaDataNoPrevious(MutableMetaDataLoader mutable, T object, String name, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull((Object)name);
        expected.add(type);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(name));
        Object result = mutable.addMetaData(name, object, type);
        AbstractMetaDataTest.assertNull((Object)result);
        this.checkMetaData(type, mutable.retrieveMetaData(name));
        return this.assertValidTimeChanged((MetaDataRetrieval)mutable, last);
    }

    protected <T extends Annotation> long assertAddAnnotationWithPrevious(MutableMetaData mutable, T annotation, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        return this.assertAddAnnotationWithPrevious(metaData, mutable, annotation, last);
    }

    protected <T extends Annotation> long assertAddAnnotationWithPrevious(MetaData metaData, MutableMetaData mutable, T annotation, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(annotation);
        Class<? extends Annotation> expected = annotation.annotationType();
        AbstractMetaDataTest.assertTrue((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        Annotation result = mutable.addAnnotation(annotation);
        if (metaData == mutable) {
            this.checkAnnotation(expected, result);
        }
        AbstractMetaDataTest.assertTrue((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        return this.assertValidTimeChanged(metaData, last);
    }

    protected <T extends Annotation> long assertAddAnnotationWithPrevious(MutableMetaDataLoader mutable, T annotation, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(annotation);
        Class<? extends Annotation> expected = annotation.annotationType();
        AnnotationItem annotationItem = mutable.retrieveAnnotation(expected);
        this.checkAnnotation(expected, (AnnotationItem<? extends Annotation>)annotationItem);
        MetaDataItem metaDataItem1 = mutable.retrieveMetaData(expected);
        this.checkAnnotation(expected, metaDataItem1);
        MetaDataItem metaDataItem2 = mutable.retrieveMetaData(expected.getName());
        this.checkAnnotation(expected, metaDataItem2);
        Annotation result = mutable.addAnnotation(annotation);
        this.checkAnnotation(expected, result);
        this.checkAnnotation(expected, (AnnotationItem<? extends Annotation>)mutable.retrieveAnnotation(expected));
        this.checkAnnotation(expected, mutable.retrieveMetaData(expected));
        this.checkAnnotation(expected, mutable.retrieveMetaData(expected.getName()));
        AbstractMetaDataTest.assertFalse((boolean)annotationItem.isValid());
        AbstractMetaDataTest.assertFalse((boolean)metaDataItem1.isValid());
        AbstractMetaDataTest.assertFalse((boolean)metaDataItem2.isValid());
        return this.assertValidTimeChanged((MetaDataRetrieval)mutable, last);
    }

    protected <T extends Annotation> void assertAddAnnotationWithPreviousSameObject(MutableMetaData mutable, T annotation, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(annotation);
        Class<? extends Annotation> expected = annotation.annotationType();
        MetaData metaData = (MetaData)mutable;
        this.checkAnnotation(expected, metaData.getAnnotation(expected));
        this.checkAnnotation(expected, metaData.getMetaData(expected));
        this.checkAnnotation(expected, metaData.getMetaData(expected.getName(), expected));
        this.checkAnnotation(expected, metaData.getMetaData(expected.getName()));
        Annotation result = mutable.addAnnotation(annotation);
        this.checkAnnotation(expected, result);
        this.checkAnnotation(expected, metaData.getAnnotation(expected));
        this.checkAnnotation(expected, metaData.getMetaData(expected));
        this.checkAnnotation(expected, metaData.getMetaData(expected.getName(), expected));
        this.checkAnnotation(expected, metaData.getMetaData(expected.getName()));
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T extends Annotation> void assertAddAnnotationWithPreviousSameObject(MutableMetaDataLoader mutable, T annotation, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(annotation);
        Class<? extends Annotation> expected = annotation.annotationType();
        AnnotationItem annotationItem = mutable.retrieveAnnotation(expected);
        this.checkAnnotation(expected, (AnnotationItem<? extends Annotation>)annotationItem);
        MetaDataItem metaDataItem1 = mutable.retrieveMetaData(expected);
        this.checkAnnotation(expected, metaDataItem1);
        MetaDataItem metaDataItem2 = mutable.retrieveMetaData(expected.getName());
        this.checkAnnotation(expected, metaDataItem2);
        Annotation result = mutable.addAnnotation(annotation);
        this.checkAnnotation(expected, result);
        this.checkAnnotation(expected, (AnnotationItem<? extends Annotation>)mutable.retrieveAnnotation(expected));
        this.checkAnnotation(expected, mutable.retrieveMetaData(expected));
        this.checkAnnotation(expected, mutable.retrieveMetaData(expected.getName()));
        AbstractMetaDataTest.assertTrue((boolean)annotationItem.isValid());
        AbstractMetaDataTest.assertTrue((boolean)metaDataItem1.isValid());
        AbstractMetaDataTest.assertTrue((boolean)metaDataItem2.isValid());
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> long assertAddMetaDataWithPrevious(MutableMetaData mutable, T object, Class<T> type, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        return this.assertAddMetaDataWithPrevious(metaData, mutable, object, type, last);
    }

    protected <T> long assertAddMetaDataWithPrevious(MetaData metaData, MutableMetaData mutable, T object, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        Object result = mutable.addMetaData(object, type);
        if (metaData == mutable) {
            this.checkMetaData(type, result);
        }
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        return this.assertValidTimeChanged(metaData, last);
    }

    protected <T> long assertAddMetaDataWithPrevious(MutableMetaDataLoader mutable, T object, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        this.checkMetaData(type, mutable.retrieveMetaData(type));
        this.checkMetaData(type, mutable.retrieveMetaData(type.getName()));
        Object result = mutable.addMetaData(object, type);
        this.checkMetaData(type, result);
        this.checkMetaData(type, mutable.retrieveMetaData(type));
        this.checkMetaData(type, mutable.retrieveMetaData(type.getName()));
        return this.assertValidTimeChanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> long assertAddMetaDataWithPrevious(MutableMetaData mutable, T object, String name, Class<T> type, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        return this.assertAddMetaDataWithPrevious(metaData, mutable, object, name, type, last);
    }

    protected <T> long assertAddMetaDataWithPrevious(MetaData metaData, MutableMetaData mutable, T object, String name, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name, type));
        Object result = mutable.addMetaData(name, object, type);
        if (metaData == mutable) {
            this.checkMetaData(type, result);
        }
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name, type));
        return this.assertValidTimeChanged(metaData, last);
    }

    protected <T> long assertAddMetaDataWithPrevious(MutableMetaDataLoader mutable, T object, String name, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        this.checkMetaData(type, mutable.retrieveMetaData(name));
        Object result = mutable.addMetaData(name, object, type);
        this.checkMetaData(type, result);
        this.checkMetaData(type, mutable.retrieveMetaData(name));
        return this.assertValidTimeChanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> void assertAddMetaDataWithPreviousSameObject(MutableMetaData mutable, T object, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        MetaData metaData = (MetaData)mutable;
        this.checkMetaData(type, metaData.getMetaData(type));
        this.checkMetaData(type, metaData.getMetaData(type.getName(), type));
        this.checkMetaData(type, metaData.getMetaData(type.getName()));
        Object result = mutable.addMetaData(object, type);
        this.checkMetaData(type, result);
        this.checkMetaData(type, metaData.getMetaData(type));
        this.checkMetaData(type, metaData.getMetaData(type.getName(), type));
        this.checkMetaData(type, metaData.getMetaData(type.getName()));
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T> void assertAddMetaDataWithPreviousSameObject(MutableMetaDataLoader mutable, T object, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        this.checkMetaData(type, mutable.retrieveMetaData(type));
        this.checkMetaData(type, mutable.retrieveMetaData(type.getName()));
        Object result = mutable.addMetaData(object, type);
        this.checkMetaData(type, result);
        this.checkMetaData(type, mutable.retrieveMetaData(type));
        this.checkMetaData(type, mutable.retrieveMetaData(type.getName()));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> void assertAddMetaDataWithPreviousSameObject(MutableMetaData mutable, T object, String name, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        MetaData metaData = (MetaData)mutable;
        this.checkMetaData(type, metaData.getMetaData(name, type));
        this.checkMetaData(type, metaData.getMetaData(name));
        Object result = mutable.addMetaData(name, object, type);
        this.checkMetaData(type, result);
        this.checkMetaData(type, metaData.getMetaData(name, type));
        this.checkMetaData(type, metaData.getMetaData(name));
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T> void assertAddMetaDataWithPreviousSameObject(MutableMetaDataLoader mutable, T object, String name, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(object);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        this.checkMetaData(type, mutable.retrieveMetaData(name));
        Object result = mutable.addMetaData(name, object, type);
        this.checkMetaData(type, result);
        this.checkMetaData(type, mutable.retrieveMetaData(name));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T extends Annotation> void assertRemoveAnnotation(MutableMetaData mutable, Class<T> expected, ExpectedAnnotations expectedAnnotations, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        this.assertRemoveAnnotation(metaData, mutable, expected, expectedAnnotations, last, false);
    }

    protected <T extends Annotation> void assertRemoveAnnotation(MetaData metaData, MutableMetaData mutable, Class<T> expected, ExpectedAnnotations expectedAnnotations, long last, boolean stillExpected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(expected);
        if (!stillExpected) {
            expectedAnnotations.remove(expected);
        }
        AbstractMetaDataTest.assertTrue((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        Annotation result = mutable.removeAnnotation(expected);
        this.checkAnnotation(expected, result);
        if (stillExpected) {
            AbstractMetaDataTest.assertTrue((boolean)metaData.isAnnotationPresent(expected));
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected));
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName()));
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        } else {
            AbstractMetaDataTest.assertFalse((boolean)metaData.isAnnotationPresent(expected));
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected));
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName()));
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        }
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T extends Annotation> void assertRemoveAnnotation(MutableMetaDataLoader mutable, Class<T> expected, ExpectedAnnotations expectedAnnotations, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(expected);
        expectedAnnotations.remove(expected);
        AnnotationItem annotationItem = mutable.retrieveAnnotation(expected);
        this.checkAnnotation(expected, (AnnotationItem<? extends Annotation>)annotationItem);
        MetaDataItem metaDataItem1 = mutable.retrieveMetaData(expected);
        this.checkAnnotation(expected, metaDataItem1);
        MetaDataItem metaDataItem2 = mutable.retrieveMetaData(expected.getName());
        this.checkAnnotation(expected, metaDataItem2);
        Annotation result = mutable.removeAnnotation(expected);
        this.checkAnnotation(expected, result);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveAnnotation(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected.getName()));
        AbstractMetaDataTest.assertFalse((boolean)annotationItem.isValid());
        AbstractMetaDataTest.assertFalse((boolean)metaDataItem1.isValid());
        AbstractMetaDataTest.assertFalse((boolean)metaDataItem2.isValid());
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> void assertRemoveMetaData(MutableMetaData mutable, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        this.assertRemoveMetaData(metaData, mutable, type, expected, last, false);
    }

    protected <T> void assertRemoveMetaData(MetaData metaData, MutableMetaData mutable, Class<T> type, ExpectedMetaData expected, long last, boolean stillExpected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        if (!stillExpected) {
            expected.remove(type);
        }
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        Object result = mutable.removeMetaData(type);
        this.checkMetaData(type, result);
        if (stillExpected) {
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type));
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName()));
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(type.getName(), type));
        } else {
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type));
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
        }
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T> void assertRemoveMetaData(MutableMetaDataLoader mutable, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        expected.remove(type);
        this.checkMetaData(type, mutable.retrieveMetaData(type));
        this.checkMetaData(type, mutable.retrieveMetaData(type.getName()));
        Object result = mutable.removeMetaData(type);
        this.checkMetaData(type, result);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type.getName()));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> void assertRemoveMetaData(MutableMetaData mutable, String name, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        MetaData metaData = (MetaData)mutable;
        this.assertRemoveMetaData(metaData, mutable, name, type, expected, last, false);
    }

    protected <T> void assertRemoveMetaData(MetaData metaData, MutableMetaData mutable, String name, Class<T> type, ExpectedMetaData expected, long last, boolean stillExpected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        if (!stillExpected) {
            expected.remove(type);
        }
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name, type));
        Object result = mutable.removeMetaData(name, type);
        this.checkMetaData(type, result);
        if (stillExpected) {
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name));
            AbstractMetaDataTest.assertTrue((boolean)metaData.isMetaDataPresent(name, type));
        } else {
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name));
            AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name, type));
        }
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T> void assertRemoveMetaData(MutableMetaDataLoader mutable, String name, Class<T> type, ExpectedMetaData expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        expected.remove(type);
        this.checkMetaData(type, mutable.retrieveMetaData(name));
        Object result = mutable.removeMetaData(name, type);
        this.checkMetaData(type, result);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(name));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T extends Annotation> void assertNotRemovedAnnotation(MutableMetaData mutable, Class<T> expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(expected);
        MetaData metaData = (MetaData)mutable;
        AbstractMetaDataTest.assertFalse((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        Annotation result = mutable.removeAnnotation(expected);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isAnnotationPresent(expected));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(expected.getName(), expected));
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T extends Annotation> void assertNotRemovedAnnotation(MutableMetaDataLoader mutable, Class<T> expected, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(expected);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveAnnotation(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected.getName()));
        Annotation result = mutable.removeAnnotation(expected);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveAnnotation(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(expected.getName()));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> void assertNotRemovedMetaData(MutableMetaData mutable, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        MetaData metaData = (MetaData)mutable;
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
        Object result = mutable.removeMetaData(type);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName()));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(type.getName(), type));
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T> void assertNotRemovedMetaData(MutableMetaDataLoader mutable, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type.getName()));
        Object result = mutable.removeMetaData(type);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type));
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(type.getName()));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected <T> void assertNotRemovedMetaData(MutableMetaData mutable, String name, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        MetaData metaData = (MetaData)mutable;
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name, type));
        Object result = mutable.removeMetaData(name, type);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name));
        AbstractMetaDataTest.assertFalse((boolean)metaData.isMetaDataPresent(name, type));
        this.assertValidTimeUnchanged(metaData, last);
    }

    protected <T> void assertNotRemovedMetaData(MutableMetaDataLoader mutable, String name, Class<T> type, long last) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)mutable);
        AbstractMetaDataTest.assertNotNull(type);
        AbstractMetaDataTest.assertNotNull((Object)name);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(name));
        Object result = mutable.removeMetaData(name, type);
        AbstractMetaDataTest.assertNull((Object)result);
        AbstractMetaDataTest.assertNull((Object)mutable.retrieveMetaData(name));
        this.assertValidTimeUnchanged((MetaDataRetrieval)mutable, last);
    }

    protected long assertValidTimeChanged(MetaData metaData, long last) {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        long now = metaData.getValidTime();
        AbstractMetaDataTest.assertTrue((String)("ValidTime should change now=" + now + " last=" + last), (now > last ? 1 : 0) != 0);
        return now;
    }

    protected long assertValidTimeChanged(MetaDataRetrieval metaData, long last) {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        long now = metaData.getValidTime().getValidTime();
        AbstractMetaDataTest.assertTrue((String)("ValidTime should change now=" + now + " last=" + last), (now > last ? 1 : 0) != 0);
        return now;
    }

    protected void assertValidTimeUnchanged(MetaData metaData, long last) {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        long now = metaData.getValidTime();
        AbstractMetaDataTest.assertEquals((String)("ValidTime should not change now=" + now + " last=" + last), (long)now, (long)last);
    }

    protected void assertValidTimeUnchanged(MetaDataRetrieval metaData, long last) {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        long now = metaData.getValidTime().getValidTime();
        AbstractMetaDataTest.assertEquals((String)("ValidTime should not change now=" + now + " last=" + last), (long)now, (long)last);
    }

    protected ExpectedAnnotations emptyExpectedAnnotations() {
        return new ExpectedAnnotations();
    }

    protected ExpectedMetaData emptyExpectedMetaData() {
        return new ExpectedMetaData();
    }

    protected ExpectedAnnotations expectedAnnotations(Class<? extends Annotation> ... types) {
        ExpectedAnnotations expected = new ExpectedAnnotations();
        for (Class<? extends Annotation> type : types) {
            expected.add(type);
        }
        return expected;
    }

    protected void assertAllAnnotations(MetaData metaData, ExpectedAnnotations expected) throws Exception {
        this.assertAllAnnotations(metaData, expected, true);
    }

    protected void assertAllAnnotations(MetaData metaData, ExpectedAnnotations expected, boolean local) throws Exception {
        this.assertAnnotations(metaData, expected);
        if (local) {
            this.assertLocalAnnotations(metaData, expected);
        }
        this.assertAnnotationMetaDatas(metaData, expected);
        if (local) {
            this.assertLocalAnnotationMetaDatas(metaData, expected);
        }
    }

    protected Annotation[] assertAnnotationsAnnotatedWith(MetaData metaData, Class<? extends Annotation> metaAnnotation, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Annotation[] result = metaData.getAnnotationsAnnotatedWith(metaAnnotation);
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (Annotation annotation : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(result)), (Object)annotation);
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("Annotations", expected, actual);
        return result;
    }

    protected void assertAnnotationsAnnotatedWith(MetaDataRetrieval metaData, Class<? extends Annotation> metaAnnotation, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AnnotationsItem result = metaData.retrieveAnnotationsAnnotatedWith(metaAnnotation);
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        AnnotationItem[] items = result.getAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (AnnotationItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation item " + Arrays.asList(items)), (Object)item);
            Annotation annotation = item.getAnnotation();
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(items)), (Object)annotation);
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("Annotations", expected, actual);
    }

    protected void assertNoAnnotationsAnnotatedWith(MetaData metaData, Class<? extends Annotation> metaAnnotation) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        Object[] result = metaData.getAnnotationsAnnotatedWith(metaAnnotation);
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        AbstractMetaDataTest.assertEmpty((Object[])result);
    }

    protected void assertNoAnnotationsAnnotatedWith(MetaDataRetrieval metaData, Class<? extends Annotation> metaAnnotation) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AnnotationsItem result = metaData.retrieveAnnotationsAnnotatedWith(metaAnnotation);
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        Object[] items = result.getAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        AbstractMetaDataTest.assertEmpty((Object[])items);
    }

    protected void assertAnnotations(MetaData metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Annotation[] result = metaData.getAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (Annotation annotation : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(result)), (Object)annotation);
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("Annotations", expected, actual);
    }

    protected void assertLocalAnnotations(MetaData metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Annotation[] result = metaData.getLocalAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (Annotation annotation : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(result)), (Object)annotation);
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("Annotations", expected, actual);
    }

    protected void assertAllAnnotations(MetaDataRetrieval metaData, ExpectedAnnotations expected) throws Exception {
        this.assertAllAnnotations(metaData, expected, true);
    }

    protected void assertAllAnnotations(MetaDataRetrieval metaData, ExpectedAnnotations expected, boolean local) throws Exception {
        this.assertAnnotations(metaData, expected);
        if (local) {
            this.assertLocalAnnotations(metaData, expected);
        }
        this.assertAnnotationMetaDatas(metaData, expected);
        if (local) {
            this.assertLocalAnnotationMetaDatas(metaData, expected);
        }
    }

    protected void assertAnnotations(MetaDataRetrieval metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AnnotationsItem result = metaData.retrieveAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        AnnotationItem[] items = result.getAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (AnnotationItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation item " + Arrays.asList(items)), (Object)item);
            Annotation annotation = item.getAnnotation();
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(items)), (Object)annotation);
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("Annotations", expected, actual);
    }

    protected void assertLocalAnnotations(MetaDataRetrieval metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        AnnotationsItem result = metaData.retrieveLocalAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        AnnotationItem[] items = result.getAnnotations();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (AnnotationItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation item " + Arrays.asList(items)), (Object)item);
            Annotation annotation = item.getAnnotation();
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(items)), (Object)annotation);
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("Annotations", expected, actual);
    }

    protected void assertAllMetaData(MetaData metaData, ExpectedMetaData expected) throws Exception {
        this.assertAllMetaData(metaData, expected, true);
    }

    protected void assertAllMetaData(MetaData metaData, ExpectedMetaData expected, boolean local) throws Exception {
        this.assertMetaData(metaData, expected);
        if (local) {
            this.assertLocalMetaData(metaData, expected);
        }
    }

    protected void assertMetaData(MetaData metaData, ExpectedMetaData expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Object[] result = metaData.getMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedMetaData actual = this.emptyExpectedMetaData();
        for (Object object : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null object " + Arrays.asList(result)), (Object)object);
            actual.add(this.getType(object));
        }
        this.assertExpectedMetaData("MetaData", expected, actual);
    }

    protected void assertLocalMetaData(MetaData metaData, ExpectedMetaData expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Object[] result = metaData.getLocalMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedMetaData actual = this.emptyExpectedMetaData();
        for (Object object : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null object " + Arrays.asList(result)), (Object)object);
            actual.add(this.getType(object));
        }
        this.assertExpectedMetaData("MetaData", expected, actual);
    }

    protected void assertAllMetaData(MetaDataRetrieval metaData, ExpectedMetaData expected) throws Exception {
        this.assertAllMetaData(metaData, expected, true);
    }

    protected void assertAllMetaData(MetaDataRetrieval metaData, ExpectedMetaData expected, boolean local) throws Exception {
        this.assertMetaData(metaData, expected);
        if (local) {
            this.assertLocalMetaData(metaData, expected);
        }
    }

    protected void assertMetaData(MetaDataRetrieval metaData, ExpectedMetaData expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        MetaDatasItem result = metaData.retrieveMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        MetaDataItem[] items = result.getMetaDatas();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedMetaData actual = this.emptyExpectedMetaData();
        for (MetaDataItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null meta data item " + Arrays.asList(items)), (Object)item);
            Object object = item.getValue();
            AbstractMetaDataTest.assertNotNull((String)("Null object " + Arrays.asList(items)), (Object)object);
            actual.add(this.getType(object));
        }
        this.assertExpectedMetaData("MetaData", expected, actual);
    }

    protected void assertLocalMetaData(MetaDataRetrieval metaData, ExpectedMetaData expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        MetaDatasItem result = metaData.retrieveLocalMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        MetaDataItem[] items = result.getMetaDatas();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedMetaData actual = this.emptyExpectedMetaData();
        for (MetaDataItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null meta data item " + Arrays.asList(items)), (Object)item);
            Object object = item.getValue();
            AbstractMetaDataTest.assertNotNull((String)("Null object " + Arrays.asList(items)), (Object)object);
            actual.add(this.getType(object));
        }
        this.assertExpectedMetaData("MetaData", expected, actual);
    }

    protected Class<?> getType(Object object) {
        Class<?> type = object.getClass();
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces.length == 1) {
            return interfaces[0];
        }
        return type;
    }

    protected void assertAnnotationMetaDatas(MetaData metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Object[] result = metaData.getMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (Object object : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(result)), (Object)object);
            AbstractMetaDataTest.assertTrue((String)("Not an annotation " + Arrays.asList(result)), (boolean)(object instanceof Annotation));
            Annotation annotation = (Annotation)object;
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("AnnotationMetaDatas", expected, actual);
    }

    protected void assertLocalAnnotationMetaDatas(MetaData metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        Object[] result = metaData.getLocalMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (Object object : result) {
            AbstractMetaDataTest.assertNotNull((String)("Null annotation " + Arrays.asList(result)), (Object)object);
            AbstractMetaDataTest.assertTrue((String)("Not an annotation " + Arrays.asList(result)), (boolean)(object instanceof Annotation));
            Annotation annotation = (Annotation)object;
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("AnnotationMetaDatas", expected, actual);
    }

    protected void assertAnnotationMetaDatas(MetaDataRetrieval metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        MetaDatasItem result = metaData.retrieveMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        MetaDataItem[] items = result.getMetaDatas();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (MetaDataItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null item " + Arrays.asList(items)), (Object)item);
            Object object = item.getValue();
            AbstractMetaDataTest.assertNotNull((String)("Null object " + Arrays.asList(items)), (Object)object);
            AbstractMetaDataTest.assertTrue((String)("Not an annotation " + Arrays.asList(items)), (boolean)(object instanceof Annotation));
            Annotation annotation = (Annotation)object;
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("AnnotationMetaDatas", expected, actual);
    }

    protected void assertLocalAnnotationMetaDatas(MetaDataRetrieval metaData, ExpectedAnnotations expected) throws Exception {
        AbstractMetaDataTest.assertNotNull((Object)metaData);
        AbstractMetaDataTest.assertNotNull((Object)expected);
        MetaDatasItem result = metaData.retrieveLocalMetaData();
        AbstractMetaDataTest.assertNotNull((String)"Null result", (Object)result);
        MetaDataItem[] items = result.getMetaDatas();
        AbstractMetaDataTest.assertNotNull((String)"Null items", (Object)items);
        ExpectedAnnotations actual = this.emptyExpectedAnnotations();
        for (MetaDataItem item : items) {
            AbstractMetaDataTest.assertNotNull((String)("Null item " + Arrays.asList(items)), (Object)item);
            Object object = item.getValue();
            AbstractMetaDataTest.assertNotNull((String)("Null object " + Arrays.asList(items)), (Object)object);
            AbstractMetaDataTest.assertTrue((String)("Not an annotation " + Arrays.asList(items)), (boolean)(object instanceof Annotation));
            Annotation annotation = (Annotation)object;
            actual.add(annotation.annotationType());
        }
        this.assertExpectedAnnotations("AnnotationMetaDatas", expected, actual);
    }

    protected void assertExpectedAnnotations(String context, ExpectedAnnotations expected, ExpectedAnnotations actual) {
        this.assertEquals(context, expected.get(), actual.get());
    }

    protected void assertExpectedMetaData(String context, ExpectedMetaData expected, ExpectedMetaData actual) {
        this.assertEquals(context, expected.get(), actual.get());
    }

    protected <T> void assertEquals(String context, Collection<T> expected, Collection<T> actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            this.fail(context, expected, actual);
        }
        if (expected.size() != actual.size()) {
            this.fail(context, expected, actual);
        }
        if (!expected.containsAll(actual)) {
            this.fail(context, expected, actual);
        }
        if (!actual.containsAll(expected)) {
            this.fail(context, expected, actual);
        }
    }

    private void fail(String context, Collection expected, Collection actual) {
        AbstractMetaDataTest.assertTrue((String)("Unexpected " + context + " expected=" + expected + " actual=" + actual), (boolean)false);
    }
}

