/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.threadlocal.test;

import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.jboss.metadata.plugins.loader.thread.ThreadLocalMetaDataLoader;
import org.jboss.test.metadata.AbstractMetaDataTest;

public class ThreadLocalLoaderUnitTestCase
extends AbstractMetaDataTest {
    ThreadLocalMetaDataLoader loader = ThreadLocalMetaDataLoader.INSTANCE;
    CountDownLatch entryLatch;
    CountDownLatch initLatch;

    public ThreadLocalLoaderUnitTestCase(String name) {
        super(name);
    }

    public void testMetaDataConcurrent() throws Exception {
        int i;
        TestMetaDataRunnable[] runnables = new TestMetaDataRunnable[5];
        Thread[] threads = new Thread[runnables.length];
        this.entryLatch = new CountDownLatch(runnables.length);
        this.initLatch = new CountDownLatch(runnables.length);
        for (i = 0; i < 5; ++i) {
            runnables[i] = new TestMetaDataRunnable();
            threads[i] = new Thread((Runnable)runnables[i], "Thread" + i);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
            ThreadLocalLoaderUnitTestCase.assertNull((Object)runnables[i].error);
        }
    }

    public class TestMetaDataRunnable
    implements Runnable {
        Throwable error;

        public void run() {
            try {
                ThreadLocalLoaderUnitTestCase.this.entryLatch.countDown();
                ThreadLocalLoaderUnitTestCase.this.entryLatch.await();
                ThreadLocalLoaderUnitTestCase.this.loader.addMetaData((Object)Thread.currentThread(), Thread.class);
                ThreadLocalLoaderUnitTestCase.this.initLatch.countDown();
                ThreadLocalLoaderUnitTestCase.this.initLatch.await();
                Assert.assertEquals((Object)Thread.currentThread(), (Object)ThreadLocalLoaderUnitTestCase.this.loader.removeMetaData(Thread.class));
            }
            catch (Throwable t) {
                ThreadLocalLoaderUnitTestCase.this.log.error((Object)"Error", t);
                this.error = t;
            }
        }
    }
}

