/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.retrieval.test;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.retrieval.ValidTime;
import org.jboss.metadata.spi.retrieval.helper.AnnotationToMetaDataBridge;
import org.jboss.metadata.spi.retrieval.helper.AnnotationsToMetaDatasBridge;
import org.jboss.metadata.spi.retrieval.helper.MetaDataToAnnotationBridge;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleMetaDataItem;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.retrieval.support.TestMetaDataRetrieval;
import org.jboss.test.metadata.shared.support.MetaAnnotation1;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation1Impl;
import org.jboss.test.metadata.shared.support.TestAnnotation2Impl;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public class HelpersUnitTestCase
extends AbstractMetaDataTest {
    public HelpersUnitTestCase(String name) {
        super(name);
    }

    public void testValidTime() throws Exception {
        ValidTime time1 = new ValidTime();
        ValidTime time2 = new ValidTime();
        HelpersUnitTestCase.assertTrue((time2.getValidTime() >= time1.getValidTime() ? 1 : 0) != 0);
        time1.invalidate();
        HelpersUnitTestCase.assertTrue((time1.getValidTime() > time2.getValidTime() ? 1 : 0) != 0);
        time2.invalidate();
        HelpersUnitTestCase.assertTrue((time2.getValidTime() > time1.getValidTime() ? 1 : 0) != 0);
        ValidTime time3 = new ValidTime();
        HelpersUnitTestCase.assertTrue((time3.getValidTime() >= time1.getValidTime() ? 1 : 0) != 0);
        HelpersUnitTestCase.assertTrue((time3.getValidTime() >= time2.getValidTime() ? 1 : 0) != 0);
    }

    public void testMetaDataRetrievalToMetaDataBridge() throws Exception {
        TestMetaDataRetrieval test = new TestMetaDataRetrieval();
        MetaDataRetrievalToMetaDataBridge metaData = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)test);
        metaData.getAnnotation(TestAnnotation.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveAnnotation", (String)test.lastMethod);
        metaData.getAnnotations();
        HelpersUnitTestCase.assertEquals((String)"retrieveAnnotations", (String)test.lastMethod);
        metaData.getLocalAnnotations();
        HelpersUnitTestCase.assertEquals((String)"retrieveLocalAnnotations", (String)test.lastMethod);
        metaData.getMetaData();
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData", (String)test.lastMethod);
        metaData.getLocalMetaData();
        HelpersUnitTestCase.assertEquals((String)"retrieveLocalMetaData", (String)test.lastMethod);
        metaData.getMetaData(Object.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData(Class)", (String)test.lastMethod);
        metaData.getMetaData("Hello");
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData(String)", (String)test.lastMethod);
        metaData.getMetaData("Hello", Object.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData(String)", (String)test.lastMethod);
        metaData.getValidTime();
        HelpersUnitTestCase.assertEquals((String)"getValidTime", (String)test.lastMethod);
        metaData.isAnnotationPresent(TestAnnotation.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveAnnotation", (String)test.lastMethod);
        metaData.isMetaDataPresent(Object.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData(Class)", (String)test.lastMethod);
        metaData.isMetaDataPresent("Hello");
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData(String)", (String)test.lastMethod);
        metaData.isMetaDataPresent("Hello", Object.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveMetaData(String)", (String)test.lastMethod);
        metaData.getAnnotationsAnnotatedWith(MetaAnnotation1.class);
        HelpersUnitTestCase.assertEquals((String)"retrieveAnnotationsAnnotatedWith", (String)test.lastMethod);
    }

    public void testAnnotationsToMetaDatasBridge() throws Exception {
        TestAnnotation1Impl annotation1 = new TestAnnotation1Impl();
        TestAnnotation2Impl annotation2 = new TestAnnotation2Impl();
        SimpleAnnotationItem item1 = new SimpleAnnotationItem((Annotation)annotation1);
        SimpleAnnotationItem item2 = new SimpleAnnotationItem((Annotation)annotation2);
        Object[] items = new AnnotationItem[]{item1, item2};
        SimpleAnnotationsItem item = new SimpleAnnotationsItem((AnnotationItem[])items);
        AnnotationsToMetaDatasBridge bridge = new AnnotationsToMetaDatasBridge((AnnotationsItem)item);
        Object[] result = bridge.getMetaDatas();
        HelpersUnitTestCase.assertTrue((boolean)Arrays.equals(items, result));
        Object[] expected = new Object[]{annotation1, annotation2};
        Object[] objects = item.getValue();
        HelpersUnitTestCase.assertTrue((boolean)Arrays.equals(expected, objects));
        HelpersUnitTestCase.assertTrue((boolean)item.isCachable());
        HelpersUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testAnnotationToMetaDataBridge() throws Exception {
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        SimpleAnnotationItem item = new SimpleAnnotationItem((Annotation)annotation);
        AnnotationToMetaDataBridge bridge = new AnnotationToMetaDataBridge((AnnotationItem)item);
        HelpersUnitTestCase.assertEquals((Object)annotation, (Object)bridge.getValue());
        HelpersUnitTestCase.assertTrue((boolean)item.isCachable());
        HelpersUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testMetaDataToAnnotationBridge() throws Exception {
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        SimpleMetaDataItem item = new SimpleMetaDataItem(annotation.annotationType().getName(), (Object)annotation);
        MetaDataToAnnotationBridge bridge = new MetaDataToAnnotationBridge((MetaDataItem)item);
        HelpersUnitTestCase.assertEquals((Object)annotation, (Object)bridge.getAnnotation());
        HelpersUnitTestCase.assertEquals((Object)annotation, (Object)bridge.getValue());
        HelpersUnitTestCase.assertTrue((boolean)item.isCachable());
        HelpersUnitTestCase.assertTrue((boolean)item.isValid());
    }
}

