/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.scope.test;

import java.io.Serializable;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;

public class ScopeUnitTestCase
extends AbstractMetaDataTest {
    private static ScopeLevel testLevel1 = new ScopeLevel(1, "TEST");
    private static ScopeLevel testLevel2 = new ScopeLevel(2, "TEST");

    public ScopeUnitTestCase(String name) {
        super(name);
    }

    public void testBasicScope() throws Exception {
        Scope test = new Scope(testLevel1, (Object)"localhost");
        ScopeUnitTestCase.assertEquals((Object)testLevel1, (Object)test.getScopeLevel());
        ScopeUnitTestCase.assertEquals((Object)"localhost", (Object)test.getQualifier());
    }

    public void testScopeEquals() throws Exception {
        Scope test1 = new Scope(testLevel1, (Object)"localhost");
        Scope test2 = new Scope(testLevel1, (Object)"localhost");
        ScopeUnitTestCase.assertEquals((Object)test1, (Object)test2);
    }

    public void testScopeNotEquals() throws Exception {
        Scope test1 = new Scope(testLevel1, (Object)"localhost");
        Scope test2 = new Scope(testLevel1, (Object)"remotehost");
        ScopeUnitTestCase.assertFalse((boolean)test1.equals((Object)test2));
        Scope test3 = new Scope(testLevel2, (Object)"localhost");
        ScopeUnitTestCase.assertFalse((boolean)test1.equals((Object)test3));
    }

    public void testScopeSerialization() throws Exception {
        Scope test1 = new Scope(testLevel1, (Object)"localhost");
        byte[] bytes = this.serialize((Serializable)test1);
        Scope test2 = (Scope)this.deserialize(bytes);
        ScopeUnitTestCase.assertEquals((Object)testLevel1, (Object)test2.getScopeLevel());
        ScopeUnitTestCase.assertEquals((Object)"localhost", (Object)test2.getQualifier());
        ScopeUnitTestCase.assertEquals((Object)test1, (Object)test2);
    }
}

