/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.scope;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableScopeKey
extends ScopeKey
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -442157853443439820L;
    private final Scope[] theScopes;
    private final Collection<Scope> theScopesCollection;
    private final int hashcode;

    public UnmodifiableScopeKey(ScopeKey key) {
        this.theScopes = new Scope[key.getScopes().size()];
        key.getScopes().toArray(this.theScopes);
        this.hashcode = ScopeKey.computeHashCode(this.theScopes);
        this.theScopesCollection = Collections.unmodifiableCollection(Arrays.asList(this.theScopes));
    }

    public UnmodifiableScopeKey(ScopeLevel level, Object qualifier) {
        this(new Scope[]{new Scope(level, qualifier)});
    }

    public UnmodifiableScopeKey(Collection<Scope> scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException("Null scopes");
        }
        this.theScopes = new Scope[scopes.size()];
        scopes.toArray(this.theScopes);
        UnmodifiableScopeKey.sort(this.theScopes);
        this.hashcode = ScopeKey.computeHashCode(this.theScopes);
        this.theScopesCollection = Collections.unmodifiableCollection(Arrays.asList(this.theScopes));
    }

    public UnmodifiableScopeKey(Scope ... scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException("Null scopes");
        }
        this.theScopes = UnmodifiableScopeKey.setup(scopes.length, scopes);
        this.hashcode = ScopeKey.computeHashCode(this.theScopes);
        this.theScopesCollection = Collections.unmodifiableCollection(Arrays.asList(this.theScopes));
    }

    public UnmodifiableScopeKey(int max, Scope ... scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException("Null scopes");
        }
        this.theScopes = UnmodifiableScopeKey.setup(max, scopes);
        this.hashcode = ScopeKey.computeHashCode(this.theScopes);
        this.theScopesCollection = Collections.unmodifiableCollection(Arrays.asList(this.theScopes));
    }

    @Override
    public ScopeKey getOptimizedKey() {
        return this;
    }

    @Override
    public Collection<Scope> getScopes() {
        return this.theScopesCollection;
    }

    @Override
    public Scope getScope(ScopeLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Null level");
        }
        int idx = Arrays.binarySearch(this.theScopes, new Scope(level, ""));
        if (idx >= 0) {
            return this.theScopes[idx];
        }
        return null;
    }

    @Override
    public ScopeLevel getMaxScopeLevel() {
        if (this.theScopes.length > 0) {
            return this.theScopes[this.theScopes.length - 1].getScopeLevel();
        }
        return null;
    }

    @Override
    public ScopeKey getParent() {
        if (this.theScopes.length < 2) {
            return null;
        }
        UnmodifiableScopeKey result = new UnmodifiableScopeKey(this.theScopes.length - 1, this.theScopes);
        return result;
    }

    @Override
    public boolean isParent(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        Scope[] keyArray = key.getArray();
        if (keyArray.length < 2) {
            return false;
        }
        if (this.theScopes.length != keyArray.length - 1) {
            return false;
        }
        for (int looper = 0; looper < keyArray.length - 1; ++looper) {
            if (keyArray[looper].equals(this.theScopes[looper])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Scope getScopeLevel(ScopeLevel scopeLevel) {
        if (scopeLevel == null) {
            throw new IllegalArgumentException("Null scope level");
        }
        return this.getScope(scopeLevel);
    }

    @Override
    public String toString() {
        return this.getScopes().toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ScopeKey)) {
            return false;
        }
        ScopeKey other = (ScopeKey)object;
        Object[] otherArray = other.getArray();
        return Arrays.equals(this.theScopes, otherArray);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    @Override
    public void freeze() {
    }

    @Override
    public Scope addScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Null scope");
        }
        throw new IllegalStateException("The scope key is frozen");
    }

    @Override
    public Scope addScope(ScopeLevel level, Object qualifier) {
        throw new IllegalStateException("The scope key is frozen");
    }

    @Override
    public Scope removeScope(Scope scope) {
        throw new IllegalStateException("The scope key is frozen");
    }

    @Override
    public Scope removeScopeLevel(ScopeLevel scopeLevel) {
        throw new IllegalStateException("The scope key is frozen");
    }

    @Override
    public ScopeKey clone() {
        ScopeKey result = super.clone();
        return result;
    }

    private static Scope[] setup(int max, Scope ... scopes) {
        if (max > scopes.length) {
            max = scopes.length;
        }
        Scope[] createdScopes = new Scope[max];
        for (int looper = 0; looper < max; ++looper) {
            createdScopes[looper] = scopes[looper];
        }
        UnmodifiableScopeKey.sort(createdScopes);
        return createdScopes;
    }

    private static void sort(Scope[] scopes) {
        Arrays.sort(scopes);
    }

    @Override
    protected Scope[] getArray() {
        return this.theScopes;
    }

    @Override
    protected Collection<Scope> getScopesCollection() {
        return this.theScopesCollection;
    }
}

