/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.benchmark.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.retrieval.RetrievalUtils;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.metadata.benchmark.support.ClassNoMethodAnnotation1;
import org.jboss.test.metadata.benchmark.support.ClassNoMethodAnnotation2;
import org.jboss.test.metadata.benchmark.support.ClassNoMethodAnnotation3;
import org.jboss.test.metadata.benchmark.support.ClassNoMethodAnnotation4;
import org.jboss.test.metadata.benchmark.support.ClassNoMethodAnnotation5;
import org.jboss.test.metadata.benchmark.support.NullAnnotatedElementMetaDataLoader;
import org.jboss.test.metadata.benchmark.support.OriginalAnnotatedElementMetaDataLoader;
import org.jboss.test.metadata.benchmark.support.SingletonAnnotatedElementMetaDataLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoComponentMetaDataCachingMetaDataContextBenchmark
extends TestCase {
    ClassRetrieval classRetrieval = ClassRetrieval.LATEST;
    BasicMetaDataRepository repository = new BasicMetaDataRepository();
    boolean caching = false;
    int iterations = 1000;
    int count = 1000;

    private MetaDataRetrieval createClassRetrieval(Class<?> clazz) {
        if (this.classRetrieval == ClassRetrieval.NULL) {
            return new NullAnnotatedElementMetaDataLoader(clazz);
        }
        if (this.classRetrieval == ClassRetrieval.SINGLETON) {
            return new SingletonAnnotatedElementMetaDataLoader(clazz);
        }
        if (this.classRetrieval == ClassRetrieval.ORIGINAL) {
            return new OriginalAnnotatedElementMetaDataLoader(clazz);
        }
        if (this.classRetrieval == ClassRetrieval.LATEST) {
            return new AnnotatedElementMetaDataLoader(clazz);
        }
        throw new RuntimeException();
    }

    public void testContexts() {
        List<MetaDataWrapper> data = this.createMetaDatas();
        NoComponentMetaDataCachingMetaDataContextBenchmark.assertEquals((int)this.count, (int)data.size());
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.iterations; ++i) {
            for (MetaDataWrapper wrapper : data) {
                for (Method m : wrapper.getClazz().getDeclaredMethods()) {
                    DeclaredMethodSignature sig = new DeclaredMethodSignature(m);
                    MetaData component = wrapper.getMetaData().getComponentMetaData((Signature)sig);
                    if (component == null || component.isEmpty()) continue;
                    throw new IllegalStateException("Expected null MD");
                }
            }
        }
        System.out.println("------>" + (System.currentTimeMillis() - start));
    }

    private List<MetaDataWrapper> createMetaDatas() {
        ArrayList<MetaDataWrapper> metaDatas = new ArrayList<MetaDataWrapper>();
        MemoryMetaDataLoader jvm = new MemoryMetaDataLoader(new ScopeKey(new Scope(CommonLevels.JVM, (Object)"THIS")));
        for (int i = 0; i < this.count; ++i) {
            ArrayList<Object> retrievals = new ArrayList<Object>();
            retrievals.add(jvm);
            retrievals.add(this.createClassRetrieval(this.getAnnotatedElementClass(i)));
            retrievals.add(new MemoryMetaDataLoader(new ScopeKey(new Scope(CommonLevels.INSTANCE, (Object)("Bean" + i)))));
            AbstractMetaDataContext context = new AbstractMetaDataContext(null, retrievals);
            MetaDataRetrievalToMetaDataBridge metaData = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)context);
            if (this.caching) {
                metaData = RetrievalUtils.createCachedMetaData((MetaData)metaData);
            }
            MetaDataWrapper wrapped = new MetaDataWrapper((MetaData)metaData, this.getAnnotatedElementClass(i));
            metaDatas.add(wrapped);
        }
        return metaDatas;
    }

    private Class<?> getAnnotatedElementClass(int i) {
        int mod = i % 5;
        switch (mod) {
            case 0: {
                return ClassNoMethodAnnotation1.class;
            }
            case 1: {
                return ClassNoMethodAnnotation2.class;
            }
            case 2: {
                return ClassNoMethodAnnotation3.class;
            }
            case 3: {
                return ClassNoMethodAnnotation4.class;
            }
            case 4: {
                return ClassNoMethodAnnotation5.class;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassRetrieval {
        ORIGINAL,
        NULL,
        SINGLETON,
        LATEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataWrapper {
        MetaData metaData;
        Class<?> clazz;

        public MetaDataWrapper(MetaData metaData, Class<?> clazz) {
            this.metaData = metaData;
            this.clazz = clazz;
        }

        public MetaData getMetaData() {
            return this.metaData;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

