/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.benchmark.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Method findMethod(final Class<?> clazz, final String name, final Class<?> ... parameterTypes) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ReflectionUtils.findMethod(clazz, (String)name, (Class[])parameterTypes);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                return ReflectionUtils.findMethod((Class)clazz, (String)name, (Class[])parameterTypes);
            }
        });
    }

    static Field findField(final Class<?> clazz, final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ReflectionUtils.findField(clazz, (String)name);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                return ReflectionUtils.findField((Class)clazz, (String)name);
            }
        });
    }

    static Constructor<?> findConstructor(final Class<?> clazz, final Class<?> ... parameterTypes) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ReflectionUtils.findConstructor(clazz, (Class[])parameterTypes);
        }
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<?>>(){

            @Override
            public Constructor<?> run() {
                return ReflectionUtils.findConstructor((Class)clazz, (Class[])parameterTypes);
            }
        });
    }

    static Method findDeclaredMethod(final Class<?> declaringClass, final String methodName, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return declaringClass.getDeclaredMethod(methodName, parameterTypes);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws NoSuchMethodException {
                    return declaringClass.getDeclaredMethod(methodName, parameterTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (NoSuchMethodException)pae.getException();
        }
    }
}

