/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader;

import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.ExpectedAnnotations;
import org.jboss.test.metadata.shared.support.MetaAnnotation1;
import org.jboss.test.metadata.shared.support.MetaAnnotation2;
import org.jboss.test.metadata.shared.support.MetaDataAndMutableMetaData;
import org.jboss.test.metadata.shared.support.NotPresentAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation1;
import org.jboss.test.metadata.shared.support.TestAnnotation1Impl;
import org.jboss.test.metadata.shared.support.TestAnnotation2;
import org.jboss.test.metadata.shared.support.TestAnnotation2Impl;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public abstract class MutableAnnotationsTest
extends AbstractMetaDataTest {
    public MutableAnnotationsTest(String name) {
        super(name);
    }

    public void testEmpty() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        this.assertValidTimeUnchanged(metaData, last);
    }

    public void testTestAnnotation() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotationImpl(), expectedAnnotations, last);
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        this.assertRemoveAnnotation(metaData, TestAnnotation.class, expectedAnnotations, last);
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
    }

    public void testTestAnnotation12() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation(metaData, TestAnnotation1.class);
        this.assertNoAnnotation(metaData, TestAnnotation2.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotation1Impl(), expectedAnnotations, last);
        this.assertAnnotation(metaData, TestAnnotation1.class);
        this.assertNoAnnotation(metaData, TestAnnotation2.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation1.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotation2Impl(), expectedAnnotations, last);
        this.assertAnnotation(metaData, TestAnnotation1.class);
        this.assertAnnotation(metaData, TestAnnotation2.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation1.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        this.assertRemoveAnnotation(metaData, TestAnnotation1.class, expectedAnnotations, last);
        this.assertNoAnnotation(metaData, TestAnnotation1.class);
        this.assertAnnotation(metaData, TestAnnotation2.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        this.assertRemoveAnnotation(metaData, TestAnnotation2.class, expectedAnnotations, last);
        this.assertNoAnnotation(metaData, TestAnnotation1.class);
        this.assertNoAnnotation(metaData, TestAnnotation2.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
    }

    public void testAddTwice() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotationImpl(), expectedAnnotations, last);
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        last = this.assertAddAnnotationWithPrevious(metaData, new TestAnnotationImpl(), last);
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
    }

    public void testAddTwiceSameObject() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        last = this.assertAddAnnotationNoPrevious(metaData, annotation, expectedAnnotations, last);
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
        this.assertAddAnnotationWithPreviousSameObject(metaData, annotation, last);
        this.assertAnnotation(metaData, TestAnnotation.class);
        this.assertNoAnnotation(metaData, NotPresentAnnotation.class);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        this.assertAllAnnotations(metaData, expectedAnnotations);
    }

    public void testRemoveDoesNotExist() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        this.assertNotRemovedAnnotation(metaData, TestAnnotation.class, last);
        this.assertAllAnnotations(metaData, expectedAnnotations);
    }

    public void testRemoveTwice() throws Exception {
        MetaDataAndMutableMetaData metaData = this.setupEmpty();
        long last = metaData.getValidTime();
        ExpectedAnnotations expectedAnnotations = this.emptyExpectedAnnotations();
        last = this.assertAddAnnotationNoPrevious(metaData, new TestAnnotationImpl(), expectedAnnotations, last);
        this.assertRemoveAnnotation(metaData, TestAnnotation.class, expectedAnnotations, last);
        this.assertNotRemovedAnnotation(metaData, TestAnnotation.class, last);
        this.assertAllAnnotations(metaData, expectedAnnotations);
    }

    protected abstract MetaDataAndMutableMetaData setupEmpty();
}

