/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.repository.test;

import java.util.HashSet;
import java.util.Set;
import org.jboss.metadata.plugins.repository.visitor.FuzzyMetaDataRepositoryVisitor;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.repository.visitor.MetaDataRepositoryVisitor;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;

public abstract class MutableMetaDataRepositoryMatchingTest
extends AbstractMetaDataTest {
    private static ScopeLevel testLevel1 = new ScopeLevel(1, "ONE");
    private static ScopeLevel testLevel2 = new ScopeLevel(2, "TWO");
    private static ScopeLevel testLevel3 = new ScopeLevel(3, "THREE");
    private static ScopeLevel testLevel4 = new ScopeLevel(4, "FOUR");
    private static ScopeLevel testLevel5 = new ScopeLevel(5, "FIVE");
    private static ScopeLevel testLevel6 = new ScopeLevel(6, "FIVE");
    private static String testQualifier1 = "qualifier1";
    private static String testQualifier1x = "qualifier1x";
    private static String testQualifier2 = "qualifier2";
    private static String testQualifier2x = "qualifier2x";
    private static String testQualifier3 = "qualifier3";
    private static String testQualifier4 = "qualifier4";
    private static String testQualifier5 = "qualifier5";
    private static String testQualifier6 = "qualifier6";
    private static Scope testLevel1Qual1 = new Scope(testLevel1, (Object)testQualifier1);
    private static Scope testLevel1Qual1x = new Scope(testLevel1, (Object)testQualifier1x);
    private static Scope testLevel2Qual2 = new Scope(testLevel2, (Object)testQualifier2);
    private static Scope testLevel2Qual2x = new Scope(testLevel2, (Object)testQualifier2x);
    private static Scope testLevel3Qual3 = new Scope(testLevel3, (Object)testQualifier3);
    private static Scope testLevel4Qual4 = new Scope(testLevel4, (Object)testQualifier4);
    private static Scope testLevel5Qual5 = new Scope(testLevel5, (Object)testQualifier5);
    private static Scope testLevel6Qual6 = new Scope(testLevel6, (Object)testQualifier6);
    private static ScopeKey testKey1 = new ScopeKey(testLevel1Qual1);
    private static ScopeKey testKey1x = new ScopeKey(testLevel1Qual1x);
    private static ScopeKey testKey2 = new ScopeKey(testLevel2Qual2);
    private static ScopeKey testKey3 = new ScopeKey(testLevel3Qual3);
    private static ScopeKey testKey12 = new ScopeKey(new Scope[]{testLevel1Qual1, testLevel2Qual2});
    private static ScopeKey testKey13 = new ScopeKey(new Scope[]{testLevel1Qual1, testLevel3Qual3});
    private static ScopeKey testKey14 = new ScopeKey(new Scope[]{testLevel1Qual1, testLevel4Qual4});
    private static ScopeKey testKey15 = new ScopeKey(new Scope[]{testLevel1Qual1, testLevel5Qual5});
    private static ScopeKey testKey16 = new ScopeKey(new Scope[]{testLevel1Qual1, testLevel6Qual6});
    private static ScopeKey testKey23 = new ScopeKey(new Scope[]{testLevel2Qual2, testLevel3Qual3});
    private static ScopeKey testKey2x3 = new ScopeKey(new Scope[]{testLevel2Qual2x, testLevel3Qual3});

    public MutableMetaDataRepositoryMatchingTest(String name) {
        super(name);
    }

    protected abstract MutableMetaDataRepository setupEmpty();

    public void testNoMatchEmpty() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey1);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        MutableMetaDataRepositoryMatchingTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryMatchingTest.assertEquals((int)0, (int)result.size());
    }

    public void testSimpleMatch() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader1);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey2);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader2);
        MutableMetaDataLoader loader3 = this.createTestMutableMetaDataLoader(testKey3);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader3);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey1);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        HashSet<ScopeKey> expected = new HashSet<ScopeKey>();
        expected.add(testKey1);
        MutableMetaDataRepositoryMatchingTest.assertEquals(expected, (Object)result);
    }

    public void testNotSimpleMatch() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader1);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey2);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader2);
        MutableMetaDataLoader loader3 = this.createTestMutableMetaDataLoader(testKey3);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader3);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey1x);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        MutableMetaDataRepositoryMatchingTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryMatchingTest.assertEquals((int)0, (int)result.size());
    }

    public void testNoMatchAgainstSimple() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader1 = this.createTestMutableMetaDataLoader(testKey1);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader1);
        MutableMetaDataLoader loader2 = this.createTestMutableMetaDataLoader(testKey2);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader2);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey3);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        MutableMetaDataRepositoryMatchingTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryMatchingTest.assertEquals((int)0, (int)result.size());
    }

    public void testCompositeMatch() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader23 = this.createTestMutableMetaDataLoader(testKey23);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader23);
        MutableMetaDataLoader loader14 = this.createTestMutableMetaDataLoader(testKey14);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader14);
        MutableMetaDataLoader loader15 = this.createTestMutableMetaDataLoader(testKey15);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader15);
        MutableMetaDataLoader loader16 = this.createTestMutableMetaDataLoader(testKey16);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader16);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey2);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        HashSet<ScopeKey> expected = new HashSet<ScopeKey>();
        expected.add(testKey23);
        MutableMetaDataRepositoryMatchingTest.assertEquals(expected, (Object)result);
    }

    public void testNotCompositeMatch() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader23 = this.createTestMutableMetaDataLoader(testKey23);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader23);
        MutableMetaDataLoader loader14 = this.createTestMutableMetaDataLoader(testKey14);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader14);
        MutableMetaDataLoader loader15 = this.createTestMutableMetaDataLoader(testKey15);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader15);
        MutableMetaDataLoader loader16 = this.createTestMutableMetaDataLoader(testKey16);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader16);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey2x3);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        MutableMetaDataRepositoryMatchingTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryMatchingTest.assertEquals((int)0, (int)result.size());
    }

    public void testNoMatchEmptyAgainstComposite() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader12 = this.createTestMutableMetaDataLoader(testKey12);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader12);
        MutableMetaDataLoader loader14 = this.createTestMutableMetaDataLoader(testKey14);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader14);
        MutableMetaDataLoader loader15 = this.createTestMutableMetaDataLoader(testKey15);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader15);
        MutableMetaDataLoader loader16 = this.createTestMutableMetaDataLoader(testKey16);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader16);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey3);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        MutableMetaDataRepositoryMatchingTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryMatchingTest.assertEquals((int)0, (int)result.size());
    }

    public void testPartialMatch() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader12 = this.createTestMutableMetaDataLoader(testKey12);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader12);
        MutableMetaDataLoader loader13 = this.createTestMutableMetaDataLoader(testKey13);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader13);
        MutableMetaDataLoader loader23 = this.createTestMutableMetaDataLoader(testKey23);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader23);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey1);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        HashSet<ScopeKey> expected = new HashSet<ScopeKey>();
        expected.add(testKey12);
        expected.add(testKey13);
        MutableMetaDataRepositoryMatchingTest.assertEquals(expected, (Object)result);
    }

    public void testNotPartialMatch() throws Exception {
        MutableMetaDataRepository repository = this.setupEmpty();
        MutableMetaDataLoader loader12 = this.createTestMutableMetaDataLoader(testKey12);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader12);
        MutableMetaDataLoader loader13 = this.createTestMutableMetaDataLoader(testKey13);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader13);
        MutableMetaDataLoader loader23 = this.createTestMutableMetaDataLoader(testKey23);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader23);
        FuzzyMetaDataRepositoryVisitor visitor = new FuzzyMetaDataRepositoryVisitor(testKey1x);
        Set result = repository.matchScopes((MetaDataRepositoryVisitor)visitor);
        MutableMetaDataRepositoryMatchingTest.assertNotNull((Object)result);
        MutableMetaDataRepositoryMatchingTest.assertEquals((int)0, (int)result.size());
    }
}

