/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.retrieval.test;

import java.lang.annotation.Annotation;
import org.jboss.metadata.spi.loader.MetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationItem;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
import org.jboss.metadata.spi.retrieval.basic.BasicMetaDataItem;
import org.jboss.metadata.spi.retrieval.basic.BasicMetaDatasItem;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.retrieval.support.TestBasicItemMetaDataLoader;
import org.jboss.test.metadata.shared.support.TestAnnotation1Impl;
import org.jboss.test.metadata.shared.support.TestAnnotation2Impl;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public class BasicUnitTestCase
extends AbstractMetaDataTest {
    public BasicUnitTestCase(String name) {
        super(name);
    }

    public void testBasicAnnotation() throws Exception {
        TestBasicItemMetaDataLoader loader = new TestBasicItemMetaDataLoader();
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        BasicAnnotationItem item = new BasicAnnotationItem((MetaDataLoader)loader, (Annotation)annotation);
        BasicUnitTestCase.assertEquals((Object)annotation, (Object)item.getAnnotation());
        BasicUnitTestCase.assertEquals((Object)annotation, (Object)item.getValue());
        BasicUnitTestCase.assertTrue((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        loader.setCachable(false);
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        item.invalidate();
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertFalse((boolean)item.isValid());
    }

    public void testBasicAnnotations() throws Exception {
        TestBasicItemMetaDataLoader loader = new TestBasicItemMetaDataLoader();
        TestAnnotation1Impl annotation1 = new TestAnnotation1Impl();
        TestAnnotation2Impl annotation2 = new TestAnnotation2Impl();
        BasicAnnotationItem item1 = new BasicAnnotationItem((MetaDataLoader)loader, (Annotation)annotation1);
        BasicAnnotationItem item2 = new BasicAnnotationItem((MetaDataLoader)loader, (Annotation)annotation2);
        Object[] items = new AnnotationItem[]{item1, item2};
        BasicAnnotationsItem item = new BasicAnnotationsItem((MetaDataLoader)loader, (AnnotationItem[])items);
        Object[] result = item.getAnnotations();
        this.assertUnorderedArrayEquals(items, result);
        Object[] expected = new Annotation[]{annotation1, annotation2};
        Object[] annotations = item.getValue();
        this.assertUnorderedArrayEquals(expected, annotations);
        BasicUnitTestCase.assertTrue((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        loader.setCachable(false);
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        item1.invalidate();
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertFalse((boolean)item.isValid());
    }

    public void testBasicMetaData() throws Exception {
        TestBasicItemMetaDataLoader loader = new TestBasicItemMetaDataLoader();
        String object = "Hello";
        BasicMetaDataItem item = new BasicMetaDataItem((MetaDataLoader)loader, String.class.getName(), (Object)object);
        BasicUnitTestCase.assertEquals((String)object, (String)((String)item.getValue()));
        BasicUnitTestCase.assertTrue((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        loader.setCachable(false);
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        item.invalidate();
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertFalse((boolean)item.isValid());
    }

    public void testBasicMetaDatas() throws Exception {
        TestBasicItemMetaDataLoader loader = new TestBasicItemMetaDataLoader();
        Object object1 = new Object();
        String object2 = "Hello";
        BasicMetaDataItem item1 = new BasicMetaDataItem((MetaDataLoader)loader, Object.class.getName(), object1);
        BasicMetaDataItem item2 = new BasicMetaDataItem((MetaDataLoader)loader, String.class.getName(), (Object)object2);
        Object[] items = new MetaDataItem[]{item1, item2};
        BasicMetaDatasItem item = new BasicMetaDatasItem((MetaDataLoader)loader, (MetaDataItem[])items);
        Object[] result = item.getMetaDatas();
        this.assertUnorderedArrayEquals(items, result);
        Object[] expected = new Object[]{object1, object2};
        Object[] objects = item.getValue();
        this.assertUnorderedArrayEquals(expected, objects);
        BasicUnitTestCase.assertTrue((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        loader.setCachable(false);
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertTrue((boolean)item.isValid());
        item.invalidate();
        BasicUnitTestCase.assertFalse((boolean)item.isCachable());
        BasicUnitTestCase.assertFalse((boolean)item.isValid());
    }
}

