/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.retrieval.test;

import java.lang.annotation.Annotation;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.TestAnnotation1;
import org.jboss.test.metadata.shared.support.TestAnnotation1Impl;
import org.jboss.test.metadata.shared.support.TestAnnotation2;
import org.jboss.test.metadata.shared.support.TestAnnotation2Impl;

public class CummulativeUnitTestCase
extends AbstractMetaDataTest {
    public CummulativeUnitTestCase(String name) {
        super(name);
    }

    public void testCummulativeAnnotationsItem() throws Exception {
        MutableMetaDataLoader childLoader;
        MutableMetaDataLoader parentLoader = this.createTestMutableMetaDataLoader();
        AbstractMetaDataContext parent = new AbstractMetaDataContext((MetaDataRetrieval)parentLoader);
        AbstractMetaDataContext child = new AbstractMetaDataContext((MetaDataContext)parent, (MetaDataRetrieval)(childLoader = this.createTestMutableMetaDataLoader()));
        AnnotationsItem item = child.retrieveAnnotations();
        CummulativeUnitTestCase.assertTrue((item.getAnnotations().length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((((Annotation[])item.getValue()).length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((boolean)item.isCachable());
        CummulativeUnitTestCase.assertTrue((boolean)item.isValid());
        TestAnnotation1Impl annotation1 = new TestAnnotation1Impl();
        parentLoader.addAnnotation((Annotation)annotation1);
        AnnotationItem annotationItem1Parent = parentLoader.retrieveAnnotation(TestAnnotation1.class);
        Object[] expectedItems = new AnnotationItem[]{annotationItem1Parent};
        this.assertUnorderedArrayEquals(expectedItems, item.getAnnotations());
        Object[] expected = new Annotation[]{annotation1};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        TestAnnotation2Impl annotation2 = new TestAnnotation2Impl();
        childLoader.addAnnotation((Annotation)annotation2);
        AnnotationItem annotationItem2Child = childLoader.retrieveAnnotation(TestAnnotation2.class);
        expectedItems = new AnnotationItem[]{annotationItem1Parent, annotationItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getAnnotations());
        expected = new Annotation[]{annotation1, annotation2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        TestAnnotation1Impl annotation1Child = new TestAnnotation1Impl();
        childLoader.addAnnotation((Annotation)annotation1Child);
        AnnotationItem annotationItem1Child = childLoader.retrieveAnnotation(TestAnnotation1.class);
        expectedItems = new AnnotationItem[]{annotationItem1Child, annotationItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getAnnotations());
        expected = new Annotation[]{annotation1Child, annotation2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        childLoader.removeAnnotation(TestAnnotation1.class);
        expectedItems = new AnnotationItem[]{annotationItem1Parent, annotationItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getAnnotations());
        expected = new Annotation[]{annotation1, annotation2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        parentLoader.removeAnnotation(TestAnnotation1.class);
        expectedItems = new AnnotationItem[]{annotationItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getAnnotations());
        expected = new Annotation[]{annotation2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        childLoader.removeAnnotation(TestAnnotation2.class);
        CummulativeUnitTestCase.assertTrue((item.getAnnotations().length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((((Annotation[])item.getValue()).length == 0 ? 1 : 0) != 0);
    }

    public void testCummulativeMetaDatasItem() throws Exception {
        MutableMetaDataLoader childLoader;
        MutableMetaDataLoader parentLoader = this.createTestMutableMetaDataLoader();
        AbstractMetaDataContext parent = new AbstractMetaDataContext((MetaDataRetrieval)parentLoader);
        AbstractMetaDataContext child = new AbstractMetaDataContext((MetaDataContext)parent, (MetaDataRetrieval)(childLoader = this.createTestMutableMetaDataLoader()));
        MetaDatasItem item = child.retrieveMetaData();
        CummulativeUnitTestCase.assertTrue((item.getMetaDatas().length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((((Object[])item.getValue()).length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((boolean)item.isCachable());
        CummulativeUnitTestCase.assertTrue((boolean)item.isValid());
        Object object1 = new Object();
        parentLoader.addMetaData(object1, Object.class);
        MetaDataItem metaDataItem1Parent = parentLoader.retrieveMetaData(Object.class);
        Object[] expectedItems = new MetaDataItem[]{metaDataItem1Parent};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        Object[] expected = new Object[]{object1};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        String object2 = "Hello";
        childLoader.addMetaData((Object)object2, String.class);
        MetaDataItem metaDataItem2Child = childLoader.retrieveMetaData(String.class);
        expectedItems = new MetaDataItem[]{metaDataItem1Parent, metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object1, object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        Object object1Child = new Object();
        childLoader.addMetaData(object1Child, Object.class);
        MetaDataItem metaDataItem1Child = childLoader.retrieveMetaData(Object.class);
        expectedItems = new MetaDataItem[]{metaDataItem1Child, metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object1Child, object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        childLoader.removeMetaData(Object.class);
        expectedItems = new MetaDataItem[]{metaDataItem1Parent, metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object1, object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        parentLoader.removeMetaData(Object.class);
        expectedItems = new MetaDataItem[]{metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        childLoader.removeMetaData(String.class);
        CummulativeUnitTestCase.assertTrue((item.getMetaDatas().length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((((Object[])item.getValue()).length == 0 ? 1 : 0) != 0);
    }

    public void testCummulativeMetaDatasItemByName() throws Exception {
        MutableMetaDataLoader childLoader;
        MutableMetaDataLoader parentLoader = this.createTestMutableMetaDataLoader();
        AbstractMetaDataContext parent = new AbstractMetaDataContext((MetaDataRetrieval)parentLoader);
        AbstractMetaDataContext child = new AbstractMetaDataContext((MetaDataContext)parent, (MetaDataRetrieval)(childLoader = this.createTestMutableMetaDataLoader()));
        MetaDatasItem item = child.retrieveMetaData();
        CummulativeUnitTestCase.assertTrue((item.getMetaDatas().length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((((Object[])item.getValue()).length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((boolean)item.isCachable());
        CummulativeUnitTestCase.assertTrue((boolean)item.isValid());
        Object object1 = new Object();
        parentLoader.addMetaData("Object", object1, Object.class);
        MetaDataItem metaDataItem1Parent = parentLoader.retrieveMetaData("Object");
        Object[] expectedItems = new MetaDataItem[]{metaDataItem1Parent};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        Object[] expected = new Object[]{object1};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        String object2 = "Hello";
        childLoader.addMetaData("String", (Object)object2, String.class);
        MetaDataItem metaDataItem2Child = childLoader.retrieveMetaData("String");
        expectedItems = new MetaDataItem[]{metaDataItem1Parent, metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object1, object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        Object object1Child = new Object();
        childLoader.addMetaData("Object", object1Child, Object.class);
        MetaDataItem metaDataItem1Child = childLoader.retrieveMetaData("Object");
        expectedItems = new MetaDataItem[]{metaDataItem1Child, metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object1Child, object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        childLoader.removeMetaData("Object", Object.class);
        expectedItems = new MetaDataItem[]{metaDataItem1Parent, metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object1, object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        parentLoader.removeMetaData("Object", Object.class);
        expectedItems = new MetaDataItem[]{metaDataItem2Child};
        this.assertUnorderedArrayEquals(expectedItems, item.getMetaDatas());
        expected = new Object[]{object2};
        this.assertUnorderedArrayEquals(expected, (Object[])item.getValue());
        childLoader.removeMetaData("String", String.class);
        CummulativeUnitTestCase.assertTrue((item.getMetaDatas().length == 0 ? 1 : 0) != 0);
        CummulativeUnitTestCase.assertTrue((((Object[])item.getValue()).length == 0 ? 1 : 0) != 0);
    }
}

