/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.context.cache.test;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.metadata.plugins.context.CachingMetaDataContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.loader.MetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationItem;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
import org.jboss.test.metadata.context.AbstractMetaDataContextTest;
import org.jboss.test.metadata.context.cache.support.TestMetaDataLoader;
import org.jboss.test.metadata.shared.support.MetaAnnotation1;
import org.jboss.test.metadata.shared.support.MetaAnnotation2;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCacheMetaDataContextUnitTestCase
extends AbstractMetaDataContextTest {
    public SimpleCacheMetaDataContextUnitTestCase(String name) {
        super(name);
    }

    @Override
    protected MetaDataRetrieval createRetrieval() {
        return new TestMetaDataLoader();
    }

    @Override
    protected MetaDataContext createContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals) {
        return new CachingMetaDataContext(parent, retrievals);
    }

    protected TestMetaDataLoader getFirstParent() {
        return (TestMetaDataLoader)this.firstParent;
    }

    protected TestMetaDataLoader getSecondParent() {
        return (TestMetaDataLoader)this.secondParent;
    }

    protected TestMetaDataLoader getFirstChild() {
        return (TestMetaDataLoader)this.firstChild;
    }

    protected TestMetaDataLoader getSecondChild() {
        return (TestMetaDataLoader)this.secondChild;
    }

    protected <T extends Annotation> BasicAnnotationItem<T> createAnnotationItem(TestMetaDataLoader loader, T annotation, Class<T> type) {
        return new BasicAnnotationItem((MetaDataLoader)loader, annotation);
    }

    protected <T extends Annotation> void setAnnotations(TestMetaDataLoader loader, AnnotationItem<T> annotationItem) {
        AnnotationItem[] items = new AnnotationItem[]{annotationItem};
        BasicAnnotationsItem item = new BasicAnnotationsItem((MetaDataLoader)loader, items);
        loader.setAnnotationsItem((AnnotationsItem)item);
    }

    protected void testAnnotation(MetaData metaData, TestMetaDataLoader loader) throws Exception {
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)loader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(loader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(loader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)loader.isRetrieved());
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)loader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)loader.isRetrieved());
        loader.clear();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)loader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)loader.isRetrieved());
    }

    public void testAnnotationFirstChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getFirstChild());
    }

    public void testAnnotationSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getSecondChild());
    }

    public void testAnnotationFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getFirstParent());
    }

    public void testAnnotationSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getSecondParent());
    }

    protected void testBelowAnnotation(MetaData metaData, TestMetaDataLoader aboveLoader, TestMetaDataLoader belowLoader) throws Exception {
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(aboveLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(aboveLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem.invalidate();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        aboveLoader.clear();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
    }

    public void testBelowAnnotationFirstChildSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstChild(), this.getSecondChild());
    }

    public void testBelowAnnotationFirstChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstChild(), this.getFirstParent());
    }

    public void testBelowAnnotationFirstChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstChild(), this.getSecondParent());
    }

    public void testBelowAnnotationSecondChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getSecondChild(), this.getFirstParent());
    }

    public void testBelowAnnotationSecondChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getSecondChild(), this.getSecondParent());
    }

    public void testBelowAnnotationFirstParentSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstParent(), this.getSecondParent());
    }

    protected void testBelowAnnotationWith(MetaData metaData, TestMetaDataLoader aboveLoader, TestMetaDataLoader belowLoader, boolean sameLevel) throws Exception {
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(aboveLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(aboveLoader, (AnnotationItem)annotationItem);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        if (sameLevel) {
            SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        } else {
            SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        }
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem.invalidate();
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        aboveLoader.clear();
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        if (sameLevel) {
            SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        } else {
            SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        }
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
    }

    public void testBelowAnnotationWithFirstChildSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotationWith(metaData, this.getFirstChild(), this.getSecondChild(), true);
    }

    public void testBelowAnnotationWithFirstChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotationWith(metaData, this.getFirstChild(), this.getFirstParent(), false);
    }

    public void testBelowAnnotationWithFirstChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotationWith(metaData, this.getFirstChild(), this.getSecondParent(), false);
    }

    public void testBelowAnnotationWithSecondChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotationWith(metaData, this.getSecondChild(), this.getFirstParent(), false);
    }

    public void testBelowAnnotationWithSecondChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotationWith(metaData, this.getSecondChild(), this.getSecondParent(), false);
    }

    public void testBelowAnnotationWithFirstParentSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotationWith(metaData, this.getFirstParent(), this.getSecondParent(), true);
    }

    protected void testAboveAnnotation(MetaData metaData, TestMetaDataLoader aboveLoader, TestMetaDataLoader belowLoader) throws Exception {
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(aboveLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(aboveLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        aboveLoader.clear();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
    }

    public void testAboveAnnotationFirstChildSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstChild(), this.getSecondChild());
    }

    public void testAboveAnnotationFirstChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstChild(), this.getFirstParent());
    }

    public void testAboveAnnotationFirstChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstChild(), this.getSecondParent());
    }

    public void testAboveAnnotationSecondChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getSecondChild(), this.getFirstParent());
    }

    public void testAboveAnnotationSecondChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getSecondChild(), this.getSecondParent());
    }

    public void testAboveAnnotationFirstParentSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstParent(), this.getSecondParent());
    }

    protected void testAboveAnnotationWith(MetaData metaData, TestMetaDataLoader aboveLoader, TestMetaDataLoader belowLoader, boolean sameLevel) throws Exception {
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(aboveLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(aboveLoader, (AnnotationItem)annotationItem);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        if (sameLevel) {
            SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        } else {
            SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        }
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        aboveLoader.clear();
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        if (sameLevel) {
            SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        } else {
            SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        }
        this.assertAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class, this.expectedAnnotations(TestAnnotation.class));
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation1.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertNoAnnotationsAnnotatedWith(metaData, MetaAnnotation2.class);
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)aboveLoader.isRetrieved());
        SimpleCacheMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
    }

    public void testAboveAnnotationWithFirstChildSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotationWith(metaData, this.getFirstChild(), this.getSecondChild(), true);
    }

    public void testAboveAnnotationWithFirstChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotationWith(metaData, this.getFirstChild(), this.getFirstParent(), false);
    }

    public void testAboveAnnotationWithFirstChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotationWith(metaData, this.getFirstChild(), this.getSecondParent(), false);
    }

    public void testAboveAnnotationWithSecondChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotationWith(metaData, this.getSecondChild(), this.getFirstParent(), false);
    }

    public void testAboveAnnotationWithSecondChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotationWith(metaData, this.getSecondChild(), this.getSecondParent(), false);
    }

    public void testAboveAnnotationWithFirstParentSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotationWith(metaData, this.getFirstParent(), this.getSecondParent(), true);
    }
}

