/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.retrieval.test;

import java.lang.annotation.Annotation;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleMetaDataItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleMetaDatasItem;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.TestAnnotation1Impl;
import org.jboss.test.metadata.shared.support.TestAnnotation2Impl;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public class SimpleUnitTestCase
extends AbstractMetaDataTest {
    public SimpleUnitTestCase(String name) {
        super(name);
    }

    public void testSimpleAnnotation() throws Exception {
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        SimpleAnnotationItem item = new SimpleAnnotationItem((Annotation)annotation);
        SimpleUnitTestCase.assertEquals((Object)annotation, (Object)item.getAnnotation());
        SimpleUnitTestCase.assertEquals((Object)annotation, (Object)item.getValue());
        SimpleUnitTestCase.assertTrue((boolean)item.isCachable());
        SimpleUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testSimpleAnnotations() throws Exception {
        TestAnnotation1Impl annotation1 = new TestAnnotation1Impl();
        TestAnnotation2Impl annotation2 = new TestAnnotation2Impl();
        SimpleAnnotationItem item1 = new SimpleAnnotationItem((Annotation)annotation1);
        SimpleAnnotationItem item2 = new SimpleAnnotationItem((Annotation)annotation2);
        Object[] items = new AnnotationItem[]{item1, item2};
        SimpleAnnotationsItem item = new SimpleAnnotationsItem((AnnotationItem[])items);
        Object[] result = item.getAnnotations();
        this.assertUnorderedArrayEquals(items, result);
        Object[] expected = new Annotation[]{annotation1, annotation2};
        Object[] annotations = item.getValue();
        this.assertUnorderedArrayEquals(expected, annotations);
        SimpleUnitTestCase.assertTrue((boolean)item.isCachable());
        SimpleUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testNoSimpleAnnotations() throws Exception {
        SimpleAnnotationsItem item = SimpleAnnotationsItem.NO_ANNOTATIONS;
        AnnotationItem[] items = item.getAnnotations();
        SimpleUnitTestCase.assertNotNull((Object)items);
        SimpleUnitTestCase.assertEquals((int)0, (int)items.length);
        Annotation[] annotations = (Annotation[])item.getValue();
        SimpleUnitTestCase.assertNotNull((Object)annotations);
        SimpleUnitTestCase.assertEquals((int)0, (int)annotations.length);
        SimpleUnitTestCase.assertTrue((boolean)item.isCachable());
        SimpleUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testSimpleMetaData() throws Exception {
        String object = "Hello";
        SimpleMetaDataItem item = new SimpleMetaDataItem(String.class.getName(), (Object)object);
        SimpleUnitTestCase.assertEquals((String)object, (String)((String)item.getValue()));
        SimpleUnitTestCase.assertTrue((boolean)item.isCachable());
        SimpleUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testSimpleMetaDatas() throws Exception {
        Object object1 = new Object();
        String object2 = "Hello";
        SimpleMetaDataItem item1 = new SimpleMetaDataItem(Object.class.getName(), object1);
        SimpleMetaDataItem item2 = new SimpleMetaDataItem(String.class.getName(), (Object)object2);
        Object[] items = new MetaDataItem[]{item1, item2};
        SimpleMetaDatasItem item = new SimpleMetaDatasItem((MetaDataItem[])items);
        Object[] result = item.getMetaDatas();
        this.assertUnorderedArrayEquals(items, result);
        Object[] expected = new Object[]{object1, object2};
        Object[] objects = item.getValue();
        this.assertUnorderedArrayEquals(expected, objects);
        SimpleUnitTestCase.assertTrue((boolean)item.isCachable());
        SimpleUnitTestCase.assertTrue((boolean)item.isValid());
    }

    public void testNoSimpleMetaDatas() throws Exception {
        SimpleMetaDatasItem item = SimpleMetaDatasItem.NO_META_DATA;
        MetaDataItem[] items = item.getMetaDatas();
        SimpleUnitTestCase.assertNotNull((Object)items);
        SimpleUnitTestCase.assertEquals((int)0, (int)items.length);
        Object[] objects = (Object[])item.getValue();
        SimpleUnitTestCase.assertNotNull((Object)objects);
        SimpleUnitTestCase.assertEquals((int)0, (int)objects.length);
        SimpleUnitTestCase.assertTrue((boolean)item.isCachable());
        SimpleUnitTestCase.assertTrue((boolean)item.isValid());
    }
}

