/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.scope.test;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeLevelUnitTestCase
extends AbstractMetaDataTest {
    public ScopeLevelUnitTestCase(String name) {
        super(name);
    }

    public void testBasicScopeLevel() throws Exception {
        ScopeLevel test = new ScopeLevel(99, "HELLO");
        ScopeLevelUnitTestCase.assertEquals((int)99, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
        ScopeLevelUnitTestCase.assertEquals((int)99, (int)test.hashCode());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.toString());
    }

    public void testScopeLevelEquals() throws Exception {
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        ScopeLevel test2 = new ScopeLevel(1, "HELLO");
        ScopeLevelUnitTestCase.assertEquals((Object)test1, (Object)test2);
        ScopeLevel test3 = new ScopeLevel(1, "DIFFERENT");
        ScopeLevelUnitTestCase.assertEquals((Object)test1, (Object)test3);
    }

    public void testScopeLevelNotEquals() throws Exception {
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        ScopeLevel test2 = new ScopeLevel(2, "HELLO");
        ScopeLevelUnitTestCase.assertFalse((boolean)test1.equals((Object)test2));
    }

    public void testScopeLevelSerialization() throws Exception {
        ScopeLevel test1 = new ScopeLevel(99, "HELLO");
        byte[] bytes = this.serialize((Serializable)test1);
        ScopeLevel test2 = (ScopeLevel)this.deserialize(bytes);
        ScopeLevelUnitTestCase.assertEquals((int)99, (int)test2.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test2.getName());
        ScopeLevelUnitTestCase.assertEquals((int)99, (int)test2.hashCode());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test2.toString());
        ScopeLevelUnitTestCase.assertEquals((Object)test1, (Object)test2);
    }

    public void testScopeLevelComparison() throws Exception {
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        ScopeLevel test2 = new ScopeLevel(2, "HELLO");
        ScopeLevelUnitTestCase.assertTrue((test1.compareTo(test2) < 0 ? 1 : 0) != 0);
        ScopeLevelUnitTestCase.assertTrue((test2.compareTo(test1) > 0 ? 1 : 0) != 0);
        ScopeLevel test3 = new ScopeLevel(3, "HELLO");
        ScopeLevelUnitTestCase.assertTrue((test1.compareTo(test3) < 0 ? 1 : 0) != 0);
        ScopeLevelUnitTestCase.assertTrue((test3.compareTo(test1) > 0 ? 1 : 0) != 0);
        ScopeLevelUnitTestCase.assertTrue((test2.compareTo(test3) < 0 ? 1 : 0) != 0);
        ScopeLevelUnitTestCase.assertTrue((test3.compareTo(test2) > 0 ? 1 : 0) != 0);
        ScopeLevel test4 = new ScopeLevel(1, "HELLO");
        ScopeLevelUnitTestCase.assertTrue((test1.compareTo(test4) == 0 ? 1 : 0) != 0);
        ScopeLevel test5 = new ScopeLevel(1, "DIFFERENT");
        ScopeLevelUnitTestCase.assertTrue((test1.compareTo(test5) == 0 ? 1 : 0) != 0);
    }

    public void testScopeLevelSetBehaviourDuplicates() throws Exception {
        HashSet<ScopeLevel> set = new HashSet<ScopeLevel>();
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        set.add(test1);
        this.checkSet(set);
        ScopeLevel test2 = new ScopeLevel(1, "HELLO");
        set.add(test2);
        this.checkSet(set);
        ScopeLevel test3 = new ScopeLevel(1, "DIFFERENT");
        set.add(test3);
        this.checkSet(set);
    }

    protected void checkSet(HashSet<ScopeLevel> set) throws Exception {
        ScopeLevelUnitTestCase.assertEquals((int)1, (int)set.size());
        ScopeLevel test = set.iterator().next();
        ScopeLevelUnitTestCase.assertEquals((int)1, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
    }

    public void testScopeLevelSet() throws Exception {
        LinkedHashSet<ScopeLevel> set = new LinkedHashSet<ScopeLevel>();
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        set.add(test1);
        ScopeLevel test2 = new ScopeLevel(2, "HELLO");
        set.add(test2);
        ScopeLevel test3 = new ScopeLevel(3, "DIFFERENT");
        set.add(test3);
        ScopeLevelUnitTestCase.assertEquals((int)3, (int)set.size());
        Iterator i = set.iterator();
        ScopeLevel test = (ScopeLevel)i.next();
        ScopeLevelUnitTestCase.assertEquals((int)1, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
        test = (ScopeLevel)i.next();
        ScopeLevelUnitTestCase.assertEquals((int)2, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
        test = (ScopeLevel)i.next();
        ScopeLevelUnitTestCase.assertEquals((int)3, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"DIFFERENT", (String)test.getName());
    }

    public void testScopeLevelMapBehaviourDuplicates() throws Exception {
        HashMap<ScopeLevel, Object> map = new HashMap<ScopeLevel, Object>();
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        map.put(test1, new Object());
        this.checkMap(map);
        ScopeLevel test2 = new ScopeLevel(1, "HELLO");
        map.put(test2, new Object());
        this.checkMap(map);
        ScopeLevel test3 = new ScopeLevel(1, "DIFFERENT");
        map.put(test3, new Object());
        this.checkMap(map);
    }

    protected void checkMap(HashMap<ScopeLevel, Object> map) throws Exception {
        ScopeLevelUnitTestCase.assertEquals((int)1, (int)map.size());
        ScopeLevel test = map.keySet().iterator().next();
        ScopeLevelUnitTestCase.assertEquals((int)1, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
    }

    public void testScopeLevelMap() throws Exception {
        LinkedHashMap<ScopeLevel, Object> map = new LinkedHashMap<ScopeLevel, Object>();
        ScopeLevel test1 = new ScopeLevel(1, "HELLO");
        Object object1 = new Object();
        map.put(test1, object1);
        ScopeLevel test2 = new ScopeLevel(2, "HELLO");
        Object object2 = new Object();
        map.put(test2, object2);
        ScopeLevel test3 = new ScopeLevel(3, "DIFFERENT");
        Object object3 = new Object();
        map.put(test3, object3);
        ScopeLevelUnitTestCase.assertEquals((int)3, (int)map.size());
        Iterator i = map.keySet().iterator();
        ScopeLevel test = (ScopeLevel)i.next();
        ScopeLevelUnitTestCase.assertEquals((int)1, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
        test = (ScopeLevel)i.next();
        ScopeLevelUnitTestCase.assertEquals((int)2, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"HELLO", (String)test.getName());
        test = (ScopeLevel)i.next();
        ScopeLevelUnitTestCase.assertEquals((int)3, (int)test.getLevel());
        ScopeLevelUnitTestCase.assertEquals((String)"DIFFERENT", (String)test.getName());
    }
}

